"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostCss = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
const tailwind_1 = require("./tailwind");
/**
 * Declares a PostCSS dependency with a default config file.
 */
class PostCss {
    constructor(project, options) {
        this.fileName = options?.fileName ?? "postcss.config.json";
        project.addDeps("postcss");
        const config = { plugins: {} };
        if (options?.tailwind ?? true) {
            config.plugins.tailwindcss = {};
            config.plugins.autoprefixer = {};
            this.tailwind = new tailwind_1.TailwindConfig(project, options?.tailwindOptions);
            config.plugins.tailwindcss.config = this.tailwind.fileName;
            project.addDeps("tailwindcss", "autoprefixer");
        }
        this.file = new json_1.JsonFile(project, this.fileName, {
            obj: config,
            marker: false,
        });
        project.npmignore?.exclude(`/${this.fileName}`);
    }
}
exports.PostCss = PostCss;
_a = JSII_RTTI_SYMBOL_1;
PostCss[_a] = { fqn: "projen.web.PostCss", version: "0.65.85" };
//# sourceMappingURL=data:application/json;base64,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