# Youtube/Rumble Podcast Generator

Create audio podcasts from Youtube Channels and Rumble Channels.

Podtube CLI automatically:

- downloads the video from your feed
- extracts the audio to mp3 files
- downloads thumbnail images
- generates an XML RSS feed

**Note:** Rumble entries are generated by parsing HTML which can break easily. Let us know if it breaks.

## Install

**Requires ffmpeg to be installed**

`pipx install ytube-podcast`


## Help

```
USAGE
  podtube <channel_id> <template> [-t] [-f] [-l] [-m] [-r]

ARGUMENTS
    <channel_id>                Channel ID
    <template>                  feed template

OPTIONS
    -t (--type)                 Channel Type (default: youtube)
    -f (--feed)                 output feed (default: feed.xml)
    -l (--limit)                Entry limit (default: 50)
    -m (--media)                media output directory (default: media)
    -r (--redownload)           Re-Download All Files (default: False)
```

## Examples

**Youtube**

```
podtube adbcd123-N3SHwntLU2xfkaA static/tpl.xml -f static/rss.xml -m static/podcast/
```

**Rumble**

```
podtube my-channel-id static/tpl.xml -t rumble -f static/rss.xml -m static/podcast/
```

## Feed Templates

See [example-rss.xml](example-rss.xml) for a full rendered XML example.

[Liquid Templates](https://jg-rp.github.io/liquid/) are used to generate your feed. See [example-tpl.xml](example-tpl.xml) for an example template.
