COMMENT ON COLUMN rated_events.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN rated_events.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN products.archived_at IS 'A timestamp for when this object was archived.';
COMMENT ON COLUMN rated_events.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN price_spans.pricing_metadata IS 'A JSON object that contains custom logic for pricing (user defined).';
COMMENT ON COLUMN rated_events.customer_alias IS 'An alternative identifier for the customer object to be used within metering.';
COMMENT ON COLUMN rated_events.received_at IS 'A timestamp for when an event was logged by the system.';

COMMENT ON COLUMN products.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN price_spans.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN list_prices.start_period IS 'An integer that determines what period the object will begin to be applied.';

COMMENT ON COLUMN dates.month_end IS 'A date that is the last day of the specific month';
COMMENT ON COLUMN prices.pricebook_uid IS 'An identifier referencing a unique pricebook row. Refers to ``pricebooks.id``.';
COMMENT ON COLUMN price_spans.proration_start IS 'A timestamp that represents the start of the proration range. This timestamp is inclusive.';
COMMENT ON COLUMN rated_events.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN rated_events.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN rated_events.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN contracts.voided_at IS 'A timestamp for when this object was voided.';
COMMENT ON COLUMN rated_events.contract_id IS 'An identifier referencing a contract. Refers to ``contracts.durable_id``.';
COMMENT ON COLUMN rated_events.product_type IS 'A string that refers to the type of product (``"FIXED"``, ``"EVENT"``, etc).';
COMMENT ON COLUMN price_spans.proration_end IS 'A timestamp that represents the end of the proration range. This timestamp is exclusive.';
COMMENT ON COLUMN products.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN rated_events.price IS 'A string that determines the rate of this object.';
COMMENT ON COLUMN prices.invoice_schedule IS 'An integer for the number of months in a billing or service period.';
COMMENT ON COLUMN rated_events.properties IS 'A JSON object that contains data about the event it is tied to.';
COMMENT ON COLUMN rated_events.status IS 'A string that represents the current state of the rated document (``"FINALIZED"``, ``"DRAFT"``, ``"VOID"``).';
COMMENT ON COLUMN products.ptype IS 'A string that defines the type of product (``"FIXED"``, ``"EVENT"``, etc).';
COMMENT ON COLUMN contracts.void IS 'A boolean that signifies whether or not to ignore the object.';
COMMENT ON COLUMN products.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN price_spans.fixed_quantity IS 'A decimal that defines a static count of a product being sold.';
COMMENT ON COLUMN rated_events.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN rated_events.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN rated_events.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN rated_events.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN list_prices.end_period IS 'An integer that determines what period the object will stop being applied.';
COMMENT ON COLUMN price_spans.contract_uid IS 'An identifier referencing a unique contract row. Refers to ``contracts.id``.';
COMMENT ON COLUMN rated_events.contract_price_uid IS 'An identifier referencing a unique contract price row. Refers to ``contract_prices.id``.';
COMMENT ON COLUMN rated_events.quantity IS 'A decimal that refers to the number of products consumed or purchased.';
COMMENT ON COLUMN pricebooks.billing_target IS 'A string that defines what billing provider an invoice is sent to.';
COMMENT ON COLUMN products.event_name IS 'A string that is matched on ``$.properties.name``, on each event, to help filter usage.';
COMMENT ON COLUMN products.filters IS 'A JSON blob that contains different constraints based on event fields.';
COMMENT ON COLUMN pricebooks.durable_id IS 'An identifier for looking up or referencing this specific object. It will not change over time.';
COMMENT ON COLUMN price_spans.pricebook_id IS 'An identifier referencing a pricebook. Refers to ``pricebooks.durable_id``.';
COMMENT ON COLUMN rated_events.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN rated_events.list_price_uid IS 'An identifier referencing a unique list price row. Refers to ``list_prices.id``.';
COMMENT ON COLUMN dates.month_start IS 'A date that is the first day of the specific month';
COMMENT ON COLUMN rated_events.transaction_id IS 'An identifier for looking up or referencing a specific event that occurred.';
COMMENT ON COLUMN rated_events.metered_at IS 'A timestamp for when an event should be metered by the business system.';
COMMENT ON COLUMN invoices.total IS 'A decimal that is the aggregate of all related line items related the invoice.';
COMMENT ON COLUMN rated_events.amount IS 'A decimal that is the result of price * quantity.';
COMMENT ON COLUMN products.agg_property IS 'A string that is a key within ``$.properties``. This property will be aggregated to determine usage.';
COMMENT ON COLUMN products.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN products.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN pricebooks.archived_at IS 'A timestamp for when this object was archived.';
COMMENT ON COLUMN price_spans.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN prices.pricing_metadata IS 'A JSON object that contains custom logic for pricing (user defined).';
COMMENT ON COLUMN processed_events.customer_alias IS 'An alternative identifier for the customer object to be used within metering.';
COMMENT ON COLUMN processed_events.received_at IS 'A timestamp for when an event was logged by the system.';
COMMENT ON COLUMN pricebooks.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN prices.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN contract_prices.start_period IS 'An integer that determines what period the object will begin to be applied.';
COMMENT ON COLUMN list_prices.pricebook_uid IS 'An identifier referencing a unique pricebook row. Refers to ``pricebooks.id``.';
COMMENT ON COLUMN products.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN products.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN processed_events.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN price_spans.contract_id IS 'An identifier referencing a contract. Refers to ``contracts.durable_id``.';
COMMENT ON COLUMN price_spans.product_type IS 'A string that refers to the type of product (``"FIXED"``, ``"EVENT"``, etc).';
COMMENT ON COLUMN pricebooks.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN price_spans.price IS 'A string that determines the rate of this object.';
COMMENT ON COLUMN pricebooks.invoice_schedule IS 'An integer for the number of months in a billing or service period.';
COMMENT ON COLUMN processed_events.properties IS 'A JSON object that contains data about the event it is tied to.';
COMMENT ON COLUMN line_items.status IS 'A string that represents the current state of the rated document (``"FINALIZED"``, ``"DRAFT"``, ``"VOID"``).';
COMMENT ON COLUMN pricebooks.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN prices.fixed_quantity IS 'A decimal that defines a static count of a product being sold.';
COMMENT ON COLUMN price_spans.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN price_spans.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN price_spans.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN price_spans.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN contract_prices.end_period IS 'An integer that determines what period the object will stop being applied.';
COMMENT ON COLUMN prices.contract_uid IS 'An identifier referencing a unique contract row. Refers to ``contracts.id``.';
COMMENT ON COLUMN price_spans.contract_price_uid IS 'An identifier referencing a unique contract price row. Refers to ``contract_prices.id``.';
COMMENT ON COLUMN matched_events.quantity IS 'A decimal that refers to the number of products consumed or purchased.';
COMMENT ON COLUMN customers.durable_id IS 'An identifier for looking up or referencing this specific object. It will not change over time.';
COMMENT ON COLUMN contracts.pricebook_id IS 'An identifier referencing a pricebook. Refers to ``pricebooks.durable_id``.';
COMMENT ON COLUMN price_spans.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN price_spans.list_price_uid IS 'An identifier referencing a unique list price row. Refers to ``list_prices.id``.';
COMMENT ON COLUMN processed_events.transaction_id IS 'An identifier for looking up or referencing a specific event that occurred.';
COMMENT ON COLUMN processed_events.metered_at IS 'A timestamp for when an event should be metered by the business system.';
COMMENT ON COLUMN line_items.amount IS 'A decimal that is the result of price * quantity.';
COMMENT ON COLUMN pricebooks.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN pricebooks.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN customers.archived_at IS 'A timestamp for when this object was archived.';
COMMENT ON COLUMN prices.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN list_prices.pricing_metadata IS 'A JSON object that contains custom logic for pricing (user defined).';
COMMENT ON COLUMN matched_events.customer_alias IS 'An alternative identifier for the customer object to be used within metering.';
COMMENT ON COLUMN matched_events.received_at IS 'A timestamp for when an event was logged by the system.';
COMMENT ON COLUMN organizations.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN pricebooks.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN pricebooks.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN pricebooks.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN price_spans.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN line_items.contract_id IS 'An identifier referencing a contract. Refers to ``contracts.durable_id``.';
COMMENT ON COLUMN prices.product_type IS 'A string that refers to the type of product (``"FIXED"``, ``"EVENT"``, etc).';
COMMENT ON COLUMN organizations.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN prices.price IS 'A string that determines the rate of this object.';
COMMENT ON COLUMN list_prices.invoice_schedule IS 'An integer for the number of months in a billing or service period.';
COMMENT ON COLUMN matched_events.properties IS 'A JSON object that contains data about the event it is tied to.';
COMMENT ON COLUMN invoices.status IS 'A string that represents the current state of the rated document (``"FINALIZED"``, ``"DRAFT"``, ``"VOID"``).';
COMMENT ON COLUMN list_prices.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN list_prices.fixed_quantity IS 'A decimal that defines a static count of a product being sold.';
COMMENT ON COLUMN prices.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN prices.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN prices.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN prices.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN contract_prices.contract_uid IS 'An identifier referencing a unique contract row. Refers to ``contracts.id``.';
COMMENT ON COLUMN prices.contract_price_uid IS 'An identifier referencing a unique contract price row. Refers to ``contract_prices.id``.';
COMMENT ON COLUMN line_items.quantity IS 'A decimal that refers to the number of products consumed or purchased.';
COMMENT ON COLUMN contracts.durable_id IS 'An identifier for looking up or referencing this specific object. It will not change over time.';
COMMENT ON COLUMN prices.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN prices.list_price_uid IS 'An identifier referencing a unique list price row. Refers to ``list_prices.id``.';
COMMENT ON COLUMN matched_events.transaction_id IS 'An identifier for looking up or referencing a specific event that occurred.';
COMMENT ON COLUMN matched_events.metered_at IS 'A timestamp for when an event should be metered by the business system.';
COMMENT ON COLUMN organizations.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN list_prices.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN contracts.archived_at IS 'A timestamp for when this object was archived.';
COMMENT ON COLUMN pricebooks.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN contract_prices.pricing_metadata IS 'A JSON object that contains custom logic for pricing (user defined).';
COMMENT ON COLUMN events.customer_alias IS 'An alternative identifier for the customer object to be used within metering.';
COMMENT ON COLUMN events.received_at IS 'A timestamp for when an event was logged by the system.';
COMMENT ON COLUMN environments.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN list_prices.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN list_prices.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN list_prices.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN matched_events.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN invoices.contract_id IS 'An identifier referencing a contract. Refers to ``contracts.durable_id``.';
COMMENT ON COLUMN matched_events.product_type IS 'A string that refers to the type of product (``"FIXED"``, ``"EVENT"``, etc).';
COMMENT ON COLUMN list_prices.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN list_prices.price IS 'A string that determines the rate of this object.';
COMMENT ON COLUMN contract_prices.invoice_schedule IS 'An integer for the number of months in a billing or service period.';
COMMENT ON COLUMN events.properties IS 'A JSON object that contains data about the event it is tied to.';
COMMENT ON COLUMN customers.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN contract_prices.fixed_quantity IS 'A decimal that defines a static count of a product being sold.';
COMMENT ON COLUMN line_items.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN line_items.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN pricebooks.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN pricebooks.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN line_items.contract_price_uid IS 'An identifier referencing a unique contract price row. Refers to ``contract_prices.id``.';
COMMENT ON COLUMN matched_events.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN line_items.list_price_uid IS 'An identifier referencing a unique list price row. Refers to ``list_prices.id``.';
COMMENT ON COLUMN events.transaction_id IS 'An identifier for looking up or referencing a specific event that occurred.';
COMMENT ON COLUMN events.metered_at IS 'A timestamp for when an event should be metered by the business system.';
COMMENT ON COLUMN list_prices.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN line_items.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN list_prices.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN customers.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN contract_prices.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN line_items.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN line_items.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN events.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN line_items.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN contract_prices.price IS 'A string that determines the rate of this object.';
COMMENT ON COLUMN contract_prices.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN invoices.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN invoices.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN line_items.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN line_items.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN list_prices.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN contract_prices.list_price_uid IS 'An identifier referencing a unique list price row. Refers to ``list_prices.id``.';
COMMENT ON COLUMN line_items.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN invoices.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN line_items.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN branches.name IS 'A string that respresents what this object is called.';
COMMENT ON COLUMN contracts.prorate IS 'A boolean that determines whether or not proration is applied to the object.';
COMMENT ON COLUMN invoices.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN invoices.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN contracts.customer_id IS 'An identifier referencing a customer. Refers to ``customers.durable_id``.';
COMMENT ON COLUMN invoices.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN contracts.version IS 'An incrementing integer which denotes the most up to date object associated with an ID.';
COMMENT ON COLUMN contract_prices.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN contract_prices.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN customers.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN customers.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN line_items.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN invoices.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN events.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN invoices.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN events.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN events.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN environments.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN contracts.started_at IS 'A timestamp that represents the beginning of the objects billing period. This timestamp is inclusive.';
COMMENT ON COLUMN contracts.ended_at IS 'A timestamp that represents the completion of the objects billing period. This timestamp is exclusive.';
COMMENT ON COLUMN contracts.effective_at IS 'A timestamp that represents the beginning of the objects active period. This timestamp is inclusive.';
COMMENT ON COLUMN contracts.ineffective_at IS 'A timestamp that represents the completion of the objects active period. This timestamp is exclusive.';
COMMENT ON COLUMN contract_prices.product_uid IS 'An identifier referencing a unique product row. Refers to ``product.id``.';
COMMENT ON COLUMN environments.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN customers.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN contract_prices.invoice_delivery IS 'A string that represents if the invoice will be delivered at the beginning of the month, "ADVANCED", or at the end of the month, "ARREARS"';
COMMENT ON COLUMN environments.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN customers.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN customers.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN customers.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN contract_prices.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN customers.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN contract_prices.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN contract_prices.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN contract_prices.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN contracts.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN contract_prices.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN contracts.branch_id IS 'An identifier referencing the branch related to this object.';
COMMENT ON COLUMN contracts.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN contracts.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN branches.env_id IS 'An identifier referencing the environment related to this object.';
COMMENT ON COLUMN contracts.org_id IS 'An identifier referencing the organization related to this object.';
COMMENT ON COLUMN branches.created_at IS 'A timestamp for when this row was first created.';
COMMENT ON COLUMN branches.id IS 'An identifier for looking up or referencing this specific object.';
COMMENT ON COLUMN branches.org_id IS 'An identifier referencing the organization related to this object.';
