# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

import tracdap.rt.metadata as metadata
from .common import *  # noqa
from .tenant import *  # noqa


class RoutingProtocol(_enum.Enum):

    PROTOCOL_NOT_SET = 0

    HTTP = 1

    GRPC = 2

    GRPC_WEB = 3

    REST = 4

    INTERNAL = 5


class DeploymentLayout(_enum.Enum):

    LAYOUT_NOT_SET = 0

    SANDBOX = 1

    HOSTED = 2

    CUSTOM = 3


@_dc.dataclass
class PlatformConfig:

    config: "_tp.Dict[str, str]" = _dc.field(default_factory=dict)

    platformInfo: "PlatformInfo" = _dc.field(default_factory=lambda: PlatformInfo())

    metadataStore: "PluginConfig" = _dc.field(default_factory=lambda: PluginConfig())

    jobCache: "PluginConfig" = _dc.field(default_factory=lambda: PluginConfig())

    executor: "PluginConfig" = _dc.field(default_factory=lambda: PluginConfig())

    services: "_tp.Dict[str, ServiceConfig]" = _dc.field(default_factory=dict)

    deployment: "DeploymentConfig" = _dc.field(default_factory=lambda: DeploymentConfig())

    gateway: "GatewayConfig" = _dc.field(default_factory=lambda: GatewayConfig())

    extensions: "_tp.Dict[str, protobuf.Any]" = _dc.field(default_factory=dict)

    setupTasks: "_tp.Dict[str, PluginConfig]" = _dc.field(default_factory=dict)


@_dc.dataclass
class GatewayConfig:

    routes: "_tp.List[RouteConfig]" = _dc.field(default_factory=list)

    redirects: "_tp.List[GatewayRedirect]" = _dc.field(default_factory=list)


@_dc.dataclass
class GatewayRedirect:

    source: "str" = ""

    target: "str" = ""

    status: "int" = 0


@_dc.dataclass
class RouteConfig:

    routeName: "str" = ""

    routeType: "RoutingProtocol" = RoutingProtocol.PROTOCOL_NOT_SET

    protocols: "_tp.List[RoutingProtocol]" = _dc.field(default_factory=list)

    match: "RoutingMatch" = _dc.field(default_factory=lambda: RoutingMatch())

    target: "RoutingTarget" = _dc.field(default_factory=lambda: RoutingTarget())

    routeKey: "str" = ""


@_dc.dataclass
class RoutingMatch:

    host: "str" = ""

    path: "str" = ""


@_dc.dataclass
class RoutingTarget:

    scheme: "str" = ""

    host: "str" = ""

    port: "int" = 0

    path: "str" = ""

    hostAlias: "_tp.Optional[str]" = None


@_dc.dataclass
class DeploymentConfig:

    layout: "DeploymentLayout" = DeploymentLayout.LAYOUT_NOT_SET
