# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .object_id import *  # noqa
from .resource import *  # noqa


class ConfigType(_enum.Enum):

    """Enumeration of available config types"""

    CONFIG_TYPE_NOT_SET = 0

    PROPERTIES = 1

    """A key-value properties map, follows the convention used for .properties files"""


@_dc.dataclass
class ConfigEntry:

    """Represents the mapping of a config key to a config object."""

    configClass: "str" = ""

    """Config class for this config entry."""

    configKey: "str" = ""

    """Config key for this config entry."""

    configVersion: "int" = 0

    """Version of the config entry."""

    configTimestamp: "DatetimeValue" = _dc.field(default_factory=lambda: DatetimeValue())

    """Timestamp for when this version of the config entry was created."""

    isLatestConfig: "bool" = False

    """Flag indicating whether this is the latest version of the config entry."""

    configDeleted: "bool" = False

    """Flag indicating whether this config entry has been deleted."""

    details: "_tp.Optional[ConfigDetails]" = None

    """Describes the content of this config entry, can be used for list / summary views (optional)."""


@_dc.dataclass
class ConfigDetails:

    """
    Summary content of a config entry.
    
    .. seealso::
        :py:obj:`ConfigEntry <ConfigEntry>`
    """

    objectSelector: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    """Selector for the metadata object holding the content of this config entry."""

    objectType: "ObjectType" = ObjectType.OBJECT_TYPE_NOT_SET

    """Type of the metadata object referred to by this config entry."""

    configType: "_tp.Optional[ConfigType]" = None

    """Indicate the config type (for CONFIG objects only)"""

    resourceType: "_tp.Optional[ResourceType]" = None

    """Indicate the resource type (for RESOURCE objects only)"""


@_dc.dataclass
class ConfigDefinition:

    """Definition of an individual config entry"""

    configType: "ConfigType" = ConfigType.CONFIG_TYPE_NOT_SET

    """The type of this config entry"""

    properties: "_tp.Dict[str, str]" = _dc.field(default_factory=dict)

    """The map of config properties (only available for PROPERTIES config entries)"""
