# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .object_id import *  # noqa


class SchemaType(_enum.Enum):

    """
    Enumeration of the available schema types
    
    .. seealso::
        :py:obj:`SchemaDefinition <SchemaDefinition>`
    """

    SCHEMA_TYPE_NOT_SET = 0

    TABLE_SCHEMA = 1

    """Tabular data"""

    TABLE = 1

    """Alias for TABLE_SCHEMA (for compatibility with early versions of TRAC)"""

    STRUCT_SCHEMA = 2

    """Structured objects"""


class PartType(_enum.Enum):

    """Partitioning scheme applied to a dataset"""

    PART_ROOT = 0

    """Dataset has a single partition called the root partition (this is the default)"""

    NOT_PARTITIONED = 0

    PART_BY_RANGE = 1

    """Partition by range over an ordered variable (not available yet)"""

    PART_BY_VALUE = 2

    """Partition by value over a categorical variable (not available yet)"""


@_dc.dataclass
class FieldSchema:

    """
    Schema for an individual field in a tabular dataset
    
    .. seealso::
        :py:obj:`TableSchema <TableSchema>`
    """

    fieldName: "str" = ""

    fieldOrder: "int" = 0

    fieldType: "BasicType" = BasicType.BASIC_TYPE_NOT_SET

    label: "str" = ""

    businessKey: "bool" = False

    categorical: "bool" = False

    notNull: "bool" = False

    formatCode: "_tp.Optional[str]" = None

    defaultValue: "_tp.Optional[Value]" = None

    namedType: "_tp.Optional[str]" = None

    namedEnum: "_tp.Optional[str]" = None

    children: "_tp.List[FieldSchema]" = _dc.field(default_factory=list)


@_dc.dataclass
class EnumValues:

    """Values for a named enum in a dataset"""

    values: "_tp.List[str]" = _dc.field(default_factory=list)


@_dc.dataclass
class TableSchema:

    """Schema for a tabular dataset"""

    fields: "_tp.List[FieldSchema]" = _dc.field(default_factory=list)


@_dc.dataclass
class StructSchema:

    """Schema for a structured object dataset"""

    fields: "_tp.List[FieldSchema]" = _dc.field(default_factory=list)


@_dc.dataclass
class SchemaDefinition:

    """
    A schema definition describes the schema of a dataset
    
    Schema definitions can be top level objects (a type of object definition),
    in which case they can be referred to by multiple data definitions. Alternatively
    they can be embedded in a data definition to create datasets with one-off schemas.
    
    A table schema describes the schema of a tabular data set. Other schema types may
    be added later, e.g. for matrices, tensors, curves, surfaces and structured datasets.
    
    .. seealso::
        :py:obj:`DataDefinition <DataDefinition>`
    """

    schemaType: "SchemaType" = SchemaType.SCHEMA_TYPE_NOT_SET

    partType: "PartType" = PartType.PART_ROOT

    table: "_tp.Optional[TableSchema]" = None

    struct: "_tp.Optional[StructSchema]" = None

    namedTypes: "_tp.Dict[str, SchemaDefinition]" = _dc.field(default_factory=dict)

    namedEnums: "_tp.Dict[str, EnumValues]" = _dc.field(default_factory=dict)


@_dc.dataclass
class PartKey:

    """Partition key for tabular datasets"""

    opaqueKey: "str" = ""

    partType: "PartType" = PartType.PART_ROOT

    partValues: "_tp.List[Value]" = _dc.field(default_factory=list)

    partRangeMin: "_tp.Optional[Value]" = None

    partRangeMax: "_tp.Optional[Value]" = None


@_dc.dataclass
class DataDelta:

    """Incremental change applied to a data snapshot, allowing partitions to evolve over time"""

    deltaIndex: "int" = 0

    dataItem: "str" = ""

    physicalRowCount: "int" = 0

    deltaRowCount: "int" = 0


@_dc.dataclass
class DataSnapshot:

    """Snapshot of a data partition"""

    snapIndex: "int" = 0

    deltas: "_tp.List[DataDelta]" = _dc.field(default_factory=list)


@_dc.dataclass
class DataPartition:

    """Partition of a dataset"""

    partKey: "PartKey" = _dc.field(default_factory=lambda: PartKey())

    snap: "DataSnapshot" = _dc.field(default_factory=lambda: DataSnapshot())


@_dc.dataclass
class DataDefinition:

    """Define a dataset that can be stored and managed in the TRAC platform"""

    schemaId: "_tp.Optional[TagSelector]" = None

    schema: "_tp.Optional[SchemaDefinition]" = None

    parts: "_tp.Dict[str, DataPartition]" = _dc.field(default_factory=dict)

    storageId: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    rowCount: "int" = 0
