# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .model import *  # noqa
from .search import *  # noqa
from .tag_update import *  # noqa


class FlowNodeType(_enum.Enum):

    """
    Specify the type of an individual flow node
    
    .. seealso::
        :py:obj:`FlowNode <FlowNode>`
    """

    NODE_TYPE_NOT_SET = 0

    INPUT_NODE = 1

    """Input nodes described inputs to the flow, such as a files or datasets"""

    OUTPUT_NODE = 2

    """Output nodes describe outputs the flow produces, such as a files or datasets"""

    MODEL_NODE = 3

    """Model nodes are placeholders for TRAC models that will be supplied at runtime"""

    PARAMETER_NODE = 4

    """Parameter nodes allow explicit mapping of parameters into models
    (TRAC can infer parameters by name if they are not defined explicitly)
    """


@_dc.dataclass
class FlowNode:

    """
    Describes an individual node in a flow
    
    .. seealso::
        :py:obj:`FlowDefinition <FlowDefinition>`
    """

    nodeType: "FlowNodeType" = FlowNodeType.NODE_TYPE_NOT_SET

    parameters: "_tp.List[str]" = _dc.field(default_factory=list)

    inputs: "_tp.List[str]" = _dc.field(default_factory=list)

    outputs: "_tp.List[str]" = _dc.field(default_factory=list)

    nodeSearch: "SearchExpression" = _dc.field(default_factory=lambda: SearchExpression())

    nodeAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)

    nodeProps: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    label: "str" = ""


@_dc.dataclass
class FlowSocket:

    """
    A socket is a point of connection for wiring up the edges in a flow
    
    For parameter, input and output nodes the socket is just the node name and the socket field will be blank.
    For models, the node name refers to a model node and the socket is the name of the parameter, input or output
    being connected. E.g. these two sockets could be used to connect a flow input to a model, using an edge::
    
      flow_input_socket = { "node": "my_input_dataset", socket: "" }
      model_input_socket = { "node": "my_model", "socket": "input_1" }.
    
    .. seealso::
        :py:obj:`FlowEdge <FlowEdge>`
    """

    node: "str" = ""

    socket: "str" = ""


@_dc.dataclass
class FlowEdge:

    """
    A connection between two nodes in a flow
    
    .. seealso::
        :py:obj:`FlowSocket <FlowSocket>`
    """

    source: "FlowSocket" = _dc.field(default_factory=lambda: FlowSocket())

    target: "FlowSocket" = _dc.field(default_factory=lambda: FlowSocket())


@_dc.dataclass
class FlowDefinition:

    """
    A flow defines an execution graph as a set of connections between models and data
    
    A flow describes the shape of the execution graph, it does not fix in advance the set
    of models and datasets that will go into it. When a RUN_FLOW job is created, the job
    matches the flow with a set of models, inputs, outputs and parameters.
    
    .. seealso::
        :py:obj:`JobDefinition <JobDefinition>`
    """

    nodes: "_tp.Dict[str, FlowNode]" = _dc.field(default_factory=dict)

    edges: "_tp.List[FlowEdge]" = _dc.field(default_factory=list)

    parameters: "_tp.Dict[str, ModelParameter]" = _dc.field(default_factory=dict)

    inputs: "_tp.Dict[str, ModelInputSchema]" = _dc.field(default_factory=dict)

    outputs: "_tp.Dict[str, ModelOutputSchema]" = _dc.field(default_factory=dict)
