# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .object_id import *  # noqa
from .tag_update import *  # noqa


class JobType(_enum.Enum):

    """Specify the type of an individual TRAC job"""

    JOB_TYPE_NOT_SET = 0

    RUN_MODEL = 1

    """Run a single model, with parameters and inputs"""

    RUN_FLOW = 2

    """Run a flow with all its models, parameters and inputs"""

    IMPORT_MODEL = 3

    """Import a model into the platform"""

    IMPORT_DATA = 4

    """Import data into the platform"""

    EXPORT_DATA = 5

    """Export data to external locations"""

    JOB_GROUP = 6

    """A job built from a collection of other jobs"""


class JobStatusCode(_enum.Enum):

    """Indicate the status of a job in the TRAC platform"""

    JOB_STATUS_CODE_NOT_SET = 0

    PREPARING = 1

    """The job is being set up"""

    VALIDATED = 2

    """The job has passed validation and is ok to run (dry-run operations may return this status)"""

    PENDING = 3

    """The job is being set up"""

    QUEUED = 4

    """The job is queued in TRAC, waiting for available resources"""

    SUBMITTED = 5

    """The job has been submitted for execution but has not yet started"""

    RUNNING = 6

    """The job is currently running"""

    FINISHING = 7

    """Job execution completed, the platform is cleaning up and validating the outputs"""

    SUCCEEDED = 8

    """The job completed successfully and the results are available"""

    FAILED = 9

    """The job failed and has been terminated or rejected"""

    CANCELLED = 10

    """The job was cancelled by a user of the platform"""


class JobGroupType(_enum.Enum):

    """Specify the group type for a JOB_GROUP job"""

    JOB_GROUP_TYPE_NOT_SET = 0

    SEQUENTIAL_JOB_GROUP = 1

    PARALLEL_JOB_GROUP = 2


@_dc.dataclass
class JobDefinition:

    """Define a job to run on the TRAC platform"""

    jobType: "JobType" = JobType.JOB_TYPE_NOT_SET

    runModel: "_tp.Optional[RunModelJob]" = None

    runFlow: "_tp.Optional[RunFlowJob]" = None

    importModel: "_tp.Optional[ImportModelJob]" = None

    importData: "_tp.Optional[ImportDataJob]" = None

    exportData: "_tp.Optional[ExportDataJob]" = None

    jobGroup: "_tp.Optional[JobGroup]" = None

    resultId: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())


@_dc.dataclass
class ResultDefinition:

    """Define the result of a job after it has completed"""

    jobId: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    statusCode: "JobStatusCode" = JobStatusCode.JOB_STATUS_CODE_NOT_SET

    statusMessage: "str" = ""

    logFileId: "_tp.Optional[TagSelector]" = None

    outputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)


@_dc.dataclass
class RunModelJob:

    """Specification for a RuN_MODEL job"""

    model: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    parameters: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    inputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    priorOutputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)


@_dc.dataclass
class RunFlowJob:

    """Specification for a RUN_FLOW job"""

    flow: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    parameters: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    inputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    priorOutputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    models: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)


@_dc.dataclass
class ImportModelJob:

    """Specification for an IMPORT_MODEL job"""

    language: "str" = ""

    repository: "str" = ""

    packageGroup: "_tp.Optional[str]" = None

    package: "str" = ""

    version: "str" = ""

    entryPoint: "str" = ""

    path: "str" = ""

    modelAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)


@_dc.dataclass
class ImportDataJob:

    """Specification for an IMPORT_DATA job"""

    model: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    parameters: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    inputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    priorOutputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    storageAccess: "_tp.List[str]" = _dc.field(default_factory=list)

    imports: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)

    importAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)


@_dc.dataclass
class ExportDataJob:

    """Specification for an EXPORT_DATA job"""

    model: "TagSelector" = _dc.field(default_factory=lambda: TagSelector())

    parameters: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    inputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    priorOutputs: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    storageAccess: "_tp.List[str]" = _dc.field(default_factory=list)

    exports: "_tp.Dict[str, TagSelector]" = _dc.field(default_factory=dict)

    outputAttrs: "_tp.List[TagUpdate]" = _dc.field(default_factory=list)


@_dc.dataclass
class JobGroup:

    """Specification for a JOB_GROUP job, which runs a collection of other jobs"""

    jobGroupType: "JobGroupType" = JobGroupType.JOB_GROUP_TYPE_NOT_SET

    sequential: "_tp.Optional[SequentialJobGroup]" = None

    parallel: "_tp.Optional[ParallelJobGroup]" = None


@_dc.dataclass
class SequentialJobGroup:

    """A job group where each job runs in sequence"""

    jobs: "_tp.List[JobDefinition]" = _dc.field(default_factory=list)


@_dc.dataclass
class ParallelJobGroup:

    """A job group where all jobs runs in parallel"""

    jobs: "_tp.List[JobDefinition]" = _dc.field(default_factory=list)
