# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .object_id import *  # noqa


class ResourceType(_enum.Enum):

    """Enumeration of infrastructure resources that can be added to a tenant"""

    RESOURCE_TYPE_NOT_SET = 0

    MODEL_REPOSITORY = 1

    """Model repository, which can be a source or binary repository"""

    INTERNAL_STORAGE = 2

    """Storage location for data held internally by the TRAC platform"""

    EXTERNAL_STORAGE = 3

    """Storage location for upstream  downstream integration points"""


@_dc.dataclass
class ResourceDefinition:

    """Definition of a platform resource"""

    resourceType: "ResourceType" = ResourceType.RESOURCE_TYPE_NOT_SET

    """The type of this resource"""

    protocol: "str" = ""

    """The protocol used to communicate with this resource (usually corresponds to a TRAC plugin)"""

    subProtocol: "_tp.Optional[str]" = None

    """Optional sub-protocol, to further distinguish the behavior of resources within a protocol"""

    publicProperties: "_tp.Dict[str, str]" = _dc.field(default_factory=dict)

    """Configuration properties for this resource, made visible to client applications"""

    properties: "_tp.Dict[str, str]" = _dc.field(default_factory=dict)

    """Configuration properties for this resource, not visible to client applications"""

    secrets: "_tp.Dict[str, str]" = _dc.field(default_factory=dict)

    """
    Configuration properties that are stored as secrets using TRAC's secret handling mechanism
    
    Only the secret alias is stored in metadata, handling of secret storage is delegated to the
    configured secrets plugin. Secret values may be sent by clients when resource definitions are
    created / updated, in which case they will be written to the configured secret store and
    metadata values will be replaced with an alias.
    """
