# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa


class CopyStatus(_enum.Enum):

    """
    Status of an individual copy of a data storage item
    
    .. seealso::
        :py:obj:`StorageDefinition <StorageDefinition>`,
        :py:obj:`StorageCopy <StorageCopy>`
    """

    COPY_STATUS_NOT_SET = 0

    COPY_AVAILABLE = 1

    """The copy of the data item is available in storage to access"""

    COPY_EXPUNGED = 2

    """The copy of the data item has been expunged and is no longer available"""


class IncarnationStatus(_enum.Enum):

    """
    Status of an individual incarnation of a data storage item
    
    .. seealso::
        :py:obj:`StorageDefinition <StorageDefinition>`,
        :py:obj:`StorageIncarnation <StorageIncarnation>`
    """

    INCARNATION_STATUS_NOT_SET = 0

    INCARNATION_AVAILABLE = 1

    """The incarnation of the data item has at least one copy available in storage"""

    INCARNATION_EXPUNGED = 2

    """This incarnation of the data item is no longer available in storage, all copies have been expunged"""


class StorageLayout(_enum.Enum):

    OBJECT_ID_LAYOUT = 0

    DEVELOPER_LAYOUT = 1


@_dc.dataclass
class StorageCopy:

    """
    Define physical storage for an individual copy of a data item
    
    .. seealso::
        :py:obj:`StorageDefinition <StorageDefinition>`
    """

    storageKey: "str" = ""

    storagePath: "str" = ""

    storageFormat: "str" = ""

    copyStatus: "CopyStatus" = CopyStatus.COPY_STATUS_NOT_SET

    copyTimestamp: "DatetimeValue" = _dc.field(default_factory=lambda: DatetimeValue())

    storageOptions: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)


@_dc.dataclass
class StorageIncarnation:

    """
    Define physical storage for an individual incarnation of a data item
    
    .. seealso::
        :py:obj:`StorageDefinition <StorageDefinition>`
    """

    copies: "_tp.List[StorageCopy]" = _dc.field(default_factory=list)

    incarnationIndex: "int" = 0

    incarnationTimestamp: "DatetimeValue" = _dc.field(default_factory=lambda: DatetimeValue())

    incarnationStatus: "IncarnationStatus" = IncarnationStatus.INCARNATION_STATUS_NOT_SET


@_dc.dataclass
class StorageItem:

    """
    Define physical storage for an individual data item
    
    .. seealso::
        :py:obj:`StorageDefinition <StorageDefinition>`
    """

    incarnations: "_tp.List[StorageIncarnation]" = _dc.field(default_factory=list)


@_dc.dataclass
class StorageDefinition:

    """
    Defines the physical storage for a file or dataset object
    
    Each storage item corresponds to one logical data item, such as a version of
    a file or a snapshot of a data partition. Storage for each item is broken down
    into incarnations (data that has been expunged and recomputed) and copies
    (physical file-level copies for resilience, locality etc).
    
    .. seealso::
        :py:obj:`DataDefinition <DataDefinition>`,
        :py:obj:`FileDefinition <FileDefinition>`
    """

    dataItems: "_tp.Dict[str, StorageItem]" = _dc.field(default_factory=dict)

    storageOptions: "_tp.Dict[str, Value]" = _dc.field(default_factory=dict)

    layout: "StorageLayout" = StorageLayout.OBJECT_ID_LAYOUT
