# Code generated by TRAC

import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa


class TagOperation(_enum.Enum):

    """
    Enumeration of available TagUpdate operations.
    
    .. seealso::
        :py:obj:`TagUpdate <TagUpdate>`
    """

    CREATE_OR_REPLACE_ATTR = 0

    """Add an attribute to a tag or replace it if it already exists.
    
    This is the default operation if no operation is specified. If the
    attribute does not exist it will be created using CREATE_ATTR, otherwise
    it will replaced using REPLACE_ATTR.
    
    .. seealso::
        :py:attr:`TagOperation.CREATE_ATTR <TagOperation.CREATE_ATTR>`,
        :py:attr:`TagOperation.REPLACE_ATTR <TagOperation.REPLACE_ATTR>`
    """

    CREATE_OR_APPEND_ATTR = 1

    """Add an attribute to a tag or append to it if it already exists.
    
    If the attribute does not exist it will be created using CREATE_ATTR,
    otherwise it will appended to using APPEND_ATTR.
    
    .. seealso::
        :py:attr:`TagOperation.CREATE_ATTR <TagOperation.CREATE_ATTR>`,
        :py:attr:`TagOperation.APPEND_ATTR <TagOperation.APPEND_ATTR>`
    """

    CREATE_ATTR = 2

    """Add an attribute to a tag, fail if the attribute already exists."""

    REPLACE_ATTR = 3

    """Replace an attribute on a tag, fail if the attribute does not exist.
    
    When replacing an attribute, the new attribute must be of the same basic
    type as the old one. It is allowed to replace a single-valued attribute
    with a multi-valued one and vice-versa (this is not considered to be
    changing the basic type).
    
    Changing the type of attributes is not recommended because it is likely
    to confuse applications that refer to those attributes. If you really
    need to change the type of an attribute (e.g. to correct an error), use
    DELETE_ATTR followed by CREATE_ATTR.
    """

    APPEND_ATTR = 4

    """Append one or more values to an existing attribute, fail if the attribute
    does not exist.
    
    The existing attribute may be single- or multi-valued and the append
    operation may add one value or multiple values (i.e. all combinations are
    permitted). The appended value(s) must be of the same basic type as the
    existing value(s).
    """

    DELETE_ATTR = 5

    """Remove an attribute from a tag, fail if the attribute does not exist."""

    CLEAR_ALL_ATTR = 6

    """Remove all the attributes from a tag.
    
    This operation does not affect controlled attributes, which are still
    managed by TRAC according to its normal rules.
    """


@_dc.dataclass
class TagUpdate:

    """
    A tag update is a request for a single update operation on a tag.
    
    Tag updates can be supplied to TRAC via an API call to request updates to a
    tag. They may also be included in TRAC policy objects or client application
    logic, to describe a set of operations that is performed in response to a
    particular action.
    
    .. seealso::
        :py:obj:`MetadataWriteRequest <MetadataWriteRequest>`
    """

    operation: "TagOperation" = TagOperation.CREATE_OR_REPLACE_ATTR

    """
    The operation requested in this update
    
    .. seealso::
        :py:obj:`TagOperation <TagOperation>`
    """

    attrName: "str" = ""

    """
    Name of the attribute this update refers to.
    
    This field must be supplied for operations that refer to a single
    attribute, otherwise it should be left blank.
    """

    value: "_tp.Optional[Value]" = None

    """
    Attribute value to use for this update.
    
    This field must be supplied for operations that use a value, otherwise it
    should be omitted.
    
    .. seealso::
        :py:obj:`Value <metadata.Value>`
    """
