from fastapi.responses import  HTMLResponse
from jinja2 import Environment, FileSystemLoader, TemplateNotFound

env = Environment(loader=FileSystemLoader("."), enable_async=True)

def useView(data,path):
    
    
    print("data is:", data)
    print("path is :", path)
    try:
        
        template = env.get_template(f"{path}/view.html")
        return template.render(data)
    
    except TemplateNotFound:
        return HTMLResponse(content=f"Template non trouvé : {path}/view.html", status_code=404)
    except Exception as e:
        return HTMLResponse(content=f"Erreur lors du rendu du template : {str(e)}", status_code=500)

