# Generated by Django 5.1.4 on 2025-02-19 14:32
import logging
from django.db import migrations
from django.db import connection

_logger = logging.getLogger(__name__)


def create_countries(apps, schema_editor):
    with connection.cursor() as cr:
        cr.execute(
            """
            INSERT INTO 
                accrete_country(name, iso_code_a2, iso_code_a3, vat_prefix, order_priority)
                VALUES 
                    ('{"de-de": "Aruba", "en-us": "Aruba"}', 'AW', 'ABW', null, 0),
                    ('{"de-de": "Afghanistan", "en-us": "Afghanistan"}', 'AF', 'AFG', null, 0),
                    ('{"de-de": "Angola", "en-us": "Angola"}', 'AO', 'AGO', null, 0),
                    ('{"de-de": "Anguilla", "en-us": "Anguilla"}', 'AI', 'AIA', null, 0),
                    ('{"de-de": "Åland Islands", "en-us": "Åland Islands"}', 'AX', 'ALA', null, 0),
                    ('{"de-de": "Albanien", "en-us": "Albania"}', 'AL', 'ALB', null, 0),
                    ('{"de-de": "Andorra", "en-us": "Andorra"}', 'AD', 'AND', null, 0),
                    ('{"de-de": "Vereinigte Arabische Emirate", "en-us": "United Arab Emirates"}', 'AE', 'ARE', null, 0),
                    ('{"de-de": "Argentinien", "en-us": "Argentina"}', 'AR', 'ARG', null, 0),
                    ('{"de-de": "Armenien", "en-us": "Armenia"}', 'AM', 'ARM', null, 0),
                    ('{"de-de": "American Samoa", "en-us": "American Samoa"}', 'AS', 'ASM', null, 0),
                    ('{"de-de": "Antarctica", "en-us": "Antarctica"}', 'AQ', 'ATA', null, 0),
                    ('{"de-de": "French Southern Territories", "en-us": "French Southern Territories"}', 'TF', 'ATF', null, 0),
                    ('{"de-de": "Antigua and Barbuda", "en-us": "Antigua and Barbuda"}', 'AG', 'ATG', null, 0),
                    ('{"de-de": "Australien", "en-us": "Australia"}', 'AU', 'AUS', null, 0),
                    ('{"de-de": "Österreich", "en-us": "Austria"}', 'AT', 'AUT', 'AT', 0),
                    ('{"de-de": "Aserbaidschan", "en-us": "Azerbaijan"}', 'AZ', 'AZE', null, 0),
                    ('{"de-de": "Burundi", "en-us": "Burundi"}', 'BI', 'BDI', null, 0),
                    ('{"de-de": "Belgien", "en-us": "Belgium"}', 'BE', 'BEL', 'BE', 0),
                    ('{"de-de": "Benin", "en-us": "Benin"}', 'BJ', 'BEN', null, 0),
                    ('{"de-de": "Bonaire, Sint Eustatius and Saba", "en-us": "Bonaire, Sint Eustatius and Saba"}', 'BQ', 'BES', null, 0),
                    ('{"de-de": "Burkina Faso", "en-us": "Burkina Faso"}', 'BF', 'BFA', null, 0),
                    ('{"de-de": "Bangladesch", "en-us": "Bangladesh"}', 'BD', 'BGD', null, 0),
                    ('{"de-de": "Bulgarien", "en-us": "Bulgaria"}', 'BG', 'BGR', 'BG', 0),
                    ('{"de-de": "Bahrain", "en-us": "Bahrain"}', 'BH', 'BHR', null, 0),
                    ('{"de-de": "Bahamas", "en-us": "Bahamas"}', 'BS', 'BHS', null, 0),
                    ('{"de-de": "Bosnien und Herzegowina", "en-us": "Bosnia and Herzegovina"}', 'BA', 'BIH', null, 0),
                    ('{"de-de": "Saint Barthélemy", "en-us": "Saint Barthélemy"}', 'BL', 'BLM', null, 0),
                    ('{"de-de": "Belarus", "en-us": "Belarus"}', 'BY', 'BLR', null, 0),
                    ('{"de-de": "Belize", "en-us": "Belize"}', 'BZ', 'BLZ', null, 0),
                    ('{"de-de": "Bermuda", "en-us": "Bermuda"}', 'BM', 'BMU', null, 0),
                    ('{"de-de": "Bolivien", "en-us": "Bolivia, Plurinational State of"}', 'BO', 'BOL', null, 0),
                    ('{"de-de": "Brasilien", "en-us": "Brazil"}', 'BR', 'BRA', null, 0),
                    ('{"de-de": "Barbados", "en-us": "Barbados"}', 'BB', 'BRB', null, 0),
                    ('{"de-de": "Brunei Darussalam", "en-us": "Brunei Darussalam"}', 'BN', 'BRN', null, 0),
                    ('{"de-de": "Bhutan", "en-us": "Bhutan"}', 'BT', 'BTN', null, 0),
                    ('{"de-de": "Bouvet Island", "en-us": "Bouvet Island"}', 'BV', 'BVT', null, 0),
                    ('{"de-de": "Botswana", "en-us": "Botswana"}', 'BW', 'BWA', null, 0),
                    ('{"de-de": "Central African Republic", "en-us": "Central African Republic"}', 'CF', 'CAF', null, 0),
                    ('{"de-de": "Kanada", "en-us": "Canada"}', 'CA', 'CAN', null, 0),
                    ('{"de-de": "Cocos (Keeling) Islands", "en-us": "Cocos (Keeling) Islands"}', 'CC', 'CCK', null, 0),
                    ('{"de-de": "Schweiz", "en-us": "Switzerland"}', 'CH', 'CHE', null, 0),
                    ('{"de-de": "Chile", "en-us": "Chile"}', 'CL', 'CHL', null, 0),
                    ('{"de-de": "China", "en-us": "China"}', 'CN', 'CHN', null, 0),
                    ('{"de-de": "Elfenbeinküste", "en-us": "Ivory Coast"}', 'CI', 'CIV', null, 0),
                    ('{"de-de": "Cameroon", "en-us": "Cameroon"}', 'CM', 'CMR', null, 0),
                    ('{"de-de": "Congo, The Democratic Republic of the", "en-us": "Congo, The Democratic Republic of the"}', 'CD', 'COD', null, 0),
                    ('{"de-de": "Congo", "en-us": "Congo"}', 'CG', 'COG', null, 0),
                    ('{"de-de": "Cook Islands", "en-us": "Cook Islands"}', 'CK', 'COK', null, 0),
                    ('{"de-de": "Kolumbien", "en-us": "Colombia"}', 'CO', 'COL', null, 0),
                    ('{"de-de": "Comoros", "en-us": "Comoros"}', 'KM', 'COM', null, 0),
                    ('{"de-de": "Cabo Verde", "en-us": "Cabo Verde"}', 'CV', 'CPV', null, 0),
                    ('{"de-de": "Costa Rica", "en-us": "Costa Rica"}', 'CR', 'CRI', null, 0),
                    ('{"de-de": "Kuba", "en-us": "Cuba"}', 'CU', 'CUB', null, 0),
                    ('{"de-de": "Curaçao", "en-us": "Curaçao"}', 'CW', 'CUW', null, 0),
                    ('{"de-de": "Christmas Island", "en-us": "Christmas Island"}', 'CX', 'CXR', null, 0),
                    ('{"de-de": "Cayman Islands", "en-us": "Cayman Islands"}', 'KY', 'CYM', null, 0),
                    ('{"de-de": "Zypern", "en-us": "Cyprus"}', 'CY', 'CYP', 'CY', 0),
                    ('{"de-de": "Tschechien", "en-us": "Czechia"}', 'CZ', 'CZE', 'CZ', 0),
                    ('{"de-de": "Deutschland", "en-us": "Germany"}', 'DE', 'DEU', 'DE', 0),
                    ('{"de-de": "Djibouti", "en-us": "Djibouti"}', 'DJ', 'DJI', null, 0),
                    ('{"de-de": "Dominica", "en-us": "Dominica"}', 'DM', 'DMA', null, 0),
                    ('{"de-de": "Dänemark", "en-us": "Denmark"}', 'DK', 'DNK', 'DK', 0),
                    ('{"de-de": "Dominican Republic", "en-us": "Dominican Republic"}', 'DO', 'DOM', null, 0),
                    ('{"de-de": "Algerien", "en-us": "Algeria"}', 'DZ', 'DZA', null, 0),
                    ('{"de-de": "Ecuador", "en-us": "Ecuador"}', 'EC', 'ECU', null, 0),
                    ('{"de-de": "Ägypten", "en-us": "Egypt"}', 'EG', 'EGY', null, 0),
                    ('{"de-de": "Eritrea", "en-us": "Eritrea"}', 'ER', 'ERI', null, 0),
                    ('{"de-de": "Western Sahara", "en-us": "Western Sahara"}', 'EH', 'ESH', null, 0),
                    ('{"de-de": "Spanien", "en-us": "Spain"}', 'ES', 'ESP', 'ES', 0),
                    ('{"de-de": "Estland", "en-us": "Estonia"}', 'EE', 'EST', 'EE', 0),
                    ('{"de-de": "Ethiopia", "en-us": "Ethiopia"}', 'ET', 'ETH', null, 0),
                    ('{"de-de": "Finnland", "en-us": "Finland"}', 'FI', 'FIN', 'FI', 0),
                    ('{"de-de": "Fiji", "en-us": "Fiji"}', 'FJ', 'FJI', null, 0),
                    ('{"de-de": "Falkland Islands (Malvinas)", "en-us": "Falkland Islands (Malvinas)"}', 'FK', 'FLK', null, 0),
                    ('{"de-de": "Frankreich", "en-us": "France"}', 'FR', 'FRA', 'FR', 0),
                    ('{"de-de": "Faroe Islands", "en-us": "Faroe Islands"}', 'FO', 'FRO', null, 0),
                    ('{"de-de": "Micronesia, Federated States of", "en-us": "Micronesia, Federated States of"}', 'FM', 'FSM', null, 0),
                    ('{"de-de": "Gabon", "en-us": "Gabon"}', 'GA', 'GAB', null, 0),
                    ('{"de-de": "Vereinigtes Königreich", "en-us": "United Kingdom"}', 'GB', 'GBR', null, 0),
                    ('{"de-de": "Georgia", "en-us": "Georgia"}', 'GE', 'GEO', null, 0),
                    ('{"de-de": "Guernsey", "en-us": "Guernsey"}', 'GG', 'GGY', null, 0),
                    ('{"de-de": "Ghana", "en-us": "Ghana"}', 'GH', 'GHA', null, 0),
                    ('{"de-de": "Gibraltar", "en-us": "Gibraltar"}', 'GI', 'GIB', null, 0),
                    ('{"de-de": "Guinea", "en-us": "Guinea"}', 'GN', 'GIN', null, 0),
                    ('{"de-de": "Guadeloupe", "en-us": "Guadeloupe"}', 'GP', 'GLP', null, 0),
                    ('{"de-de": "Gambia", "en-us": "Gambia"}', 'GM', 'GMB', null, 0),
                    ('{"de-de": "Guinea-Bissau", "en-us": "Guinea-Bissau"}', 'GW', 'GNB', null, 0),
                    ('{"de-de": "Equatorial Guinea", "en-us": "Equatorial Guinea"}', 'GQ', 'GNQ', null, 0),
                    ('{"de-de": "Griechenland", "en-us": "Greece"}', 'GR', 'GRC', null, 0),
                    ('{"de-de": "Grenada", "en-us": "Grenada"}', 'GD', 'GRD', null, 0),
                    ('{"de-de": "Greenland", "en-us": "Greenland"}', 'GL', 'GRL', null, 0),
                    ('{"de-de": "Guatemala", "en-us": "Guatemala"}', 'GT', 'GTM', null, 0),
                    ('{"de-de": "French Guiana", "en-us": "French Guiana"}', 'GF', 'GUF', null, 0),
                    ('{"de-de": "Guam", "en-us": "Guam"}', 'GU', 'GUM', null, 0),
                    ('{"de-de": "Guyana", "en-us": "Guyana"}', 'GY', 'GUY', null, 0),
                    ('{"de-de": "Hong Kong", "en-us": "Hong Kong"}', 'HK', 'HKG', null, 0),
                    ('{"de-de": "Heard Island and McDonald Islands", "en-us": "Heard Island and McDonald Islands"}', 'HM', 'HMD', null, 0),
                    ('{"de-de": "Honduras", "en-us": "Honduras"}', 'HN', 'HND', null, 0),
                    ('{"de-de": "Kroatien", "en-us": "Croatia"}', 'HR', 'HRV', 'HR', 0),
                    ('{"de-de": "Haiti", "en-us": "Haiti"}', 'HT', 'HTI', null, 0),
                    ('{"de-de": "Ungarn", "en-us": "Hungary"}', 'HU', 'HUN', 'HU', 0),
                    ('{"de-de": "Indonesien", "en-us": "Indonesia"}', 'ID', 'IDN', null, 0),
                    ('{"de-de": "Isle of Man", "en-us": "Isle of Man"}', 'IM', 'IMN', null, 0),
                    ('{"de-de": "Indien", "en-us": "India"}', 'IN', 'IND', null, 0),
                    ('{"de-de": "British Indian Ocean Territory", "en-us": "British Indian Ocean Territory"}', 'IO', 'IOT', null, 0),
                    ('{"de-de": "Irland", "en-us": "Ireland"}', 'IE', 'IRL', 'IE', 0),
                    ('{"de-de": "Iran, Islamic Republic of", "en-us": "Iran, Islamic Republic of"}', 'IR', 'IRN', null, 0),
                    ('{"de-de": "Iraq", "en-us": "Iraq"}', 'IQ', 'IRQ', null, 0),
                    ('{"de-de": "Iceland", "en-us": "Iceland"}', 'IS', 'ISL', null, 0),
                    ('{"de-de": "Israel", "en-us": "Israel"}', 'IL', 'ISR', null, 0),
                    ('{"de-de": "Italien", "en-us": "Italy"}', 'IT', 'ITA', 'IT', 0),
                    ('{"de-de": "Jamaica", "en-us": "Jamaica"}', 'JM', 'JAM', null, 0),
                    ('{"de-de": "Jersey", "en-us": "Jersey"}', 'JE', 'JEY', null, 0),
                    ('{"de-de": "Jordan", "en-us": "Jordan"}', 'JO', 'JOR', null, 0),
                    ('{"de-de": "Japan", "en-us": "Japan"}', 'JP', 'JPN', null, 0),
                    ('{"de-de": "Kasachstan", "en-us": "Kazakhstan"}', 'KZ', 'KAZ', null, 0),
                    ('{"de-de": "Kenia", "en-us": "Kenya"}', 'KE', 'KEN', null, 0),
                    ('{"de-de": "Kyrgyzstan", "en-us": "Kyrgyzstan"}', 'KG', 'KGZ', null, 0),
                    ('{"de-de": "Cambodia", "en-us": "Cambodia"}', 'KH', 'KHM', null, 0),
                    ('{"de-de": "Kiribati", "en-us": "Kiribati"}', 'KI', 'KIR', null, 0),
                    ('{"de-de": "Saint Kitts and Nevis", "en-us": "Saint Kitts and Nevis"}', 'KN', 'KNA', null, 0),
                    ('{"de-de": "Südkorea", "en-us": "Korea, Republic of"}', 'KR', 'KOR', null, 0),
                    ('{"de-de": "Kuwait", "en-us": "Kuwait"}', 'KW', 'KWT', null, 0),
                    ('{"de-de": "Lao Peoples Democratic Republic", "en-us": "Lao Peoples Democratic Republic"}', 'LA', 'LAO', null, 0),
                    ('{"de-de": "Lebanon", "en-us": "Lebanon"}', 'LB', 'LBN', null, 0),
                    ('{"de-de": "Liberia", "en-us": "Liberia"}', 'LR', 'LBR', null, 0),
                    ('{"de-de": "Libya", "en-us": "Libya"}', 'LY', 'LBY', null, 0),
                    ('{"de-de": "Saint Lucia", "en-us": "Saint Lucia"}', 'LC', 'LCA', null, 0),
                    ('{"de-de": "Liechtenstein", "en-us": "Liechtenstein"}', 'LI', 'LIE', null, 0),
                    ('{"de-de": "Sri Lanka", "en-us": "Sri Lanka"}', 'LK', 'LKA', null, 0),
                    ('{"de-de": "Lesotho", "en-us": "Lesotho"}', 'LS', 'LSO', null, 0),
                    ('{"de-de": "Litauen", "en-us": "Lithuania"}', 'LT', 'LTU', 'LT', 0),
                    ('{"de-de": "Luxemburg", "en-us": "Luxembourg"}', 'LU', 'LUX', 'LU', 0),
                    ('{"de-de": "Lettland", "en-us": "Latvia"}', 'LV', 'LVA', 'LV', 0),
                    ('{"de-de": "Macao", "en-us": "Macao"}', 'MO', 'MAC', null, 0),
                    ('{"de-de": "Saint Martin (French part)", "en-us": "Saint Martin (French part)"}', 'MF', 'MAF', null, 0),
                    ('{"de-de": "Marokko", "en-us": "Morocco"}', 'MA', 'MAR', null, 0),
                    ('{"de-de": "Monaco", "en-us": "Monaco"}', 'MC', 'MCO', null, 0),
                    ('{"de-de": "Moldova, Republic of", "en-us": "Moldova, Republic of"}', 'MD', 'MDA', null, 0),
                    ('{"de-de": "Madagascar", "en-us": "Madagascar"}', 'MG', 'MDG', null, 0),
                    ('{"de-de": "Maldives", "en-us": "Maldives"}', 'MV', 'MDV', null, 0),
                    ('{"de-de": "Mexiko", "en-us": "Mexico"}', 'MX', 'MEX', null, 0),
                    ('{"de-de": "Marshall Islands", "en-us": "Marshall Islands"}', 'MH', 'MHL', null, 0),
                    ('{"de-de": "North Macedonia", "en-us": "North Macedonia"}', 'MK', 'MKD', null, 0),
                    ('{"de-de": "Mali", "en-us": "Mali"}', 'ML', 'MLI', null, 0),
                    ('{"de-de": "Malta", "en-us": "Malta"}', 'MT', 'MLT', 'MT', 0),
                    ('{"de-de": "Myanmar", "en-us": "Myanmar"}', 'MM', 'MMR', null, 0),
                    ('{"de-de": "Montenegro", "en-us": "Montenegro"}', 'ME', 'MNE', null, 0),
                    ('{"de-de": "Mongolia", "en-us": "Mongolia"}', 'MN', 'MNG', null, 0),
                    ('{"de-de": "Northern Mariana Islands", "en-us": "Northern Mariana Islands"}', 'MP', 'MNP', null, 0),
                    ('{"de-de": "Mozambique", "en-us": "Mozambique"}', 'MZ', 'MOZ', null, 0),
                    ('{"de-de": "Mauritania", "en-us": "Mauritania"}', 'MR', 'MRT', null, 0),
                    ('{"de-de": "Montserrat", "en-us": "Montserrat"}', 'MS', 'MSR', null, 0),
                    ('{"de-de": "Martinique", "en-us": "Martinique"}', 'MQ', 'MTQ', null, 0),
                    ('{"de-de": "Mauritius", "en-us": "Mauritius"}', 'MU', 'MUS', null, 0),
                    ('{"de-de": "Malawi", "en-us": "Malawi"}', 'MW', 'MWI', null, 0),
                    ('{"de-de": "Malaysia", "en-us": "Malaysia"}', 'MY', 'MYS', null, 0),
                    ('{"de-de": "Mayotte", "en-us": "Mayotte"}', 'YT', 'MYT', null, 0),
                    ('{"de-de": "Namibia", "en-us": "Namibia"}', 'NA', 'NAM', null, 0),
                    ('{"de-de": "New Caledonia", "en-us": "New Caledonia"}', 'NC', 'NCL', null, 0),
                    ('{"de-de": "Niger", "en-us": "Niger"}', 'NE', 'NER', null, 0),
                    ('{"de-de": "Norfolk Island", "en-us": "Norfolk Island"}', 'NF', 'NFK', null, 0),
                    ('{"de-de": "Nigeria", "en-us": "Nigeria"}', 'NG', 'NGA', null, 0),
                    ('{"de-de": "Nicaragua", "en-us": "Nicaragua"}', 'NI', 'NIC', null, 0),
                    ('{"de-de": "Niue", "en-us": "Niue"}', 'NU', 'NIU', null, 0),
                    ('{"de-de": "Niederlande", "en-us": "Netherlands"}', 'NL', 'NLD', 'NL', 0),
                    ('{"de-de": "Norwegen", "en-us": "Norway"}', 'NO', 'NOR', null, 0),
                    ('{"de-de": "Nepal", "en-us": "Nepal"}', 'NP', 'NPL', null, 0),
                    ('{"de-de": "Nauru", "en-us": "Nauru"}', 'NR', 'NRU', null, 0),
                    ('{"de-de": "Neuseeland", "en-us": "New Zealand"}', 'NZ', 'NZL', null, 0),
                    ('{"de-de": "Oman", "en-us": "Oman"}', 'OM', 'OMN', null, 0),
                    ('{"de-de": "Pakistan", "en-us": "Pakistan"}', 'PK', 'PAK', null, 0),
                    ('{"de-de": "Panama", "en-us": "Panama"}', 'PA', 'PAN', null, 0),
                    ('{"de-de": "Pitcairn", "en-us": "Pitcairn"}', 'PN', 'PCN', null, 0),
                    ('{"de-de": "Peru", "en-us": "Peru"}', 'PE', 'PER', null, 0),
                    ('{"de-de": "Philippinen", "en-us": "Philippines"}', 'PH', 'PHL', null, 0),
                    ('{"de-de": "Palau", "en-us": "Palau"}', 'PW', 'PLW', null, 0),
                    ('{"de-de": "Papua New Guinea", "en-us": "Papua New Guinea"}', 'PG', 'PNG', null, 0),
                    ('{"de-de": "Polen", "en-us": "Poland"}', 'PL', 'POL', 'PL', 0),
                    ('{"de-de": "Puerto Rico", "en-us": "Puerto Rico"}', 'PR', 'PRI', null, 0),
                    ('{"de-de": "Nordkorea", "en-us": "North Korea"}', 'KP', 'PRK', null, 0),
                    ('{"de-de": "Portugal", "en-us": "Portugal"}', 'PT', 'PRT', 'PT', 0),
                    ('{"de-de": "Paraguay", "en-us": "Paraguay"}', 'PY', 'PRY', null, 0),
                    ('{"de-de": "Palestine, State of", "en-us": "Palestine, State of"}', 'PS', 'PSE', null, 0),
                    ('{"de-de": "French Polynesia", "en-us": "French Polynesia"}', 'PF', 'PYF', null, 0),
                    ('{"de-de": "Qatar", "en-us": "Qatar"}', 'QA', 'QAT', null, 0),
                    ('{"de-de": "Réunion", "en-us": "Réunion"}', 'RE', 'REU', null, 0),
                    ('{"de-de": "Rumänien", "en-us": "Romania"}', 'RO', 'ROU', 'RO', 0),
                    ('{"de-de": "Russland", "en-us": "Russian Federation"}', 'RU', 'RUS', null, 0),
                    ('{"de-de": "Rwanda", "en-us": "Rwanda"}', 'RW', 'RWA', null, 0),
                    ('{"de-de": "Saudi-Arabien", "en-us": "Saudi Arabia"}', 'SA', 'SAU', null, 0),
                    ('{"de-de": "Sudan", "en-us": "Sudan"}', 'SD', 'SDN', null, 0),
                    ('{"de-de": "Senegal", "en-us": "Senegal"}', 'SN', 'SEN', null, 0),
                    ('{"de-de": "Singapur", "en-us": "Singapore"}', 'SG', 'SGP', null, 0),
                    ('{"de-de": "South Georgia and the South Sandwich Islands", "en-us": "South Georgia and the South Sandwich Islands"}', 'GS', 'SGS', null, 0),
                    ('{"de-de": "Saint Helena, Ascension and Tristan da Cunha", "en-us": "Saint Helena, Ascension and Tristan da Cunha"}', 'SH', 'SHN', null, 0),
                    ('{"de-de": "Svalbard and Jan Mayen", "en-us": "Svalbard and Jan Mayen"}', 'SJ', 'SJM', null, 0),
                    ('{"de-de": "Solomon Islands", "en-us": "Solomon Islands"}', 'SB', 'SLB', null, 0),
                    ('{"de-de": "Sierra Leone", "en-us": "Sierra Leone"}', 'SL', 'SLE', null, 0),
                    ('{"de-de": "El Salvador", "en-us": "El Salvador"}', 'SV', 'SLV', null, 0),
                    ('{"de-de": "San Marino", "en-us": "San Marino"}', 'SM', 'SMR', null, 0),
                    ('{"de-de": "Somalia", "en-us": "Somalia"}', 'SO', 'SOM', null, 0),
                    ('{"de-de": "Saint Pierre and Miquelon", "en-us": "Saint Pierre and Miquelon"}', 'PM', 'SPM', null, 0),
                    ('{"de-de": "Serbien", "en-us": "Serbia"}', 'RS', 'SRB', null, 0),
                    ('{"de-de": "South Sudan", "en-us": "South Sudan"}', 'SS', 'SSD', null, 0),
                    ('{"de-de": "Sao Tome and Principe", "en-us": "Sao Tome and Principe"}', 'ST', 'STP', null, 0),
                    ('{"de-de": "Suriname", "en-us": "Suriname"}', 'SR', 'SUR', null, 0),
                    ('{"de-de": "Slowakei", "en-us": "Slovakia"}', 'SK', 'SVK', 'SK', 0),
                    ('{"de-de": "Slowenien", "en-us": "Slovenia"}', 'SI', 'SVN', 'SI', 0),
                    ('{"de-de": "Schweden", "en-us": "Sweden"}', 'SE', 'SWE', 'SE', 0),
                    ('{"de-de": "Eswatini", "en-us": "Eswatini"}', 'SZ', 'SWZ', null, 0),
                    ('{"de-de": "Sint Maarten (Dutch part)", "en-us": "Sint Maarten (Dutch part)"}', 'SX', 'SXM', null, 0),
                    ('{"de-de": "Seychelles", "en-us": "Seychelles"}', 'SC', 'SYC', null, 0),
                    ('{"de-de": "Syrian Arab Republic", "en-us": "Syrian Arab Republic"}', 'SY', 'SYR', null, 0),
                    ('{"de-de": "Turks and Caicos Islands", "en-us": "Turks and Caicos Islands"}', 'TC', 'TCA', null, 0),
                    ('{"de-de": "Chad", "en-us": "Chad"}', 'TD', 'TCD', null, 0),
                    ('{"de-de": "Togo", "en-us": "Togo"}', 'TG', 'TGO', null, 0),
                    ('{"de-de": "Thailand", "en-us": "Thailand"}', 'TH', 'THA', null, 0),
                    ('{"de-de": "Tajikistan", "en-us": "Tajikistan"}', 'TJ', 'TJK', null, 0),
                    ('{"de-de": "Tokelau", "en-us": "Tokelau"}', 'TK', 'TKL', null, 0),
                    ('{"de-de": "Turkmenistan", "en-us": "Turkmenistan"}', 'TM', 'TKM', null, 0),
                    ('{"de-de": "Timor-Leste", "en-us": "Timor-Leste"}', 'TL', 'TLS', null, 0),
                    ('{"de-de": "Tonga", "en-us": "Tonga"}', 'TO', 'TON', null, 0),
                    ('{"de-de": "Trinidad and Tobago", "en-us": "Trinidad and Tobago"}', 'TT', 'TTO', null, 0),
                    ('{"de-de": "Tunisia", "en-us": "Tunisia"}', 'TN', 'TUN', null, 0),
                    ('{"de-de": "Türkei", "en-us": "Turkey"}', 'TR', 'TUR', null, 0),
                    ('{"de-de": "Tuvalu", "en-us": "Tuvalu"}', 'TV', 'TUV', null, 0),
                    ('{"de-de": "Taiwan, Province of China", "en-us": "Taiwan, Province of China"}', 'TW', 'TWN', null, 0),
                    ('{"de-de": "Tanzania, United Republic of", "en-us": "Tanzania, United Republic of"}', 'TZ', 'TZA', null, 0),
                    ('{"de-de": "Uganda", "en-us": "Uganda"}', 'UG', 'UGA', null, 0),
                    ('{"de-de": "Ukraine", "en-us": "Ukraine"}', 'UA', 'UKR', null, 0),
                    ('{"de-de": "United States Minor Outlying Islands", "en-us": "United States Minor Outlying Islands"}', 'UM', 'UMI', null, 0),
                    ('{"de-de": "Uruguay", "en-us": "Uruguay"}', 'UY', 'URY', null, 0),
                    ('{"de-de": "Vereinigte Staaten", "en-us": "United States"}', 'US', 'USA', null, 0),
                    ('{"de-de": "Uzbekistan", "en-us": "Uzbekistan"}', 'UZ', 'UZB', null, 0),
                    ('{"de-de": "Holy See (Vatican City State)", "en-us": "Holy See (Vatican City State)"}', 'VA', 'VAT', null, 0),
                    ('{"de-de": "Saint Vincent and the Grenadines", "en-us": "Saint Vincent and the Grenadines"}', 'VC', 'VCT', null, 0),
                    ('{"de-de": "Venezuela, Bolivarian Republic of", "en-us": "Venezuela, Bolivarian Republic of"}', 'VE', 'VEN', null, 0),
                    ('{"de-de": "Virgin Islands, British", "en-us": "Virgin Islands, British"}', 'VG', 'VGB', null, 0),
                    ('{"de-de": "Virgin Islands, U.S.", "en-us": "Virgin Islands, U.S."}', 'VI', 'VIR', null, 0),
                    ('{"de-de": "Vietnam", "en-us": "Viet Nam"}', 'VN', 'VNM', null, 0),
                    ('{"de-de": "Vanuatu", "en-us": "Vanuatu"}', 'VU', 'VUT', null, 0),
                    ('{"de-de": "Wallis and Futuna", "en-us": "Wallis and Futuna"}', 'WF', 'WLF', null, 0),
                    ('{"de-de": "Samoa", "en-us": "Samoa"}', 'WS', 'WSM', null, 0),
                    ('{"de-de": "Yemen", "en-us": "Yemen"}', 'YE', 'YEM', null, 0),
                    ('{"de-de": "Südafrika", "en-us": "South Africa"}', 'ZA', 'ZAF', null, 0),
                    ('{"de-de": "Zambia", "en-us": "Zambia"}', 'ZM', 'ZMB', null, 0),
                    ('{"de-de": "Zimbabwe", "en-us": "Zimbabwe"}', 'ZW', 'ZWE', null, 0)
            """
        )


def revert(apps, schema_editor):
    Country = apps.get_model('country', 'Country')
    countries = Country.objects.all()
    try:
        countries.delete()
    except Exception as e:
        _logger.exception(e)


class Migration(migrations.Migration):

    dependencies = [
        ('country', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_countries, revert)
    ]
