# Generated by Django 5.1.1 on 2025-01-10 15:20

import django.db.models.deletion
import django.db.models.functions.text
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('log', '0003_alter_log_tenant'),
    ]

    operations = [
        migrations.CreateModel(
            name='LogConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Combination of app label and model name seperated by a dot', max_length=255, verbose_name='Model')),
                ('ignore_errors', models.BooleanField(default=False, help_text='IF true, exceptions during log creation will be ignored', verbose_name='Ignore Errors')),
            ],
            options={
                'verbose_name': 'Log Configuration',
                'verbose_name_plural': 'Log Configs',
                'db_table': 'accrete_log_config',
                'ordering': [django.db.models.functions.text.Lower('model')],
                'indexes': [models.Index(fields=['model'], name='accrete_log_model_a89071_idx')],
                'constraints': [models.UniqueConstraint(fields=('model',), name='unique_model')],
            },
        ),
        migrations.CreateModel(
            name='LogConfigField',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_name', models.CharField(help_text='Name of the field to log', max_length=255, verbose_name='Field Name')),
                ('log_config', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='log.logconfig', verbose_name='Log Configuration')),
            ],
            options={
                'verbose_name': 'Log Configuration Field',
                'verbose_name_plural': 'Log Configuration Fields',
                'db_table': 'accrete_log_config_field',
                'ordering': [django.db.models.functions.text.Lower('field_name')],
                'indexes': [models.Index(fields=['log_config'], name='accrete_log_log_con_22f45e_idx')],
                'constraints': [models.UniqueConstraint(fields=('log_config', 'field_name'), name='unique_config_field_name')],
            },
        ),
    ]
