# Generated by Django 4.2.6 on 2023-10-10 20:06

import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AccessGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('code', models.CharField(max_length=50, verbose_name='Code')),
                ('is_public', models.BooleanField(default=True, help_text='If set, members from all tenants can be assigned to this group.', verbose_name='Is Public')),
            ],
            options={
                'verbose_name': 'Access Group',
                'verbose_name_plural': 'Access Groups',
                'db_table': 'accrete_access_group',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='AccessGroupMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Access Group Member',
                'verbose_name_plural': 'Access Group Members',
                'db_table': 'accrete_access_group_member_rel',
                'ordering': ['member'],
            },
        ),
        migrations.CreateModel(
            name='Tenant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
            ],
            options={
                'verbose_name': 'Tenant',
                'verbose_name_plural': 'Tenants',
                'db_table': 'accrete_tenant',
                'ordering': ['-is_active', 'name'],
            },
        ),
        migrations.CreateModel(
            name='TenantAccessGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('access_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accrete.accessgroup')),
                ('tenant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accrete.tenant')),
            ],
            options={
                'verbose_name': 'Tenant Access Group',
                'verbose_name_plural': 'Tenant Access Groups',
                'db_table': 'accrete_tenant_access_group_rel',
                'ordering': ['tenant'],
            },
        ),
        migrations.AddField(
            model_name='tenant',
            name='access_groups',
            field=models.ManyToManyField(through='accrete.TenantAccessGroup', to='accrete.accessgroup'),
        ),
        migrations.CreateModel(
            name='Member',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='150 characters or fewer.Letters, digits and @/./+/-/_ only.', max_length=150, null=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('access_groups', models.ManyToManyField(through='accrete.AccessGroupMember', to='accrete.accessgroup')),
                ('tenant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to='accrete.tenant')),
            ],
            options={
                'verbose_name': 'Member',
                'verbose_name_plural': 'Members',
                'db_table': 'accrete_member',
                'ordering': ['tenant', 'user'],
            },
        ),
    ]
