# Generated by Django 5.2.1 on 2025-07-31 05:12

import json
import accrete.fields
from django.db import migrations
from django.conf import settings


def char_to_translated_char(apps, schema):
    AccessGroup = apps.get_model('accrete', 'AccessGroup')
    default_lang = getattr(settings, 'LANGUAGE_CODE', 'en-us')
    for group in AccessGroup.objects.all():
        try:
            name = json.dumps(json.loads(group.name).get(default_lang))
            if not name:
                name = None
        except Exception:
            name = group.name or None
        group.name = name
        group.save()


def translated_to_char(apps, schema):
    AccessGroup = apps.get_model('accrete', 'AccessGroup')
    default_lang = getattr(settings, 'LANGUAGE_CODE', 'en-us')
    for group in AccessGroup.objects.all():
        try:
            group.name = json.loads(group.name).get(default_lang, '')
        except Exception:
            continue


class Migration(migrations.Migration):

    dependencies = [
        ('accrete', '0008_alter_member_access_groups_and_more'),
    ]

    operations = [
        migrations.RunPython(char_to_translated_char, translated_to_char),
        migrations.AlterField(
            model_name='accessgroup',
            name='name',
            field=accrete.fields.TranslatedCharField(verbose_name='Name'),
        ),
    ]
