# Generated by Django 5.2.7 on 2025-10-04 06:20

import json
import accrete.fields
from django.db import migrations
from django.conf import settings


def char_to_translated_char(apps, schema):
    AccessGroup = apps.get_model('accrete', 'AccessGroup')
    default_lang = getattr(settings, 'LANGUAGE_CODE', 'en-us')
    for group in AccessGroup.objects.all():
        try:
            description = json.dumps(json.loads(group.description).get(default_lang))
            if not description:
                description = None
        except Exception:
            description = group.description or None
        group.description = description
        group.save()


def translated_to_char(apps, schema):
    AccessGroup = apps.get_model('accrete', 'AccessGroup')
    default_lang = getattr(settings, 'LANGUAGE_CODE', 'en-us')
    for group in AccessGroup.objects.all():
        try:
            group.description = json.loads(group.description).get(default_lang, '')
        except Exception:
            continue


class Migration(migrations.Migration):

    dependencies = [
        ('accrete', '0009_alter_accessgroup_name'),
    ]

    operations = [
        migrations.RunPython(char_to_translated_char, translated_to_char),
        migrations.AlterField(
            model_name='accessgroup',
            name='description',
            field=accrete.fields.TranslatedTextField(blank=True, null=True, verbose_name='Description'),
        ),
    ]
