# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_body_response import ClientBodyResponse
from ..types.raw_body import RawBody
from .raw_client import AsyncRawBodyClient, RawBodyClient


class BodyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBodyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBodyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBodyClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientBodyResponse:
        """
        Get Body summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientBodyResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.body.get(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawBody:
        """
        Get raw Body summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawBody
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.body.get_raw(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncBodyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBodyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBodyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBodyClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientBodyResponse:
        """
        Get Body summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientBodyResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.body.get(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawBody:
        """
        Get raw Body summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawBody
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.body.get_raw(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data
