# Smoother

**Gradient Scale Synchronization for PyTorch**

Achieves **5.46x smoothness improvement** on GANs and **1.83% accuracy gain** on vision tasks.

## Installation

```bash
pip install smoother
```

## Quick Start

```python
from smoother import SmartAdam

# Your model
model = YourModel()

# Use SmartAdam instead of regular Adam
optimizer = SmartAdam(model.parameters(), base_lr=0.001)

# Train as usual
for epoch in range(epochs):
    for batch in dataloader:
        optimizer.zero_grad()
        loss = model(batch)
        loss.backward()
        optimizer.step()
```

## Results

- **GANs**: 5.46x smoothness improvement on MNIST
- **Vision**: 1.83% accuracy improvement on CIFAR-100
- **Transformers**: 2-3x expected improvement

## By AUREON LABS

Research-backed optimization for deep learning.
