"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const dashboard_1 = require("./dashboard");
const datasource_1 = require("./datasource");
const grafana_1 = require("./imports/grafana");
/**
 * A Grafana instance.
 */
class Grafana extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.labels = props.labels ?? { app: 'grafana' };
        this.dataSources = [];
        this.dashboards = [];
        this.namespace = props.namespace;
        const baseImage = props.image ?? 'public.ecr.aws/ubuntu/grafana:latest';
        const ingress = props.ingress ?? true;
        const serviceType = props.serviceType ?? 'ClusterIP';
        const adminUser = props.adminUser ?? 'root';
        const adminPassword = props.adminPassword ?? 'secret';
        const requireLogin = props.requireLogin ?? false;
        const dashboardLabelSelectors = [{ matchLabels: this.labels ?? { app: 'grafana' } }];
        new grafana_1.Grafana(this, 'Resource', {
            metadata: {
                labels: this.labels,
                namespace: this.namespace,
            },
            spec: {
                baseImage: baseImage,
                ingress: {
                    enabled: ingress,
                },
                service: {
                    type: serviceType,
                },
                client: {
                    // without this, dashboards may not be automatically discovered
                    // https://github.com/grafana-operator/grafana-operator/blob/master/documentation/deploy_grafana.md#configuring-grafana-api-access
                    preferService: true,
                },
                config: {
                    'log': {
                        mode: 'console',
                        level: 'info',
                    },
                    'auth.anonymous': {
                        enabled: !requireLogin,
                    },
                    'security': {
                        admin_user: adminUser,
                        admin_password: adminPassword,
                    },
                },
                deployment: {
                    labels: this.labels,
                },
                dashboardLabelSelector: dashboardLabelSelectors,
            },
        });
        if (props.defaultDataSource) {
            this.addDataSource('default-datasource', props.defaultDataSource);
        }
    }
    /**
     * Adds a data source. By default, labels are automatically added so that
     * the data source is detected by Grafana.
     */
    addDataSource(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const datasource = new datasource_1.DataSource(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dataSources.push(datasource);
        return datasource;
    }
    /**
     * Creates a dashboard associated with a particular data source. By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     */
    addDashboard(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const dashboard = new dashboard_1.Dashboard(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dashboards.push(dashboard);
        return dashboard;
    }
}
exports.Grafana = Grafana;
_a = JSII_RTTI_SYMBOL_1;
Grafana[_a] = { fqn: "cdk8s-grafana.Grafana", version: "0.1.225" };
//# sourceMappingURL=data:application/json;base64,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