# Changelog

All notable changes to NoteParser will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2024-01-15

### Added
- Initial release of NoteParser
- Core document parsing functionality using Microsoft MarkItDown
- Support for PDF, DOCX, PPTX, XLSX, HTML, EPUB, and image formats
- Audio and video transcription capabilities
- Enhanced OCR processing for handwritten notes
- Markdown and LaTeX output formats
- Academic-specific formatting preservation
- Plugin system with built-in Math and Computer Science plugins
- Multi-repository organization support
- GitHub Actions integration
- Web dashboard with Flask
- Comprehensive CLI interface
- REST API endpoints
- Cross-reference detection
- Batch processing capabilities
- Metadata extraction
- Bibliography and citation detection

### Features
- 🔄 Multi-format document conversion
- 🎓 Academic-focused processing (equations, theorems, citations)
- 🔌 Extensible plugin architecture
- 🌐 Organization-wide integration
- 🖥️ Web interface for easy management
- 📊 Searchable document indexing

### Dependencies
- Python 3.8+ required
- Microsoft MarkItDown for core parsing
- Flask for web interface
- Various academic processing libraries

[1.0.0]: https://github.com/SuryanshSS1011/noteparser/releases/tag/v1.0.0