# Generated by Django 4.2.22 on 2025-06-09 08:51

import copy
from django.db import migrations


def cleanup_and_rename(apps, schema_editor):
    # Delete transport entries
    Transport = apps.get_model("transport", "Transport")
    Transport.objects.filter(pattern__startswith="autoreply").delete()
    # Delete aliases
    AliasRecipient = apps.get_model("admin", "AliasRecipient")
    AliasRecipient.objects.filter(address__contains="@autoreply.").delete()
    # Rename parameters
    LocalConfig = apps.get_model("core", "LocalConfig")
    cfg = LocalConfig.objects.first()
    if not cfg or "postfix_autoreply" not in cfg._parameters:
        return
    cfg._parameters["autoreply"] = copy.deepcopy(cfg._parameters["postfix_autoreply"])
    del cfg._parameters["postfix_autoreply"]
    cfg.save()


class Migration(migrations.Migration):

    dependencies = [
        ("autoreply", "0010_auto_20230421_1825"),
    ]

    operations = [migrations.RunPython(cleanup_and_rename, migrations.RunPython.noop)]
