# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-02-07 08:19
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def create_default_provider(apps, schema_editor):
    """Create default provider based on old settings."""
    EmailProvider = apps.get_model("imap_migration", "EmailProvider")
    Migration = apps.get_model("imap_migration", "Migration")
    LocalConfig = apps.get_model("core", "LocalConfig")
    lc = LocalConfig.objects.first()
    if not lc:
        return
    params = lc._parameters.get("imap_migration")
    if params is None:
        return
    provider = EmailProvider.objects.create(
        name="Default",
        address=params["server_address"],
        port=params["server_port"],
        secured=params["secured"],
    )
    for migration in Migration.objects.select_related("mailbox__domain"):
        migration.provider = provider
        migration.username = (
            migration.mailbox.address + "@" + migration.mailbox.domain.name
        )
        migration.save(update_fields=["provider", "username"])


def backwards(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("admin", "0014_auto_20181017_1628"),
        ("imap_migration", "0002_password"),
    ]

    operations = [
        migrations.CreateModel(
            name="EmailProvider",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                ("address", models.CharField(max_length=200)),
                ("port", models.PositiveIntegerField(default=143)),
                ("secured", models.BooleanField(default=False)),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="EmailProviderDomain",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "new_domain",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="admin.Domain",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="imap_migration.EmailProvider",
                    ),
                ),
            ],
            options={
                "ordering": ["provider", "name"],
            },
        ),
        migrations.AddField(
            model_name="migration",
            name="username",
            field=models.CharField(max_length=254, null=True),
        ),
        migrations.AddField(
            model_name="migration",
            name="provider",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="imap_migration.EmailProvider",
            ),
        ),
        migrations.RunPython(create_default_provider, backwards),
    ]
