# This file is generated by pto-pre-build.sh. Do not edit it manually.
# Wed 10 Jul 2024 04:34:31 PM EDT
# SOURCE NAME: jgtml_cli-ttf-proto-01-2406181221.py
########################
 
import argparse
import pandas as pd
import os
import sys

sys.path.insert(0, os.path.abspath(os.path.dirname(__file__)))

from mlcliconstants import MLFCLI_DESCRIPTION,MLFCLI_EPILOG,MLFCLI_PROG_NAME
from mlclicommon import (add_patterns_arguments,
                         check_arguments)
import realityhelper

def create_app_arguments()->argparse.Namespace:
  from jgtutils import jgtcommon
  
  parser:argparse.ArgumentParser=jgtcommon.new_parser(MLFCLI_DESCRIPTION,MLFCLI_EPILOG,MLFCLI_PROG_NAME)
  #parser = argparse.ArgumentParser(description="Create mlf alpha CSV file")
  parser=jgtcommon.add_patterns_arguments(parser)
  

  
  #flag mfiao
  #parser.add_argument("-mfiao", "--mfiao", action="store_true", help="Use mfiao")
  #drop_bidask
  #parser.add_argument("-dba", "--drop_bidask", action="store_true", help="Drop bidask")
  
  
  parser=jgtcommon.add_keepbidask_argument(parser)
  parser=jgtcommon.add_instrument_timeframe_arguments(parser)
  parser=jgtcommon.add_bars_amount_V2_arguments(parser)
  parser=jgtcommon.add_use_fresh_argument(parser)
  parser=jgtcommon.add_dropna_volume_argument(parser)
  
  lagging_group=parser.add_argument_group("Lagging")
  #lag_period
  lagging_group.add_argument("-lp", "--lag_period", type=int, default=1, help="Lag period")
  #total_lagging_periods
  lagging_group.add_argument("-tlp", "--total_lagging_periods", type=int, default=5, help="Total lagging periods")
  
  col_group=parser.add_argument_group("Columns Filtering")
  #columns_to_keep
  col_group.add_argument("-ctk", "--columns_to_keep", nargs='+', help="List of selected columns to keep", default=None)
  #columns_to_drop
  col_group.add_argument("-ctd", "--columns_to_drop", nargs='+', help="List of selected columns to drop", default=None)
  
  
  args:argparse.Namespace=jgtcommon.parse_args(parser)
  
  args =check_arguments(args)
  
  return args
  


def main():
  
  args = create_app_arguments()

  force_refresh=args.fresh
  
  try:
    df=run_mlf_wrapper(args, force_refresh)
  except:
    print("Error in generate_mlf_feature_pattern")
    #print("patternname:", args.patternname, " might just not have its prerequisite TTF/Pattern data.  we would be running: jgtmlttfcli -i {instrument} -t {timeframe} -new")
    print("----WE ARE TRYING IT USING jgtapp---------")
    from jgtapp import ttf
    try:
      ttf(args.instrument, args.timeframe, pn=args.patternname,use_fresh=args.fresh,use_full=args.full)
      print("---Running MLF now that we should have the desired pattern.")
      df=run_mlf_wrapper(args, force_refresh)
    except:
      print("Error while running ttf.")

def run_mlf_wrapper(args, force_refresh):
    df=realityhelper.generate_mlf_feature_pattern(
                            args.instrument,
                            args.timeframe,
                            use_full=args.full,
                            force_refresh=force_refresh,
                            lag_period=args.lag_period,
                            total_lagging_periods=args.total_lagging_periods,
                            dropna=True,
                            columns_to_keep=args.columns_to_keep,
                            columns_to_drop=args.columns_to_drop,
                            drop_bid_ask=args.rmbidask,
                            pn=args.patternname,
                            args=args)
    return df
  #create_ttf_csv(args.instrument, args.timeframe, args.full if args.full else False, args.fresh, args.quotescount, args.force_read)

if __name__ == "__main__":
  main()
  