from typing import Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.list_assets_by_usage_json_body_usages_item_kind import ListAssetsByUsageJsonBodyUsagesItemKind

T = TypeVar("T", bound="ListAssetsByUsageJsonBodyUsagesItem")


@_attrs_define
class ListAssetsByUsageJsonBodyUsagesItem:
    """
    Attributes:
        path (str):
        kind (ListAssetsByUsageJsonBodyUsagesItemKind):
    """

    path: str
    kind: ListAssetsByUsageJsonBodyUsagesItemKind
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        path = self.path
        kind = self.kind.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "path": path,
                "kind": kind,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        path = d.pop("path")

        kind = ListAssetsByUsageJsonBodyUsagesItemKind(d.pop("kind"))

        list_assets_by_usage_json_body_usages_item = cls(
            path=path,
            kind=kind,
        )

        list_assets_by_usage_json_body_usages_item.additional_properties = d
        return list_assets_by_usage_json_body_usages_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
