# Generated by Django 4.2.24 on 2025-09-25 19:43

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Ingredient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("storage_date", models.DateField(verbose_name="入库日期")),
                (
                    "name",
                    models.CharField(max_length=100, verbose_name="食材名"),
                ),
                (
                    "meal_type",
                    models.CharField(max_length=50, verbose_name="餐类"),
                ),
                (
                    "category",
                    models.CharField(max_length=50, verbose_name="食材大类"),
                ),
                (
                    "quantity",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="数量"
                    ),
                ),
                (
                    "total_price",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="总价"
                    ),
                ),
                (
                    "quantity_unit_name",
                    models.CharField(
                        blank=True,
                        max_length=20,
                        null=True,
                        verbose_name="数量单位",
                    ),
                ),
                (
                    "is_ignorable",
                    models.BooleanField(
                        default=False, verbose_name="是不用入库的"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ingredients",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="用户",
                    ),
                ),
            ],
            options={
                "verbose_name": "Ingredient",
                "verbose_name_plural": "食材列表",
            },
        ),
        migrations.CreateModel(
            name="Consumption",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date_of_using", models.DateField(verbose_name="日期")),
                (
                    "amount_used",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="消耗数量"
                    ),
                ),
                (
                    "ingredient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="consumptions",
                        to="canteen.ingredient",
                        verbose_name="食材",
                    ),
                ),
            ],
            options={
                "verbose_name": "消耗记录",
                "verbose_name_plural": "消耗记录列表",
                "ordering": ["-date_of_using"],
            },
        ),
    ]
