# Generated by Django 4.2.25 on 2025-10-08 16:46

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("canteen", "0009_alter_category_abbreviation_and_more"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="consumption",
            options={
                "ordering": ["-date_of_using"],
                "verbose_name": "Consumption Record",
                "verbose_name_plural": "Consumption Records",
            },
        ),
        migrations.AlterModelOptions(
            name="ingredient",
            options={
                "verbose_name": "Ingredient",
                "verbose_name_plural": "Ingredient List",
            },
        ),
        migrations.AlterField(
            model_name="category",
            name="abbreviation",
            field=models.CharField(
                blank=True,
                max_length=100,
                null=True,
                verbose_name="abbreviation",
            ),
        ),
        migrations.AlterField(
            model_name="category",
            name="created_at",
            field=models.DateField(verbose_name="Creating Date"),
        ),
        migrations.AlterField(
            model_name="category",
            name="is_disabled",
            field=models.BooleanField(
                default=False, verbose_name="Is Disabled"
            ),
        ),
        migrations.AlterField(
            model_name="category",
            name="name",
            field=models.CharField(
                max_length=100, verbose_name="Category name"
            ),
        ),
        migrations.AlterField(
            model_name="category",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="Categories",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Ingredient category",
            ),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="date_of_using",
            field=models.DateField(verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="ingredient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="consumptions",
                to="canteen.ingredient",
                verbose_name="Ingredient",
            ),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="is_disabled",
            field=models.BooleanField(
                default=False, verbose_name="Is Disabled"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="category",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ingredients",
                to="canteen.category",
                verbose_name="Ingredient Category",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="is_disabled",
            field=models.BooleanField(
                default=False, verbose_name="Is Ingredient Disabled"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="is_ignorable",
            field=models.BooleanField(
                default=False, verbose_name="Is Ingredient Ignorable"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="meal_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ingredients",
                to="canteen.mealtype",
                verbose_name="Ingredient Meal Type",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="name",
            field=models.CharField(
                max_length=100, verbose_name="Ingredient Name"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="quantity",
            field=models.IntegerField(
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Ingredient Quantity",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="quantity_unit_name",
            field=models.CharField(
                blank=True,
                max_length=20,
                null=True,
                verbose_name="Unit Name of Ingredient Quantity",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="storage_date",
            field=models.DateField(verbose_name="Storage Date"),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="total_price",
            field=models.DecimalField(
                decimal_places=2,
                max_digits=10,
                verbose_name="Ingredient Total Price",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="ingredients",
                to=settings.AUTH_USER_MODEL,
                verbose_name="User",
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="abbreviation",
            field=models.CharField(
                blank=True,
                max_length=100,
                null=True,
                verbose_name="Abbreviation",
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="created_at",
            field=models.DateField(verbose_name="Creating Date"),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="is_disabled",
            field=models.BooleanField(
                default=False, verbose_name="Is Disabled"
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="name",
            field=models.CharField(
                max_length=100, verbose_name="Meal type name"
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="meal_types",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Ingredient meal type",
            ),
        ),
    ]
