# Generated by Django 4.2.25 on 2025-10-12 07:14

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("canteen", "0012_alter_ingredient_storage_date"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="consumption",
            options={
                "ordering": ["-date_of_using"],
                "verbose_name": "消耗记录",
                "verbose_name_plural": "消耗记录列表",
            },
        ),
        migrations.AlterModelOptions(
            name="ingredient",
            options={
                "verbose_name": "Ingredient",
                "verbose_name_plural": "食材列表",
            },
        ),
        migrations.AlterField(
            model_name="category",
            name="abbreviation",
            field=models.CharField(
                blank=True, max_length=100, null=True, verbose_name="简称"
            ),
        ),
        migrations.AlterField(
            model_name="category",
            name="created_at",
            field=models.DateField(verbose_name="创建日期"),
        ),
        migrations.AlterField(
            model_name="category",
            name="is_disabled",
            field=models.BooleanField(default=False, verbose_name="已禁用"),
        ),
        migrations.AlterField(
            model_name="category",
            name="name",
            field=models.CharField(max_length=100, verbose_name="食材大类名"),
        ),
        migrations.AlterField(
            model_name="category",
            name="pin_to_consumptions_top",
            field=models.BooleanField(default=False, verbose_name="置顶出库"),
        ),
        migrations.AlterField(
            model_name="category",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="Categories",
                to=settings.AUTH_USER_MODEL,
                verbose_name="大类",
            ),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="date_of_using",
            field=models.DateField(verbose_name="日期"),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="ingredient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="consumptions",
                to="canteen.ingredient",
                verbose_name="食材",
            ),
        ),
        migrations.AlterField(
            model_name="consumption",
            name="is_disabled",
            field=models.BooleanField(default=False, verbose_name="已禁用"),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="category",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ingredients",
                to="canteen.category",
                verbose_name="大类",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="is_disabled",
            field=models.BooleanField(default=False, verbose_name="禁用"),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="is_ignorable",
            field=models.BooleanField(default=False, verbose_name="不入库"),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="meal_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ingredients",
                to="canteen.mealtype",
                verbose_name="餐类",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="name",
            field=models.CharField(max_length=100, verbose_name="食材名"),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="quantity",
            field=models.IntegerField(
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="数量",
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="quantity_unit_name",
            field=models.CharField(
                blank=True, max_length=20, null=True, verbose_name="数量单位"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="storage_date",
            field=models.DateField(
                default=django.utils.timezone.now, verbose_name="入库日期"
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="total_price",
            field=models.DecimalField(
                decimal_places=2, max_digits=10, verbose_name="总价"
            ),
        ),
        migrations.AlterField(
            model_name="ingredient",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="ingredients",
                to=settings.AUTH_USER_MODEL,
                verbose_name="用户",
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="abbreviation",
            field=models.CharField(
                blank=True, max_length=100, null=True, verbose_name="简称"
            ),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="created_at",
            field=models.DateField(verbose_name="创建日期"),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="is_disabled",
            field=models.BooleanField(default=False, verbose_name="已禁用"),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="name",
            field=models.CharField(max_length=100, verbose_name="餐类名称"),
        ),
        migrations.AlterField(
            model_name="mealtype",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="meal_types",
                to=settings.AUTH_USER_MODEL,
                verbose_name="餐类",
            ),
        ),
    ]
