"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeOwners = void 0;
const projen_1 = require("projen");
const javascript_1 = require("projen/lib/javascript");
class CodeOwners {
    constructor(project, codeOwners) {
        if (project instanceof javascript_1.NodeProject) {
            project.npmignore?.addPatterns('CODEOWNERS');
        }
        new projen_1.TextFile(project, 'CODEOWNERS', {
            lines: codeOwners.map((owner) => `* ${owner}`),
        });
    }
}
exports.CodeOwners = CodeOwners;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZW93bmVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2dpdGh1Yi9jb2Rlb3duZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLG1DQUFrQztBQUNsQyxzREFBb0Q7QUFFcEQsTUFBYSxVQUFVO0lBQ3JCLFlBQVksT0FBbUIsRUFBRSxVQUF5QjtRQUN4RCxJQUFJLE9BQU8sWUFBWSx3QkFBVyxFQUFFLENBQUM7WUFDbkMsT0FBTyxDQUFDLFNBQVMsRUFBRSxXQUFXLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDL0MsQ0FBQztRQUVELElBQUksaUJBQVEsQ0FBQyxPQUFPLEVBQUUsWUFBWSxFQUFFO1lBQ2xDLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxLQUFLLEtBQUssRUFBRSxDQUFDO1NBQy9DLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQVZELGdDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgVGV4dEZpbGUgfSBmcm9tICdwcm9qZW4nO1xuaW1wb3J0IHsgTm9kZVByb2plY3QgfSBmcm9tICdwcm9qZW4vbGliL2phdmFzY3JpcHQnO1xuXG5leHBvcnQgY2xhc3MgQ29kZU93bmVycyB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IElDb25zdHJ1Y3QsIGNvZGVPd25lcnM6IEFycmF5PHN0cmluZz4pIHtcbiAgICBpZiAocHJvamVjdCBpbnN0YW5jZW9mIE5vZGVQcm9qZWN0KSB7XG4gICAgICBwcm9qZWN0Lm5wbWlnbm9yZT8uYWRkUGF0dGVybnMoJ0NPREVPV05FUlMnKTtcbiAgICB9XG5cbiAgICBuZXcgVGV4dEZpbGUocHJvamVjdCwgJ0NPREVPV05FUlMnLCB7XG4gICAgICBsaW5lczogY29kZU93bmVycy5tYXAoKG93bmVyKSA9PiBgKiAke293bmVyfWApLFxuICAgIH0pO1xuICB9XG59XG4iXX0=