import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CertRequestConfig extends cdktf.TerraformMetaArguments {
    /**
     * List of DNS names to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#dns_names CertRequest#dns_names}
     *
     * @stability stable
     */
    readonly dnsNames?: string[];
    /**
     * List of IP addresses to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#ip_addresses CertRequest#ip_addresses}
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
    /**
     * Name of the algorithm to use to generate the certificate's private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#key_algorithm CertRequest#key_algorithm}
     *
     * @stability stable
     */
    readonly keyAlgorithm: string;
    /**
     * PEM-encoded private key that the certificate will belong to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#private_key_pem CertRequest#private_key_pem}
     *
     * @stability stable
     */
    readonly privateKeyPem: string;
    /**
     * List of URIs to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#uris CertRequest#uris}
     *
     * @stability stable
     */
    readonly uris?: string[];
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#subject CertRequest#subject}
     *
     * @stability stable
     */
    readonly subject: CertRequestSubject[];
}
/**
 * @stability stable
 */
export interface CertRequestSubject {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#common_name CertRequest#common_name}.
     *
     * @stability stable
     */
    readonly commonName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#country CertRequest#country}.
     *
     * @stability stable
     */
    readonly country?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#locality CertRequest#locality}.
     *
     * @stability stable
     */
    readonly locality?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#organization CertRequest#organization}.
     *
     * @stability stable
     */
    readonly organization?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#organizational_unit CertRequest#organizational_unit}.
     *
     * @stability stable
     */
    readonly organizationalUnit?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#postal_code CertRequest#postal_code}.
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#province CertRequest#province}.
     *
     * @stability stable
     */
    readonly province?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#serial_number CertRequest#serial_number}.
     *
     * @stability stable
     */
    readonly serialNumber?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html#street_address CertRequest#street_address}.
     *
     * @stability stable
     */
    readonly streetAddress?: string[];
}
export declare function certRequestSubjectToTerraform(struct?: CertRequestSubject): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html tls_cert_request}.
 *
 * @stability stable
 */
export declare class CertRequest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/r/cert_request.html tls_cert_request} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CertRequestConfig);
    /**
     * @stability stable
     */
    get certRequestPem(): string;
    private _dnsNames?;
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    set dnsNames(value: string[]);
    /**
     * @stability stable
     */
    resetDnsNames(): void;
    /**
     * @stability stable
     */
    get dnsNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    set ipAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string[] | undefined;
    private _keyAlgorithm?;
    /**
     * @stability stable
     */
    get keyAlgorithm(): string;
    /**
     * @stability stable
     */
    set keyAlgorithm(value: string);
    /**
     * @stability stable
     */
    get keyAlgorithmInput(): string | undefined;
    private _privateKeyPem?;
    /**
     * @stability stable
     */
    get privateKeyPem(): string;
    /**
     * @stability stable
     */
    set privateKeyPem(value: string);
    /**
     * @stability stable
     */
    get privateKeyPemInput(): string | undefined;
    private _uris?;
    /**
     * @stability stable
     */
    get uris(): string[];
    /**
     * @stability stable
     */
    set uris(value: string[]);
    /**
     * @stability stable
     */
    resetUris(): void;
    /**
     * @stability stable
     */
    get urisInput(): string[] | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): CertRequestSubject[];
    /**
     * @stability stable
     */
    set subject(value: CertRequestSubject[]);
    /**
     * @stability stable
     */
    get subjectInput(): CertRequestSubject[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
