# AutoProperty library

- [What it used for](#What-it-used-for)
- [How does this work](#how-does-this-work)
- [Usage](#usage)  
    - [Syntax](#syntax)
    - [Annotations](#annotations)
- [Example](#example)
- [Documentation](#documentation)
- [Plans](#plans)
- [Feedback](#feedback)

## What it used for?

This open source library is used for creating autogenerated properties with type validation.  

I think it is very comfy to use and less code to write.  

I just have enough of writting millions and trillions of "@property" decorators and setters for them. It also have type validation, as a bonus.

## How does this work?

Basically it is just a common **property** but with autogenerated getters and setters (no deleters for now, will be added later) like in Csharp but without access modifiers. I tried to achieve the better speed perfomance as the basic solution.  

It also has builtin field validation from pydantic but you can turn it off (turned on by default) and save some time on the runtime.

You **do not need** to do anything - only smoke the cigarrete, throw legs on a table and rest. Let it do all hard and boring work. You are the **king** and you **deserve** no other treatment. (Joke)

Jokes aside, it do all hard work, let me show you.

## Usage

### Syntax

Base syntax.

```python
class Exmpl:
    @AutoProperty[int] # <- generic need for correct IDE syntax highlighting
    def some_prop(self) -> int: ... # <- no need to implement, it won't change anything
                          # ^ type annotation for checking object in setter

obj = Exmpl()
obj.some_prop = 42
```

In runtime it turns construction above to a construction like below:

```python
class Exmpl:
    _some_prop = 42

    @AutoProperty[int]
    def some_prop(self) -> int: ...

obj = Exmpl()
obj.some_prop = 42
```


### Annotations

You **have to** add at **least one** annotation to any of these **three places** (If you didnt turned off type validation). Be careful to **not mix them up**. They all have to **be the same**, otherwise will raise **an error**.

```python
class Exmpl:
    _some_prop: int # <- one

    @AutoProperty[int](annotation_type=int) # <- two
    def some_prop(self) -> int: ...
                          # ^ three
```


## Example

```python
from autoproperty import AutoProperty


class Point:
    def __init__(self, x: int, y: int):
        self.X = x
        self.Y = y

    @AutoProperty[int]
    def X(self) -> int: ...

    @AutoProperty[int]
    def Y(self) -> int: ...

    def __repr__(self) -> str:
        return f"[{self.X};{self.Y}]"


myPointOne = Point(2, 6)

print(myPointOne.X) # 2

print(myPointOne) # [2; 6]
```

## Documentation

More info about syntax and options you can find in docs folder. Here is a [base example](autoproperty/docs/basic_example.md).

## Known problems

- Not tested yet with classmethods or staticmethods, only bound methods, but it may work.

## Plans

Currently I'm planning to add these features to the lib:

- The opportunity to add your own validation.
- The opportunity to add handlers to "set" and "get" events.
- The lightweight autoproperty class for high load projects
- Modificators like "read-only"
- The opportunity to add your own getter and setter using protocols

## Feedback

If you want to ask me something, you have solution one of the above problems, you have an offer to me or any other reason, please open an issue or message me via email alecsw86@gmail.com.