# BML SDK

A placeholder Python SDK package for BML.

## Installation

```bash
pip install bso
```

## Usage

```python
from bml import hello_world, add

# Say hello
print(hello_world())

# Add numbers
result = add(2, 3)
print(result)  # Output: 5
```

## Development

To set up a development environment:

```bash
# Clone the repository
git clone https://github.com/yourorg/bml.git
cd bml

# Install in development mode with dev dependencies
pip install -e ".[dev]"

# Run tests
pytest

# Format code
black .

# Type check
mypy bml
```

## Building and Publishing

To build the package:

```bash
python -m build
```

To publish to PyPI:

```bash
# First, install build tools
pip install build twine

# Build the package
python -m build

# Upload to PyPI (test first with testpypi)
twine upload dist/*
```

## License

MIT License - see LICENSE file for details.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

