# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ArgoArgs', 'Argo']

@pulumi.input_type
class ArgoArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[str],
                 smart_routing: Optional[pulumi.Input[str]] = None,
                 tiered_caching: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Argo resource.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        :param pulumi.Input[str] smart_routing: Whether smart routing is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] tiered_caching: Whether tiered caching is enabled. Available values: `on`, `off`.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if smart_routing is not None:
            pulumi.set(__self__, "smart_routing", smart_routing)
        if tiered_caching is not None:
            warnings.warn("""tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tiered_caching is deprecated: tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""")
        if tiered_caching is not None:
            pulumi.set(__self__, "tiered_caching", tiered_caching)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> Optional[pulumi.Input[str]]:
        """
        Whether smart routing is enabled. Available values: `on`, `off`.
        """
        return pulumi.get(self, "smart_routing")

    @smart_routing.setter
    def smart_routing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smart_routing", value)

    @property
    @pulumi.getter(name="tieredCaching")
    def tiered_caching(self) -> Optional[pulumi.Input[str]]:
        """
        Whether tiered caching is enabled. Available values: `on`, `off`.
        """
        warnings.warn("""tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""", DeprecationWarning)
        pulumi.log.warn("""tiered_caching is deprecated: tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""")

        return pulumi.get(self, "tiered_caching")

    @tiered_caching.setter
    def tiered_caching(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tiered_caching", value)


@pulumi.input_type
class _ArgoState:
    def __init__(__self__, *,
                 smart_routing: Optional[pulumi.Input[str]] = None,
                 tiered_caching: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Argo resources.
        :param pulumi.Input[str] smart_routing: Whether smart routing is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] tiered_caching: Whether tiered caching is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        if smart_routing is not None:
            pulumi.set(__self__, "smart_routing", smart_routing)
        if tiered_caching is not None:
            warnings.warn("""tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tiered_caching is deprecated: tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""")
        if tiered_caching is not None:
            pulumi.set(__self__, "tiered_caching", tiered_caching)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> Optional[pulumi.Input[str]]:
        """
        Whether smart routing is enabled. Available values: `on`, `off`.
        """
        return pulumi.get(self, "smart_routing")

    @smart_routing.setter
    def smart_routing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smart_routing", value)

    @property
    @pulumi.getter(name="tieredCaching")
    def tiered_caching(self) -> Optional[pulumi.Input[str]]:
        """
        Whether tiered caching is enabled. Available values: `on`, `off`.
        """
        warnings.warn("""tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""", DeprecationWarning)
        pulumi.log.warn("""tiered_caching is deprecated: tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""")

        return pulumi.get(self, "tiered_caching")

    @tiered_caching.setter
    def tiered_caching(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tiered_caching", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Argo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 smart_routing: Optional[pulumi.Input[str]] = None,
                 tiered_caching: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cloudflare Argo controls the routing to your origin and tiered
        caching options to speed up your website browsing experience.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.Argo("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            tiered_caching="on",
            smart_routing="on")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/argo:Argo example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] smart_routing: Whether smart routing is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] tiered_caching: Whether tiered caching is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ArgoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloudflare Argo controls the routing to your origin and tiered
        caching options to speed up your website browsing experience.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.Argo("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            tiered_caching="on",
            smart_routing="on")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/argo:Argo example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param ArgoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArgoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 smart_routing: Optional[pulumi.Input[str]] = None,
                 tiered_caching: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArgoArgs.__new__(ArgoArgs)

            __props__.__dict__["smart_routing"] = smart_routing
            __props__.__dict__["tiered_caching"] = tiered_caching
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(Argo, __self__).__init__(
            'cloudflare:index/argo:Argo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            smart_routing: Optional[pulumi.Input[str]] = None,
            tiered_caching: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Argo':
        """
        Get an existing Argo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] smart_routing: Whether smart routing is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] tiered_caching: Whether tiered caching is enabled. Available values: `on`, `off`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ArgoState.__new__(_ArgoState)

        __props__.__dict__["smart_routing"] = smart_routing
        __props__.__dict__["tiered_caching"] = tiered_caching
        __props__.__dict__["zone_id"] = zone_id
        return Argo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> pulumi.Output[Optional[str]]:
        """
        Whether smart routing is enabled. Available values: `on`, `off`.
        """
        return pulumi.get(self, "smart_routing")

    @property
    @pulumi.getter(name="tieredCaching")
    def tiered_caching(self) -> pulumi.Output[Optional[str]]:
        """
        Whether tiered caching is enabled. Available values: `on`, `off`.
        """
        warnings.warn("""tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""", DeprecationWarning)
        pulumi.log.warn("""tiered_caching is deprecated: tiered_caching has been deprecated in favour of using `TieredCache` resource instead.""")

        return pulumi.get(self, "tiered_caching")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

