# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAccessApplicationResult',
    'AwaitableGetAccessApplicationResult',
    'get_access_application',
    'get_access_application_output',
]

@pulumi.output_type
class GetAccessApplicationResult:
    """
    A collection of values returned by getAccessApplication.
    """
    def __init__(__self__, account_id=None, aud=None, domain=None, id=None, name=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if aud and not isinstance(aud, str):
            raise TypeError("Expected argument 'aud' to be a str")
        pulumi.set(__self__, "aud", aud)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The account identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def aud(self) -> str:
        """
        Application Audience (AUD) Tag of the application.
        """
        return pulumi.get(self, "aud")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The primary hostname and path that Access will secure. Must provide only one of `name`, `domain`.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Friendly name of the Access Application. Must provide only one of `name`, `domain`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The zone identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetAccessApplicationResult(GetAccessApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessApplicationResult(
            account_id=self.account_id,
            aud=self.aud,
            domain=self.domain,
            id=self.id,
            name=self.name,
            zone_id=self.zone_id)


def get_access_application(account_id: Optional[str] = None,
                           domain: Optional[str] = None,
                           name: Optional[str] = None,
                           zone_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessApplicationResult:
    """
    Use this data source to lookup a single [Access Application](https://developers.cloudflare.com/cloudflare-one/applications/)


    :param str account_id: The account identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
    :param str domain: The primary hostname and path that Access will secure. Must provide only one of `name`, `domain`.
    :param str name: Friendly name of the Access Application. Must provide only one of `name`, `domain`.
    :param str zone_id: The zone identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['domain'] = domain
    __args__['name'] = name
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccessApplication:getAccessApplication', __args__, opts=opts, typ=GetAccessApplicationResult).value

    return AwaitableGetAccessApplicationResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        aud=pulumi.get(__ret__, 'aud'),
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(get_access_application)
def get_access_application_output(account_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  domain: Optional[pulumi.Input[Optional[str]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessApplicationResult]:
    """
    Use this data source to lookup a single [Access Application](https://developers.cloudflare.com/cloudflare-one/applications/)


    :param str account_id: The account identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
    :param str domain: The primary hostname and path that Access will secure. Must provide only one of `name`, `domain`.
    :param str name: Friendly name of the Access Application. Must provide only one of `name`, `domain`.
    :param str zone_id: The zone identifier to target for the resource. Must provide only one of `zone_id`, `account_id`.
    """
    ...
