# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HealthcheckArgs', 'Healthcheck']

@pulumi.input_type
class HealthcheckArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[int]] = None,
                 consecutive_successes: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Healthcheck resource.
        :param pulumi.Input[str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[str] name: A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[str] type: The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        :param pulumi.Input[int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        :param pulumi.Input[int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        :param pulumi.Input[str] description: A human-readable description of the health check.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_codes: The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        :param pulumi.Input[bool] follow_redirects: Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        :param pulumi.Input[str] path: The endpoint path to health check against. Defaults to `/`.
        :param pulumi.Input[int] port: Port number to connect to for the health check. Defaults to `80`.
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[bool] suspended: If suspended, no health checks are sent to the origin. Defaults to `false`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if consecutive_fails is not None:
            pulumi.set(__self__, "consecutive_fails", consecutive_fails)
        if consecutive_successes is not None:
            pulumi.set(__self__, "consecutive_successes", consecutive_successes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_fails")

    @consecutive_fails.setter
    def consecutive_fails(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_fails", value)

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_successes")

    @consecutive_successes.setter
    def consecutive_successes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_successes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        """
        Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint path to health check against. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to connect to for the health check. Defaults to `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        If suspended, no health checks are sent to the origin. Defaults to `false`.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _HealthcheckState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[int]] = None,
                 consecutive_successes: Optional[pulumi.Input[int]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 modified_on: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Healthcheck resources.
        :param pulumi.Input[str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        :param pulumi.Input[int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        :param pulumi.Input[int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        :param pulumi.Input[str] created_on: Creation time.
        :param pulumi.Input[str] description: A human-readable description of the health check.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_codes: The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        :param pulumi.Input[bool] follow_redirects: Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        :param pulumi.Input[str] modified_on: Last modified time.
        :param pulumi.Input[str] name: A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[str] path: The endpoint path to health check against. Defaults to `/`.
        :param pulumi.Input[int] port: Port number to connect to for the health check. Defaults to `80`.
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[bool] suspended: If suspended, no health checks are sent to the origin. Defaults to `false`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if consecutive_fails is not None:
            pulumi.set(__self__, "consecutive_fails", consecutive_fails)
        if consecutive_successes is not None:
            pulumi.set(__self__, "consecutive_successes", consecutive_successes)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_fails")

    @consecutive_fails.setter
    def consecutive_fails(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_fails", value)

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_successes")

    @consecutive_successes.setter
    def consecutive_successes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_successes", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        """
        Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HealthcheckHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[str]]:
        """
        Last modified time.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint path to health check against. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to connect to for the health check. Defaults to `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        If suspended, no health checks are sent to the origin. Defaults to `false`.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Healthcheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[int]] = None,
                 consecutive_successes: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HealthcheckHeaderArgs']]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Standalone Health Checks provide a way to monitor origin servers
        without needing a Cloudflare Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # HTTPS Healthcheck
        http_health_check = cloudflare.Healthcheck("http_health_check",
            zone_id=cloudflare_zone_id,
            name="http-health-check",
            description="example http health check",
            address="example.com",
            suspended=False,
            check_regions=[
                "WEU",
                "EEU",
            ],
            type="HTTPS",
            port=443,
            method="GET",
            path="/health",
            expected_body="alive",
            expected_codes=[
                "2xx",
                "301",
            ],
            follow_redirects=True,
            allow_insecure=False,
            headers=[cloudflare.HealthcheckHeaderArgs(
                header="Host",
                values=["example.com"],
            )],
            timeout=10,
            retries=2,
            interval=60,
            consecutive_fails=3,
            consecutive_successes=2)
        # TCP Healthcheck
        tcp_health_check = cloudflare.Healthcheck("tcp_health_check",
            zone_id=cloudflare_zone_id,
            name="tcp-health-check",
            description="example tcp health check",
            address="example.com",
            suspended=False,
            check_regions=[
                "WEU",
                "EEU",
            ],
            type="TCP",
            port=22,
            method="connection_established",
            timeout=10,
            retries=2,
            interval=60,
            consecutive_fails=3,
            consecutive_successes=2)
        ```

        ## Import

        Use the Zone ID and Healthcheck ID to import.

        ```sh
        $ pulumi import cloudflare:index/healthcheck:Healthcheck example <zone_id>/<healthcheck_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        :param pulumi.Input[int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        :param pulumi.Input[int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        :param pulumi.Input[str] description: A human-readable description of the health check.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_codes: The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        :param pulumi.Input[bool] follow_redirects: Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HealthcheckHeaderArgs']]]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        :param pulumi.Input[str] name: A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[str] path: The endpoint path to health check against. Defaults to `/`.
        :param pulumi.Input[int] port: Port number to connect to for the health check. Defaults to `80`.
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[bool] suspended: If suspended, no health checks are sent to the origin. Defaults to `false`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthcheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Standalone Health Checks provide a way to monitor origin servers
        without needing a Cloudflare Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # HTTPS Healthcheck
        http_health_check = cloudflare.Healthcheck("http_health_check",
            zone_id=cloudflare_zone_id,
            name="http-health-check",
            description="example http health check",
            address="example.com",
            suspended=False,
            check_regions=[
                "WEU",
                "EEU",
            ],
            type="HTTPS",
            port=443,
            method="GET",
            path="/health",
            expected_body="alive",
            expected_codes=[
                "2xx",
                "301",
            ],
            follow_redirects=True,
            allow_insecure=False,
            headers=[cloudflare.HealthcheckHeaderArgs(
                header="Host",
                values=["example.com"],
            )],
            timeout=10,
            retries=2,
            interval=60,
            consecutive_fails=3,
            consecutive_successes=2)
        # TCP Healthcheck
        tcp_health_check = cloudflare.Healthcheck("tcp_health_check",
            zone_id=cloudflare_zone_id,
            name="tcp-health-check",
            description="example tcp health check",
            address="example.com",
            suspended=False,
            check_regions=[
                "WEU",
                "EEU",
            ],
            type="TCP",
            port=22,
            method="connection_established",
            timeout=10,
            retries=2,
            interval=60,
            consecutive_fails=3,
            consecutive_successes=2)
        ```

        ## Import

        Use the Zone ID and Healthcheck ID to import.

        ```sh
        $ pulumi import cloudflare:index/healthcheck:Healthcheck example <zone_id>/<healthcheck_id>
        ```

        :param str resource_name: The name of the resource.
        :param HealthcheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthcheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[int]] = None,
                 consecutive_successes: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HealthcheckHeaderArgs']]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthcheckArgs.__new__(HealthcheckArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["allow_insecure"] = allow_insecure
            __props__.__dict__["check_regions"] = check_regions
            __props__.__dict__["consecutive_fails"] = consecutive_fails
            __props__.__dict__["consecutive_successes"] = consecutive_successes
            __props__.__dict__["description"] = description
            __props__.__dict__["expected_body"] = expected_body
            __props__.__dict__["expected_codes"] = expected_codes
            __props__.__dict__["follow_redirects"] = follow_redirects
            __props__.__dict__["headers"] = headers
            __props__.__dict__["interval"] = interval
            __props__.__dict__["method"] = method
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["path"] = path
            __props__.__dict__["port"] = port
            __props__.__dict__["retries"] = retries
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["timeout"] = timeout
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(Healthcheck, __self__).__init__(
            'cloudflare:index/healthcheck:Healthcheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            allow_insecure: Optional[pulumi.Input[bool]] = None,
            check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            consecutive_fails: Optional[pulumi.Input[int]] = None,
            consecutive_successes: Optional[pulumi.Input[int]] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expected_body: Optional[pulumi.Input[str]] = None,
            expected_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            follow_redirects: Optional[pulumi.Input[bool]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HealthcheckHeaderArgs']]]]] = None,
            interval: Optional[pulumi.Input[int]] = None,
            method: Optional[pulumi.Input[str]] = None,
            modified_on: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            retries: Optional[pulumi.Input[int]] = None,
            suspended: Optional[pulumi.Input[bool]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Healthcheck':
        """
        Get an existing Healthcheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        :param pulumi.Input[int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        :param pulumi.Input[int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        :param pulumi.Input[str] created_on: Creation time.
        :param pulumi.Input[str] description: A human-readable description of the health check.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_codes: The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        :param pulumi.Input[bool] follow_redirects: Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HealthcheckHeaderArgs']]]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        :param pulumi.Input[str] modified_on: Last modified time.
        :param pulumi.Input[str] name: A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[str] path: The endpoint path to health check against. Defaults to `/`.
        :param pulumi.Input[int] port: Port number to connect to for the health check. Defaults to `80`.
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[bool] suspended: If suspended, no health checks are sent to the origin. Defaults to `false`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthcheckState.__new__(_HealthcheckState)

        __props__.__dict__["address"] = address
        __props__.__dict__["allow_insecure"] = allow_insecure
        __props__.__dict__["check_regions"] = check_regions
        __props__.__dict__["consecutive_fails"] = consecutive_fails
        __props__.__dict__["consecutive_successes"] = consecutive_successes
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["expected_body"] = expected_body
        __props__.__dict__["expected_codes"] = expected_codes
        __props__.__dict__["follow_redirects"] = follow_redirects
        __props__.__dict__["headers"] = headers
        __props__.__dict__["interval"] = interval
        __props__.__dict__["method"] = method
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["retries"] = retries
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return Healthcheck(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not validate the certificate when the health check uses HTTPS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of regions from which to run health checks. If not set, Cloudflare will pick a default region. Available values: `WNAM`, `ENAM`, `WEU`, `EEU`, `NSAM`, `SSAM`, `OC`, `ME`, `NAF`, `SAF`, `IN`, `SEAS`, `NEAS`, `ALL_REGIONS`.
        """
        return pulumi.get(self, "check_regions")

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> pulumi.Output[Optional[int]]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_fails")

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> pulumi.Output[Optional[int]]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy. Defaults to `1`.
        """
        return pulumi.get(self, "consecutive_successes")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> pulumi.Output[Optional[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found the origin will be marked as unhealthy.
        """
        return pulumi.get(self, "expected_body")

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The expected HTTP response codes (e.g. '200') or code ranges (e.g. '2xx' for all codes starting with 2) of the health check.
        """
        return pulumi.get(self, "expected_codes")

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> pulumi.Output[Optional[bool]]:
        """
        Follow redirects if the origin returns a 3xx status code. Defaults to `false`.
        """
        return pulumi.get(self, "follow_redirects")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.HealthcheckHeader']]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase the load on the origin as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[str]:
        """
        The HTTP method to use for the health check. Available values: `connection_established`, `GET`, `HEAD`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[str]:
        """
        Last modified time.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint path to health check against. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        Port number to connect to for the health check. Defaults to `80`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[Optional[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[bool]]:
        """
        If suspended, no health checks are sent to the origin. Defaults to `false`.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The protocol to use for the health check. Available values: `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

