# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IpsecTunnelArgs', 'IpsecTunnel']

@pulumi.input_type
class IpsecTunnelArgs:
    def __init__(__self__, *,
                 cloudflare_endpoint: pulumi.Input[str],
                 customer_endpoint: pulumi.Input[str],
                 interface_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_null_cipher: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn_id: Optional[pulumi.Input[str]] = None,
                 health_check_direction: Optional[pulumi.Input[str]] = None,
                 health_check_enabled: Optional[pulumi.Input[bool]] = None,
                 health_check_rate: Optional[pulumi.Input[str]] = None,
                 health_check_target: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 hex_id: Optional[pulumi.Input[str]] = None,
                 psk: Optional[pulumi.Input[str]] = None,
                 remote_id: Optional[pulumi.Input[str]] = None,
                 replay_protection: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IpsecTunnel resource.
        :param pulumi.Input[str] cloudflare_endpoint: IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[str] customer_endpoint: IP address assigned to the customer side of the IPsec tunnel.
        :param pulumi.Input[str] interface_address: 31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        :param pulumi.Input[str] name: Name of the IPsec tunnel.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] allow_null_cipher: Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        :param pulumi.Input[str] description: An optional description of the IPsec tunnel.
        :param pulumi.Input[str] fqdn_id: `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        :param pulumi.Input[str] health_check_direction: Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        :param pulumi.Input[bool] health_check_enabled: Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        :param pulumi.Input[str] health_check_rate: Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        :param pulumi.Input[str] health_check_target: The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        :param pulumi.Input[str] health_check_type: Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        :param pulumi.Input[str] hex_id: `remote_id` as a hex string. This value is generated by cloudflare.
        :param pulumi.Input[str] psk: Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        :param pulumi.Input[str] remote_id: ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        :param pulumi.Input[bool] replay_protection: Specifies if replay protection is enabled. Defaults to `false`.
        :param pulumi.Input[str] user_id: `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        pulumi.set(__self__, "cloudflare_endpoint", cloudflare_endpoint)
        pulumi.set(__self__, "customer_endpoint", customer_endpoint)
        pulumi.set(__self__, "interface_address", interface_address)
        pulumi.set(__self__, "name", name)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_null_cipher is not None:
            pulumi.set(__self__, "allow_null_cipher", allow_null_cipher)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn_id is not None:
            pulumi.set(__self__, "fqdn_id", fqdn_id)
        if health_check_direction is not None:
            pulumi.set(__self__, "health_check_direction", health_check_direction)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_rate is not None:
            pulumi.set(__self__, "health_check_rate", health_check_rate)
        if health_check_target is not None:
            pulumi.set(__self__, "health_check_target", health_check_target)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if hex_id is not None:
            pulumi.set(__self__, "hex_id", hex_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)
        if replay_protection is not None:
            pulumi.set(__self__, "replay_protection", replay_protection)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> pulumi.Input[str]:
        """
        IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @cloudflare_endpoint.setter
    def cloudflare_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudflare_endpoint", value)

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> pulumi.Input[str]:
        """
        IP address assigned to the customer side of the IPsec tunnel.
        """
        return pulumi.get(self, "customer_endpoint")

    @customer_endpoint.setter
    def customer_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_endpoint", value)

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Input[str]:
        """
        31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "interface_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the IPsec tunnel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowNullCipher")
    def allow_null_cipher(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        """
        return pulumi.get(self, "allow_null_cipher")

    @allow_null_cipher.setter
    def allow_null_cipher(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_null_cipher", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fqdnId")
    def fqdn_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        """
        return pulumi.get(self, "fqdn_id")

    @fqdn_id.setter
    def fqdn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_id", value)

    @property
    @pulumi.getter(name="healthCheckDirection")
    def health_check_direction(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        """
        return pulumi.get(self, "health_check_direction")

    @health_check_direction.setter
    def health_check_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_direction", value)

    @property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        """
        return pulumi.get(self, "health_check_enabled")

    @health_check_enabled.setter
    def health_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "health_check_enabled", value)

    @property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        """
        return pulumi.get(self, "health_check_rate")

    @health_check_rate.setter
    def health_check_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_rate", value)

    @property
    @pulumi.getter(name="healthCheckTarget")
    def health_check_target(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        """
        return pulumi.get(self, "health_check_target")

    @health_check_target.setter
    def health_check_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_target", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="hexId")
    def hex_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` as a hex string. This value is generated by cloudflare.
        """
        return pulumi.get(self, "hex_id")

    @hex_id.setter
    def hex_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hex_id", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[str]]:
        """
        Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_id", value)

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if replay protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "replay_protection")

    @replay_protection.setter
    def replay_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replay_protection", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _IpsecTunnelState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_null_cipher: Optional[pulumi.Input[bool]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[str]] = None,
                 customer_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn_id: Optional[pulumi.Input[str]] = None,
                 health_check_direction: Optional[pulumi.Input[str]] = None,
                 health_check_enabled: Optional[pulumi.Input[bool]] = None,
                 health_check_rate: Optional[pulumi.Input[str]] = None,
                 health_check_target: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 hex_id: Optional[pulumi.Input[str]] = None,
                 interface_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 psk: Optional[pulumi.Input[str]] = None,
                 remote_id: Optional[pulumi.Input[str]] = None,
                 replay_protection: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IpsecTunnel resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] allow_null_cipher: Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        :param pulumi.Input[str] cloudflare_endpoint: IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[str] customer_endpoint: IP address assigned to the customer side of the IPsec tunnel.
        :param pulumi.Input[str] description: An optional description of the IPsec tunnel.
        :param pulumi.Input[str] fqdn_id: `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        :param pulumi.Input[str] health_check_direction: Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        :param pulumi.Input[bool] health_check_enabled: Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        :param pulumi.Input[str] health_check_rate: Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        :param pulumi.Input[str] health_check_target: The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        :param pulumi.Input[str] health_check_type: Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        :param pulumi.Input[str] hex_id: `remote_id` as a hex string. This value is generated by cloudflare.
        :param pulumi.Input[str] interface_address: 31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        :param pulumi.Input[str] name: Name of the IPsec tunnel.
        :param pulumi.Input[str] psk: Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        :param pulumi.Input[str] remote_id: ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        :param pulumi.Input[bool] replay_protection: Specifies if replay protection is enabled. Defaults to `false`.
        :param pulumi.Input[str] user_id: `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_null_cipher is not None:
            pulumi.set(__self__, "allow_null_cipher", allow_null_cipher)
        if cloudflare_endpoint is not None:
            pulumi.set(__self__, "cloudflare_endpoint", cloudflare_endpoint)
        if customer_endpoint is not None:
            pulumi.set(__self__, "customer_endpoint", customer_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn_id is not None:
            pulumi.set(__self__, "fqdn_id", fqdn_id)
        if health_check_direction is not None:
            pulumi.set(__self__, "health_check_direction", health_check_direction)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_rate is not None:
            pulumi.set(__self__, "health_check_rate", health_check_rate)
        if health_check_target is not None:
            pulumi.set(__self__, "health_check_target", health_check_target)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if hex_id is not None:
            pulumi.set(__self__, "hex_id", hex_id)
        if interface_address is not None:
            pulumi.set(__self__, "interface_address", interface_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)
        if replay_protection is not None:
            pulumi.set(__self__, "replay_protection", replay_protection)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowNullCipher")
    def allow_null_cipher(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        """
        return pulumi.get(self, "allow_null_cipher")

    @allow_null_cipher.setter
    def allow_null_cipher(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_null_cipher", value)

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @cloudflare_endpoint.setter
    def cloudflare_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudflare_endpoint", value)

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        IP address assigned to the customer side of the IPsec tunnel.
        """
        return pulumi.get(self, "customer_endpoint")

    @customer_endpoint.setter
    def customer_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_endpoint", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fqdnId")
    def fqdn_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        """
        return pulumi.get(self, "fqdn_id")

    @fqdn_id.setter
    def fqdn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_id", value)

    @property
    @pulumi.getter(name="healthCheckDirection")
    def health_check_direction(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        """
        return pulumi.get(self, "health_check_direction")

    @health_check_direction.setter
    def health_check_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_direction", value)

    @property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        """
        return pulumi.get(self, "health_check_enabled")

    @health_check_enabled.setter
    def health_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "health_check_enabled", value)

    @property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        """
        return pulumi.get(self, "health_check_rate")

    @health_check_rate.setter
    def health_check_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_rate", value)

    @property
    @pulumi.getter(name="healthCheckTarget")
    def health_check_target(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        """
        return pulumi.get(self, "health_check_target")

    @health_check_target.setter
    def health_check_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_target", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="hexId")
    def hex_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` as a hex string. This value is generated by cloudflare.
        """
        return pulumi.get(self, "hex_id")

    @hex_id.setter
    def hex_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hex_id", value)

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> Optional[pulumi.Input[str]]:
        """
        31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IPsec tunnel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[str]]:
        """
        Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_id", value)

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if replay protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "replay_protection")

    @replay_protection.setter
    def replay_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replay_protection", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class IpsecTunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_null_cipher: Optional[pulumi.Input[bool]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[str]] = None,
                 customer_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn_id: Optional[pulumi.Input[str]] = None,
                 health_check_direction: Optional[pulumi.Input[str]] = None,
                 health_check_enabled: Optional[pulumi.Input[bool]] = None,
                 health_check_rate: Optional[pulumi.Input[str]] = None,
                 health_check_target: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 hex_id: Optional[pulumi.Input[str]] = None,
                 interface_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 psk: Optional[pulumi.Input[str]] = None,
                 remote_id: Optional[pulumi.Input[str]] = None,
                 replay_protection: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource, that manages IPsec tunnels for Magic Transit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.IpsecTunnel("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="IPsec_1",
            customer_endpoint="203.0.113.1",
            cloudflare_endpoint="203.0.113.1",
            interface_address="192.0.2.0/31",
            description="Tunnel for ISP X",
            health_check_enabled=True,
            health_check_target="203.0.113.1",
            health_check_type="reply",
            psk="asdf12341234",
            allow_null_cipher=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/ipsecTunnel:IpsecTunnel example <account_id>/<tunnel_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] allow_null_cipher: Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        :param pulumi.Input[str] cloudflare_endpoint: IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[str] customer_endpoint: IP address assigned to the customer side of the IPsec tunnel.
        :param pulumi.Input[str] description: An optional description of the IPsec tunnel.
        :param pulumi.Input[str] fqdn_id: `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        :param pulumi.Input[str] health_check_direction: Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        :param pulumi.Input[bool] health_check_enabled: Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        :param pulumi.Input[str] health_check_rate: Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        :param pulumi.Input[str] health_check_target: The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        :param pulumi.Input[str] health_check_type: Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        :param pulumi.Input[str] hex_id: `remote_id` as a hex string. This value is generated by cloudflare.
        :param pulumi.Input[str] interface_address: 31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        :param pulumi.Input[str] name: Name of the IPsec tunnel.
        :param pulumi.Input[str] psk: Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        :param pulumi.Input[str] remote_id: ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        :param pulumi.Input[bool] replay_protection: Specifies if replay protection is enabled. Defaults to `false`.
        :param pulumi.Input[str] user_id: `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsecTunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource, that manages IPsec tunnels for Magic Transit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.IpsecTunnel("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="IPsec_1",
            customer_endpoint="203.0.113.1",
            cloudflare_endpoint="203.0.113.1",
            interface_address="192.0.2.0/31",
            description="Tunnel for ISP X",
            health_check_enabled=True,
            health_check_target="203.0.113.1",
            health_check_type="reply",
            psk="asdf12341234",
            allow_null_cipher=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/ipsecTunnel:IpsecTunnel example <account_id>/<tunnel_id>
        ```

        :param str resource_name: The name of the resource.
        :param IpsecTunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsecTunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_null_cipher: Optional[pulumi.Input[bool]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[str]] = None,
                 customer_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn_id: Optional[pulumi.Input[str]] = None,
                 health_check_direction: Optional[pulumi.Input[str]] = None,
                 health_check_enabled: Optional[pulumi.Input[bool]] = None,
                 health_check_rate: Optional[pulumi.Input[str]] = None,
                 health_check_target: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 hex_id: Optional[pulumi.Input[str]] = None,
                 interface_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 psk: Optional[pulumi.Input[str]] = None,
                 remote_id: Optional[pulumi.Input[str]] = None,
                 replay_protection: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsecTunnelArgs.__new__(IpsecTunnelArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_null_cipher"] = allow_null_cipher
            if cloudflare_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'cloudflare_endpoint'")
            __props__.__dict__["cloudflare_endpoint"] = cloudflare_endpoint
            if customer_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'customer_endpoint'")
            __props__.__dict__["customer_endpoint"] = customer_endpoint
            __props__.__dict__["description"] = description
            __props__.__dict__["fqdn_id"] = fqdn_id
            __props__.__dict__["health_check_direction"] = health_check_direction
            __props__.__dict__["health_check_enabled"] = health_check_enabled
            __props__.__dict__["health_check_rate"] = health_check_rate
            __props__.__dict__["health_check_target"] = health_check_target
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["hex_id"] = hex_id
            if interface_address is None and not opts.urn:
                raise TypeError("Missing required property 'interface_address'")
            __props__.__dict__["interface_address"] = interface_address
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["psk"] = None if psk is None else pulumi.Output.secret(psk)
            __props__.__dict__["remote_id"] = remote_id
            __props__.__dict__["replay_protection"] = replay_protection
            __props__.__dict__["user_id"] = user_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["psk"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IpsecTunnel, __self__).__init__(
            'cloudflare:index/ipsecTunnel:IpsecTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            allow_null_cipher: Optional[pulumi.Input[bool]] = None,
            cloudflare_endpoint: Optional[pulumi.Input[str]] = None,
            customer_endpoint: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fqdn_id: Optional[pulumi.Input[str]] = None,
            health_check_direction: Optional[pulumi.Input[str]] = None,
            health_check_enabled: Optional[pulumi.Input[bool]] = None,
            health_check_rate: Optional[pulumi.Input[str]] = None,
            health_check_target: Optional[pulumi.Input[str]] = None,
            health_check_type: Optional[pulumi.Input[str]] = None,
            hex_id: Optional[pulumi.Input[str]] = None,
            interface_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            psk: Optional[pulumi.Input[str]] = None,
            remote_id: Optional[pulumi.Input[str]] = None,
            replay_protection: Optional[pulumi.Input[bool]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'IpsecTunnel':
        """
        Get an existing IpsecTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] allow_null_cipher: Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        :param pulumi.Input[str] cloudflare_endpoint: IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[str] customer_endpoint: IP address assigned to the customer side of the IPsec tunnel.
        :param pulumi.Input[str] description: An optional description of the IPsec tunnel.
        :param pulumi.Input[str] fqdn_id: `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        :param pulumi.Input[str] health_check_direction: Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        :param pulumi.Input[bool] health_check_enabled: Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        :param pulumi.Input[str] health_check_rate: Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        :param pulumi.Input[str] health_check_target: The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        :param pulumi.Input[str] health_check_type: Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        :param pulumi.Input[str] hex_id: `remote_id` as a hex string. This value is generated by cloudflare.
        :param pulumi.Input[str] interface_address: 31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        :param pulumi.Input[str] name: Name of the IPsec tunnel.
        :param pulumi.Input[str] psk: Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        :param pulumi.Input[str] remote_id: ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        :param pulumi.Input[bool] replay_protection: Specifies if replay protection is enabled. Defaults to `false`.
        :param pulumi.Input[str] user_id: `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsecTunnelState.__new__(_IpsecTunnelState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_null_cipher"] = allow_null_cipher
        __props__.__dict__["cloudflare_endpoint"] = cloudflare_endpoint
        __props__.__dict__["customer_endpoint"] = customer_endpoint
        __props__.__dict__["description"] = description
        __props__.__dict__["fqdn_id"] = fqdn_id
        __props__.__dict__["health_check_direction"] = health_check_direction
        __props__.__dict__["health_check_enabled"] = health_check_enabled
        __props__.__dict__["health_check_rate"] = health_check_rate
        __props__.__dict__["health_check_target"] = health_check_target
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["hex_id"] = hex_id
        __props__.__dict__["interface_address"] = interface_address
        __props__.__dict__["name"] = name
        __props__.__dict__["psk"] = psk
        __props__.__dict__["remote_id"] = remote_id
        __props__.__dict__["replay_protection"] = replay_protection
        __props__.__dict__["user_id"] = user_id
        return IpsecTunnel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowNullCipher")
    def allow_null_cipher(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if this tunnel may use a null cipher (ENCR_NULL) in Phase 2. Defaults to `false`.
        """
        return pulumi.get(self, "allow_null_cipher")

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> pulumi.Output[str]:
        """
        IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> pulumi.Output[str]:
        """
        IP address assigned to the customer side of the IPsec tunnel.
        """
        return pulumi.get(self, "customer_endpoint")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fqdnId")
    def fqdn_id(self) -> pulumi.Output[str]:
        """
        `remote_id` in the form of a fqdn. This value is generated by cloudflare.
        """
        return pulumi.get(self, "fqdn_id")

    @property
    @pulumi.getter(name="healthCheckDirection")
    def health_check_direction(self) -> pulumi.Output[str]:
        """
        Specifies the direction for the health check. Available values: `unidirectional`, `bidirectional` Default: `unidirectional`.
        """
        return pulumi.get(self, "health_check_direction")

    @property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies if ICMP tunnel health checks are enabled. Default: `true`.
        """
        return pulumi.get(self, "health_check_enabled")

    @property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> pulumi.Output[str]:
        """
        Specifies the ICMP rate for the health check. Available values: `low`, `mid`, `high` Default: `mid`.
        """
        return pulumi.get(self, "health_check_rate")

    @property
    @pulumi.getter(name="healthCheckTarget")
    def health_check_target(self) -> pulumi.Output[str]:
        """
        The IP address of the customer endpoint that will receive tunnel health checks. Default: `<customer_gre_endpoint>`.
        """
        return pulumi.get(self, "health_check_target")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[str]:
        """
        Specifies the ICMP echo type for the health check (`request` or `reply`). Available values: `request`, `reply` Default: `reply`.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="hexId")
    def hex_id(self) -> pulumi.Output[str]:
        """
        `remote_id` as a hex string. This value is generated by cloudflare.
        """
        return pulumi.get(self, "hex_id")

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Output[str]:
        """
        31-bit prefix (/31 in CIDR notation) supporting 2 hosts, one for each side of the tunnel.
        """
        return pulumi.get(self, "interface_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the IPsec tunnel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def psk(self) -> pulumi.Output[str]:
        """
        Pre shared key to be used with the IPsec tunnel. If left unset, it will be autogenerated.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> pulumi.Output[str]:
        """
        ID to be used while setting up the IPsec tunnel. This value is generated by cloudflare.
        """
        return pulumi.get(self, "remote_id")

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if replay protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "replay_protection")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        `remote_id` in the form of an email address. This value is generated by cloudflare.
        """
        return pulumi.get(self, "user_id")

