# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerPoolArgs', 'LoadBalancerPool']

@pulumi.input_type
class LoadBalancerPoolArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 origins: pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]],
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 load_sheddings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 minimum_origins: Optional[pulumi.Input[int]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 origin_steerings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]] = None):
        """
        The set of arguments for constructing a LoadBalancerPool resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] name: A short name (tag) for the pool.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        :param pulumi.Input[float] latitude: The latitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]] load_sheddings: Setting for controlling load shedding for this pool.
        :param pulumi.Input[float] longitude: The longitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        :param pulumi.Input[str] monitor: The ID of the Monitor to use for health checking origins within this pool.
        :param pulumi.Input[str] notification_email: The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]] origin_steerings: Set an origin steering policy to control origin selection within a pool.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origins", origins)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if load_sheddings is not None:
            pulumi.set(__self__, "load_sheddings", load_sheddings)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if minimum_origins is not None:
            pulumi.set(__self__, "minimum_origins", minimum_origins)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if origin_steerings is not None:
            pulumi.set(__self__, "origin_steerings", origin_steerings)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A short name (tag) for the pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[float]]:
        """
        The latitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="loadSheddings")
    def load_sheddings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]]:
        """
        Setting for controlling load shedding for this pool.
        """
        return pulumi.get(self, "load_sheddings")

    @load_sheddings.setter
    def load_sheddings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]]):
        pulumi.set(self, "load_sheddings", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[float]]:
        """
        The longitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        """
        return pulumi.get(self, "minimum_origins")

    @minimum_origins.setter
    def minimum_origins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_origins", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Monitor to use for health checking origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_email", value)

    @property
    @pulumi.getter(name="originSteerings")
    def origin_steerings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]]:
        """
        Set an origin steering policy to control origin selection within a pool.
        """
        return pulumi.get(self, "origin_steerings")

    @origin_steerings.setter
    def origin_steerings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]]):
        pulumi.set(self, "origin_steerings", value)


@pulumi.input_type
class _LoadBalancerPoolState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 load_sheddings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 minimum_origins: Optional[pulumi.Input[int]] = None,
                 modified_on: Optional[pulumi.Input[str]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 origin_steerings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerPool resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer was created.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        :param pulumi.Input[float] latitude: The latitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]] load_sheddings: Setting for controlling load shedding for this pool.
        :param pulumi.Input[float] longitude: The longitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer was last modified.
        :param pulumi.Input[str] monitor: The ID of the Monitor to use for health checking origins within this pool.
        :param pulumi.Input[str] name: A short name (tag) for the pool.
        :param pulumi.Input[str] notification_email: The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]] origin_steerings: Set an origin steering policy to control origin selection within a pool.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if load_sheddings is not None:
            pulumi.set(__self__, "load_sheddings", load_sheddings)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if minimum_origins is not None:
            pulumi.set(__self__, "minimum_origins", minimum_origins)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if origin_steerings is not None:
            pulumi.set(__self__, "origin_steerings", origin_steerings)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[float]]:
        """
        The latitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="loadSheddings")
    def load_sheddings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]]:
        """
        Setting for controlling load shedding for this pool.
        """
        return pulumi.get(self, "load_sheddings")

    @load_sheddings.setter
    def load_sheddings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]]]):
        pulumi.set(self, "load_sheddings", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[float]]:
        """
        The longitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        """
        return pulumi.get(self, "minimum_origins")

    @minimum_origins.setter
    def minimum_origins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_origins", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Monitor to use for health checking origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A short name (tag) for the pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_email", value)

    @property
    @pulumi.getter(name="originSteerings")
    def origin_steerings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]]:
        """
        Set an origin steering policy to control origin selection within a pool.
        """
        return pulumi.get(self, "origin_steerings")

    @origin_steerings.setter
    def origin_steerings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]]]):
        pulumi.set(self, "origin_steerings", value)

    @property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]]):
        pulumi.set(self, "origins", value)


class LoadBalancerPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 load_sheddings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolLoadSheddingArgs']]]]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 minimum_origins: Optional[pulumi.Input[int]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 origin_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginSteeringArgs']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginArgs']]]]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Load Balancer pool resource. This provides a
        pool of origins that can be used by a Cloudflare Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.LoadBalancerPool("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="example-pool",
            origins=[
                cloudflare.LoadBalancerPoolOriginArgs(
                    name="example-1",
                    address="192.0.2.1",
                    enabled=False,
                    headers=[cloudflare.LoadBalancerPoolOriginHeaderArgs(
                        header="Host",
                        values=["example-1"],
                    )],
                ),
                cloudflare.LoadBalancerPoolOriginArgs(
                    name="example-2",
                    address="192.0.2.2",
                    headers=[cloudflare.LoadBalancerPoolOriginHeaderArgs(
                        header="Host",
                        values=["example-2"],
                    )],
                ),
            ],
            latitude=55,
            longitude=-12,
            description="example load balancer pool",
            enabled=False,
            minimum_origins=1,
            notification_email="someone@example.com",
            load_sheddings=[cloudflare.LoadBalancerPoolLoadSheddingArgs(
                default_percent=55,
                default_policy="random",
                session_percent=12,
                session_policy="hash",
            )],
            origin_steerings=[cloudflare.LoadBalancerPoolOriginSteeringArgs(
                policy="random",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerPool:LoadBalancerPool example <account_id>/<load_balancer_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        :param pulumi.Input[float] latitude: The latitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolLoadSheddingArgs']]]] load_sheddings: Setting for controlling load shedding for this pool.
        :param pulumi.Input[float] longitude: The longitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        :param pulumi.Input[str] monitor: The ID of the Monitor to use for health checking origins within this pool.
        :param pulumi.Input[str] name: A short name (tag) for the pool.
        :param pulumi.Input[str] notification_email: The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginSteeringArgs']]]] origin_steerings: Set an origin steering policy to control origin selection within a pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginArgs']]]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Load Balancer pool resource. This provides a
        pool of origins that can be used by a Cloudflare Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.LoadBalancerPool("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="example-pool",
            origins=[
                cloudflare.LoadBalancerPoolOriginArgs(
                    name="example-1",
                    address="192.0.2.1",
                    enabled=False,
                    headers=[cloudflare.LoadBalancerPoolOriginHeaderArgs(
                        header="Host",
                        values=["example-1"],
                    )],
                ),
                cloudflare.LoadBalancerPoolOriginArgs(
                    name="example-2",
                    address="192.0.2.2",
                    headers=[cloudflare.LoadBalancerPoolOriginHeaderArgs(
                        header="Host",
                        values=["example-2"],
                    )],
                ),
            ],
            latitude=55,
            longitude=-12,
            description="example load balancer pool",
            enabled=False,
            minimum_origins=1,
            notification_email="someone@example.com",
            load_sheddings=[cloudflare.LoadBalancerPoolLoadSheddingArgs(
                default_percent=55,
                default_policy="random",
                session_percent=12,
                session_policy="hash",
            )],
            origin_steerings=[cloudflare.LoadBalancerPoolOriginSteeringArgs(
                policy="random",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerPool:LoadBalancerPool example <account_id>/<load_balancer_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 load_sheddings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolLoadSheddingArgs']]]]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 minimum_origins: Optional[pulumi.Input[int]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 origin_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginSteeringArgs']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerPoolArgs.__new__(LoadBalancerPoolArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["check_regions"] = check_regions
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["latitude"] = latitude
            __props__.__dict__["load_sheddings"] = load_sheddings
            __props__.__dict__["longitude"] = longitude
            __props__.__dict__["minimum_origins"] = minimum_origins
            __props__.__dict__["monitor"] = monitor
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_email"] = notification_email
            __props__.__dict__["origin_steerings"] = origin_steerings
            if origins is None and not opts.urn:
                raise TypeError("Missing required property 'origins'")
            __props__.__dict__["origins"] = origins
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(LoadBalancerPool, __self__).__init__(
            'cloudflare:index/loadBalancerPool:LoadBalancerPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            latitude: Optional[pulumi.Input[float]] = None,
            load_sheddings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolLoadSheddingArgs']]]]] = None,
            longitude: Optional[pulumi.Input[float]] = None,
            minimum_origins: Optional[pulumi.Input[int]] = None,
            modified_on: Optional[pulumi.Input[str]] = None,
            monitor: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_email: Optional[pulumi.Input[str]] = None,
            origin_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginSteeringArgs']]]]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginArgs']]]]] = None) -> 'LoadBalancerPool':
        """
        Get an existing LoadBalancerPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] check_regions: A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer was created.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        :param pulumi.Input[float] latitude: The latitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolLoadSheddingArgs']]]] load_sheddings: Setting for controlling load shedding for this pool.
        :param pulumi.Input[float] longitude: The longitude this pool is physically located at; used for proximity steering.
        :param pulumi.Input[int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer was last modified.
        :param pulumi.Input[str] monitor: The ID of the Monitor to use for health checking origins within this pool.
        :param pulumi.Input[str] name: A short name (tag) for the pool.
        :param pulumi.Input[str] notification_email: The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginSteeringArgs']]]] origin_steerings: Set an origin steering policy to control origin selection within a pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerPoolOriginArgs']]]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerPoolState.__new__(_LoadBalancerPoolState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["check_regions"] = check_regions
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["latitude"] = latitude
        __props__.__dict__["load_sheddings"] = load_sheddings
        __props__.__dict__["longitude"] = longitude
        __props__.__dict__["minimum_origins"] = minimum_origins
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_email"] = notification_email
        __props__.__dict__["origin_steerings"] = origin_steerings
        __props__.__dict__["origins"] = origins
        return LoadBalancerPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of regions (specified by region code) from which to run health checks. Empty means every Cloudflare data center (the default), but requires an Enterprise plan. Region codes can be found [here](https://developers.cloudflare.com/load-balancing/reference/region-mapping-api).
        """
        return pulumi.get(self, "check_regions")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable (the default) this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Output[Optional[float]]:
        """
        The latitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter(name="loadSheddings")
    def load_sheddings(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerPoolLoadShedding']]]:
        """
        Setting for controlling load shedding for this pool.
        """
        return pulumi.get(self, "load_sheddings")

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Output[Optional[float]]:
        """
        The longitude this pool is physically located at; used for proximity steering.
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and we will failover to the next available pool. Defaults to `1`.
        """
        return pulumi.get(self, "minimum_origins")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Monitor to use for health checking origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A short name (tag) for the pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Output[Optional[str]]:
        """
        The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @property
    @pulumi.getter(name="originSteerings")
    def origin_steerings(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerPoolOriginSteering']]]:
        """
        Set an origin steering policy to control origin selection within a pool.
        """
        return pulumi.get(self, "origin_steerings")

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Sequence['outputs.LoadBalancerPoolOrigin']]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

