# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RateLimitArgs', 'RateLimit']

@pulumi.input_type
class RateLimitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RateLimitActionArgs'],
                 period: pulumi.Input[int],
                 threshold: pulumi.Input[int],
                 zone_id: pulumi.Input[str],
                 bypass_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 correlate: Optional[pulumi.Input['RateLimitCorrelateArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input['RateLimitMatchArgs']] = None):
        """
        The set of arguments for constructing a RateLimit resource.
        :param pulumi.Input['RateLimitActionArgs'] action: The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        :param pulumi.Input[int] period: The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        :param pulumi.Input[int] threshold: The threshold that triggers the rate limit mitigations, combine with period.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input['RateLimitCorrelateArgs'] correlate: Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        :param pulumi.Input[str] description: A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        :param pulumi.Input[bool] disabled: Whether this ratelimit is currently disabled. Defaults to `false`.
        :param pulumi.Input['RateLimitMatchArgs'] match: Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "zone_id", zone_id)
        if bypass_url_patterns is not None:
            pulumi.set(__self__, "bypass_url_patterns", bypass_url_patterns)
        if correlate is not None:
            pulumi.set(__self__, "correlate", correlate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if match is not None:
            pulumi.set(__self__, "match", match)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RateLimitActionArgs']:
        """
        The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RateLimitActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[int]:
        """
        The threshold that triggers the rate limit mitigations, combine with period.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="bypassUrlPatterns")
    def bypass_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "bypass_url_patterns")

    @bypass_url_patterns.setter
    def bypass_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bypass_url_patterns", value)

    @property
    @pulumi.getter
    def correlate(self) -> Optional[pulumi.Input['RateLimitCorrelateArgs']]:
        """
        Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        """
        return pulumi.get(self, "correlate")

    @correlate.setter
    def correlate(self, value: Optional[pulumi.Input['RateLimitCorrelateArgs']]):
        pulumi.set(self, "correlate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this ratelimit is currently disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RateLimitMatchArgs']]:
        """
        Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RateLimitMatchArgs']]):
        pulumi.set(self, "match", value)


@pulumi.input_type
class _RateLimitState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['RateLimitActionArgs']] = None,
                 bypass_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 correlate: Optional[pulumi.Input['RateLimitCorrelateArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input['RateLimitMatchArgs']] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RateLimit resources.
        :param pulumi.Input['RateLimitActionArgs'] action: The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        :param pulumi.Input['RateLimitCorrelateArgs'] correlate: Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        :param pulumi.Input[str] description: A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        :param pulumi.Input[bool] disabled: Whether this ratelimit is currently disabled. Defaults to `false`.
        :param pulumi.Input['RateLimitMatchArgs'] match: Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        :param pulumi.Input[int] period: The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        :param pulumi.Input[int] threshold: The threshold that triggers the rate limit mitigations, combine with period.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_url_patterns is not None:
            pulumi.set(__self__, "bypass_url_patterns", bypass_url_patterns)
        if correlate is not None:
            pulumi.set(__self__, "correlate", correlate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['RateLimitActionArgs']]:
        """
        The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['RateLimitActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="bypassUrlPatterns")
    def bypass_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "bypass_url_patterns")

    @bypass_url_patterns.setter
    def bypass_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bypass_url_patterns", value)

    @property
    @pulumi.getter
    def correlate(self) -> Optional[pulumi.Input['RateLimitCorrelateArgs']]:
        """
        Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        """
        return pulumi.get(self, "correlate")

    @correlate.setter
    def correlate(self, value: Optional[pulumi.Input['RateLimitCorrelateArgs']]):
        pulumi.set(self, "correlate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this ratelimit is currently disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RateLimitMatchArgs']]:
        """
        Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RateLimitMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The threshold that triggers the rate limit mitigations, combine with period.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class RateLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[pulumi.InputType['RateLimitActionArgs']]] = None,
                 bypass_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 correlate: Optional[pulumi.Input[pulumi.InputType['RateLimitCorrelateArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[pulumi.InputType['RateLimitMatchArgs']]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare rate limit resource for a given zone. This can
        be used to limit the traffic you receive zone-wide, or matching more
        specific types of requests/responses.

        > `RateLimit` is in a deprecation phase that will last for 14
          months (July 1st, 2024). During this time period, this resource is still
          fully supported but you are strongly advised to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.RateLimit("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            threshold=2000,
            period=2,
            match=cloudflare.RateLimitMatchArgs(
                request=cloudflare.RateLimitMatchRequestArgs(
                    url_pattern=f"{cloudflare_zone}/*",
                    schemes=[
                        "HTTP",
                        "HTTPS",
                    ],
                    methods=[
                        "GET",
                        "POST",
                        "PUT",
                        "DELETE",
                        "PATCH",
                        "HEAD",
                    ],
                ),
                response=cloudflare.RateLimitMatchResponseArgs(
                    statuses=[
                        200,
                        201,
                        202,
                        301,
                        429,
                    ],
                    origin_traffic=False,
                    headers=[
                        {
                            "name": "Host",
                            "op": "eq",
                            "value": "localhost",
                        },
                        {
                            "name": "X-Example",
                            "op": "ne",
                            "value": "my-example",
                        },
                    ],
                ),
            ),
            action=cloudflare.RateLimitActionArgs(
                mode="simulate",
                timeout=43200,
                response=cloudflare.RateLimitActionResponseArgs(
                    content_type="text/plain",
                    body="custom response body",
                ),
            ),
            correlate=cloudflare.RateLimitCorrelateArgs(
                by="nat",
            ),
            disabled=False,
            description="example rate limit for a zone",
            bypass_url_patterns=[
                "example.com/bypass1",
                "example.com/bypass2",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/rateLimit:RateLimit example <zone_id>/<rate_limit_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RateLimitActionArgs']] action: The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        :param pulumi.Input[pulumi.InputType['RateLimitCorrelateArgs']] correlate: Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        :param pulumi.Input[str] description: A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        :param pulumi.Input[bool] disabled: Whether this ratelimit is currently disabled. Defaults to `false`.
        :param pulumi.Input[pulumi.InputType['RateLimitMatchArgs']] match: Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        :param pulumi.Input[int] period: The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        :param pulumi.Input[int] threshold: The threshold that triggers the rate limit mitigations, combine with period.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RateLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare rate limit resource for a given zone. This can
        be used to limit the traffic you receive zone-wide, or matching more
        specific types of requests/responses.

        > `RateLimit` is in a deprecation phase that will last for 14
          months (July 1st, 2024). During this time period, this resource is still
          fully supported but you are strongly advised to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.RateLimit("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            threshold=2000,
            period=2,
            match=cloudflare.RateLimitMatchArgs(
                request=cloudflare.RateLimitMatchRequestArgs(
                    url_pattern=f"{cloudflare_zone}/*",
                    schemes=[
                        "HTTP",
                        "HTTPS",
                    ],
                    methods=[
                        "GET",
                        "POST",
                        "PUT",
                        "DELETE",
                        "PATCH",
                        "HEAD",
                    ],
                ),
                response=cloudflare.RateLimitMatchResponseArgs(
                    statuses=[
                        200,
                        201,
                        202,
                        301,
                        429,
                    ],
                    origin_traffic=False,
                    headers=[
                        {
                            "name": "Host",
                            "op": "eq",
                            "value": "localhost",
                        },
                        {
                            "name": "X-Example",
                            "op": "ne",
                            "value": "my-example",
                        },
                    ],
                ),
            ),
            action=cloudflare.RateLimitActionArgs(
                mode="simulate",
                timeout=43200,
                response=cloudflare.RateLimitActionResponseArgs(
                    content_type="text/plain",
                    body="custom response body",
                ),
            ),
            correlate=cloudflare.RateLimitCorrelateArgs(
                by="nat",
            ),
            disabled=False,
            description="example rate limit for a zone",
            bypass_url_patterns=[
                "example.com/bypass1",
                "example.com/bypass2",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/rateLimit:RateLimit example <zone_id>/<rate_limit_id>
        ```

        :param str resource_name: The name of the resource.
        :param RateLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RateLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[pulumi.InputType['RateLimitActionArgs']]] = None,
                 bypass_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 correlate: Optional[pulumi.Input[pulumi.InputType['RateLimitCorrelateArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[pulumi.InputType['RateLimitMatchArgs']]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RateLimitArgs.__new__(RateLimitArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["bypass_url_patterns"] = bypass_url_patterns
            __props__.__dict__["correlate"] = correlate
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["match"] = match
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(RateLimit, __self__).__init__(
            'cloudflare:index/rateLimit:RateLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[pulumi.InputType['RateLimitActionArgs']]] = None,
            bypass_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            correlate: Optional[pulumi.Input[pulumi.InputType['RateLimitCorrelateArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            match: Optional[pulumi.Input[pulumi.InputType['RateLimitMatchArgs']]] = None,
            period: Optional[pulumi.Input[int]] = None,
            threshold: Optional[pulumi.Input[int]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'RateLimit':
        """
        Get an existing RateLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RateLimitActionArgs']] action: The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        :param pulumi.Input[pulumi.InputType['RateLimitCorrelateArgs']] correlate: Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        :param pulumi.Input[str] description: A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        :param pulumi.Input[bool] disabled: Whether this ratelimit is currently disabled. Defaults to `false`.
        :param pulumi.Input[pulumi.InputType['RateLimitMatchArgs']] match: Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        :param pulumi.Input[int] period: The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        :param pulumi.Input[int] threshold: The threshold that triggers the rate limit mitigations, combine with period.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RateLimitState.__new__(_RateLimitState)

        __props__.__dict__["action"] = action
        __props__.__dict__["bypass_url_patterns"] = bypass_url_patterns
        __props__.__dict__["correlate"] = correlate
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["match"] = match
        __props__.__dict__["period"] = period
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["zone_id"] = zone_id
        return RateLimit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.RateLimitAction']:
        """
        The action to be performed when the threshold of matched traffic within the period defined is exceeded.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="bypassUrlPatterns")
    def bypass_url_patterns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "bypass_url_patterns")

    @property
    @pulumi.getter
    def correlate(self) -> pulumi.Output[Optional['outputs.RateLimitCorrelate']]:
        """
        Determines how rate limiting is applied. By default if not specified, rate limiting applies to the clients IP address.
        """
        return pulumi.get(self, "correlate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A note that you can use to describe the reason for a rate limit. This value is sanitized and all tags are removed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this ratelimit is currently disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output['outputs.RateLimitMatch']:
        """
        Determines which traffic the rate limit counts towards the threshold. By default matches all traffic in the zone.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        The time in seconds to count matching traffic. If the count exceeds threshold within this period the action will be performed.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[int]:
        """
        The threshold that triggers the rate limit mitigations, combine with period.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

