# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['WaitingRoomEventArgs', 'WaitingRoomEvent']

@pulumi.input_type
class WaitingRoomEventArgs:
    def __init__(__self__, *,
                 event_end_time: pulumi.Input[str],
                 event_start_time: pulumi.Input[str],
                 name: pulumi.Input[str],
                 waiting_room_id: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[str]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[bool]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a WaitingRoomEvent resource.
        :param pulumi.Input[str] event_end_time: ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] event_start_time: ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] name: A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] waiting_room_id: The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] description: A description to let users add more details about the event.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] prequeue_start_time: ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        :param pulumi.Input[bool] shuffle_at_event_start: Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        :param pulumi.Input[bool] suspended: If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        """
        pulumi.set(__self__, "event_end_time", event_end_time)
        pulumi.set(__self__, "event_start_time", event_start_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if prequeue_start_time is not None:
            pulumi.set(__self__, "prequeue_start_time", prequeue_start_time)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if shuffle_at_event_start is not None:
            pulumi.set(__self__, "shuffle_at_event_start", shuffle_at_event_start)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> pulumi.Input[str]:
        """
        ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_end_time")

    @event_end_time.setter
    def event_end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_end_time", value)

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> pulumi.Input[str]:
        """
        ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_start_time")

    @event_start_time.setter
    def event_start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_start_time", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Input[str]:
        """
        The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "waiting_room_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description to let users add more details about the event.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @prequeue_start_time.setter
    def prequeue_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prequeue_start_time", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @shuffle_at_event_start.setter
    def shuffle_at_event_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shuffle_at_event_start", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_active_users", value)


@pulumi.input_type
class _WaitingRoomEventState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[str]] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 event_end_time: Optional[pulumi.Input[str]] = None,
                 event_start_time: Optional[pulumi.Input[str]] = None,
                 modified_on: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[str]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[bool]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 waiting_room_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoomEvent resources.
        :param pulumi.Input[str] created_on: Creation time.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] description: A description to let users add more details about the event.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[str] event_end_time: ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] event_start_time: ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] modified_on: Last modified time.
        :param pulumi.Input[str] name: A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] prequeue_start_time: ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        :param pulumi.Input[bool] shuffle_at_event_start: Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        :param pulumi.Input[bool] suspended: If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] waiting_room_id: The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if event_end_time is not None:
            pulumi.set(__self__, "event_end_time", event_end_time)
        if event_start_time is not None:
            pulumi.set(__self__, "event_start_time", event_start_time)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if prequeue_start_time is not None:
            pulumi.set(__self__, "prequeue_start_time", prequeue_start_time)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if shuffle_at_event_start is not None:
            pulumi.set(__self__, "shuffle_at_event_start", shuffle_at_event_start)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if waiting_room_id is not None:
            pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description to let users add more details about the event.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_end_time")

    @event_end_time.setter
    def event_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_end_time", value)

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_start_time")

    @event_start_time.setter
    def event_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_start_time", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[str]]:
        """
        Last modified time.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @prequeue_start_time.setter
    def prequeue_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prequeue_start_time", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @shuffle_at_event_start.setter
    def shuffle_at_event_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shuffle_at_event_start", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_active_users", value)

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waiting_room_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class WaitingRoomEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 event_end_time: Optional[pulumi.Input[str]] = None,
                 event_start_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[str]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[bool]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 waiting_room_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Waiting Room Event resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Waiting Room Event
        example = cloudflare.WaitingRoomEvent("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            waiting_room_id="d41d8cd98f00b204e9800998ecf8427e",
            name="foo",
            event_start_time="2006-01-02T15:04:05Z",
            event_end_time="2006-01-02T20:04:05Z")
        ```

        ## Import

        Use the Zone ID, Waiting Room ID, and Event ID to import.

        ```sh
        $ pulumi import cloudflare:index/waitingRoomEvent:WaitingRoomEvent default <zone_id>/<waiting_room_id>/<waiting_room_event_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] description: A description to let users add more details about the event.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[str] event_end_time: ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] event_start_time: ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] name: A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] prequeue_start_time: ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        :param pulumi.Input[bool] shuffle_at_event_start: Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        :param pulumi.Input[bool] suspended: If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] waiting_room_id: The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Waiting Room Event resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Waiting Room Event
        example = cloudflare.WaitingRoomEvent("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            waiting_room_id="d41d8cd98f00b204e9800998ecf8427e",
            name="foo",
            event_start_time="2006-01-02T15:04:05Z",
            event_end_time="2006-01-02T20:04:05Z")
        ```

        ## Import

        Use the Zone ID, Waiting Room ID, and Event ID to import.

        ```sh
        $ pulumi import cloudflare:index/waitingRoomEvent:WaitingRoomEvent default <zone_id>/<waiting_room_id>/<waiting_room_event_id>
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 event_end_time: Optional[pulumi.Input[str]] = None,
                 event_start_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[str]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[bool]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 waiting_room_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomEventArgs.__new__(WaitingRoomEventArgs)

            __props__.__dict__["custom_page_html"] = custom_page_html
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_session_renewal"] = disable_session_renewal
            if event_end_time is None and not opts.urn:
                raise TypeError("Missing required property 'event_end_time'")
            __props__.__dict__["event_end_time"] = event_end_time
            if event_start_time is None and not opts.urn:
                raise TypeError("Missing required property 'event_start_time'")
            __props__.__dict__["event_start_time"] = event_start_time
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["new_users_per_minute"] = new_users_per_minute
            __props__.__dict__["prequeue_start_time"] = prequeue_start_time
            __props__.__dict__["queueing_method"] = queueing_method
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["shuffle_at_event_start"] = shuffle_at_event_start
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["total_active_users"] = total_active_users
            if waiting_room_id is None and not opts.urn:
                raise TypeError("Missing required property 'waiting_room_id'")
            __props__.__dict__["waiting_room_id"] = waiting_room_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(WaitingRoomEvent, __self__).__init__(
            'cloudflare:index/waitingRoomEvent:WaitingRoomEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            custom_page_html: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_session_renewal: Optional[pulumi.Input[bool]] = None,
            event_end_time: Optional[pulumi.Input[str]] = None,
            event_start_time: Optional[pulumi.Input[str]] = None,
            modified_on: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_users_per_minute: Optional[pulumi.Input[int]] = None,
            prequeue_start_time: Optional[pulumi.Input[str]] = None,
            queueing_method: Optional[pulumi.Input[str]] = None,
            session_duration: Optional[pulumi.Input[int]] = None,
            shuffle_at_event_start: Optional[pulumi.Input[bool]] = None,
            suspended: Optional[pulumi.Input[bool]] = None,
            total_active_users: Optional[pulumi.Input[int]] = None,
            waiting_room_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'WaitingRoomEvent':
        """
        Get an existing WaitingRoomEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_on: Creation time.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] description: A description to let users add more details about the event.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[str] event_end_time: ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] event_start_time: ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] modified_on: Last modified time.
        :param pulumi.Input[str] name: A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] prequeue_start_time: ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        :param pulumi.Input[bool] shuffle_at_event_start: Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        :param pulumi.Input[bool] suspended: If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] waiting_room_id: The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomEventState.__new__(_WaitingRoomEventState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["custom_page_html"] = custom_page_html
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_session_renewal"] = disable_session_renewal
        __props__.__dict__["event_end_time"] = event_end_time
        __props__.__dict__["event_start_time"] = event_start_time
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["new_users_per_minute"] = new_users_per_minute
        __props__.__dict__["prequeue_start_time"] = prequeue_start_time
        __props__.__dict__["queueing_method"] = queueing_method
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["shuffle_at_event_start"] = shuffle_at_event_start
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["total_active_users"] = total_active_users
        __props__.__dict__["waiting_room_id"] = waiting_room_id
        __props__.__dict__["zone_id"] = zone_id
        return WaitingRoomEvent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> pulumi.Output[Optional[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description to let users add more details about the event.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> pulumi.Output[str]:
        """
        ISO 8601 timestamp that marks the end of the event. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_end_time")

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> pulumi.Output[str]:
        """
        ISO 8601 timestamp that marks the start of the event. Must occur at least 1 minute before `event_end_time`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "event_start_time")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[str]:
        """
        Last modified time.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens, and underscores are allowed. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Output[Optional[int]]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> pulumi.Output[Optional[str]]:
        """
        ISO 8601 timestamp that marks when to begin queueing all users before the event starts. Must occur at least 5 minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> pulumi.Output[Optional[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`.
        """
        return pulumi.get(self, "queueing_method")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> pulumi.Output[Optional[bool]]:
        """
        Users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. Defaults to `false`.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[bool]]:
        """
        If suspended, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Output[Optional[int]]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Output[str]:
        """
        The Waiting Room ID the event should apply to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "waiting_room_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

