# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['WebAnalyticsSiteArgs', 'WebAnalyticsSite']

@pulumi.input_type
class WebAnalyticsSiteArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 auto_install: pulumi.Input[bool],
                 host: Optional[pulumi.Input[str]] = None,
                 zone_tag: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WebAnalyticsSite resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] auto_install: Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] host: The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_tag: The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "auto_install", auto_install)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if zone_tag is not None:
            pulumi.set(__self__, "zone_tag", zone_tag)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="autoInstall")
    def auto_install(self) -> pulumi.Input[bool]:
        """
        Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "auto_install")

    @auto_install.setter
    def auto_install(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_install", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_tag")

    @zone_tag.setter
    def zone_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_tag", value)


@pulumi.input_type
class _WebAnalyticsSiteState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_install: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 ruleset_id: Optional[pulumi.Input[str]] = None,
                 site_tag: Optional[pulumi.Input[str]] = None,
                 site_token: Optional[pulumi.Input[str]] = None,
                 snippet: Optional[pulumi.Input[str]] = None,
                 zone_tag: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WebAnalyticsSite resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] auto_install: Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] host: The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] ruleset_id: The ID for the ruleset associated to this Web Analytics Site.
        :param pulumi.Input[str] site_tag: The Web Analytics site tag.
        :param pulumi.Input[str] site_token: The token for the Web Analytics site.
        :param pulumi.Input[str] snippet: The encoded JS snippet to add to your site's HTML page if auto_install is false.
        :param pulumi.Input[str] zone_tag: The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auto_install is not None:
            pulumi.set(__self__, "auto_install", auto_install)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ruleset_id is not None:
            pulumi.set(__self__, "ruleset_id", ruleset_id)
        if site_tag is not None:
            pulumi.set(__self__, "site_tag", site_tag)
        if site_token is not None:
            pulumi.set(__self__, "site_token", site_token)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if zone_tag is not None:
            pulumi.set(__self__, "zone_tag", zone_tag)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="autoInstall")
    def auto_install(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "auto_install")

    @auto_install.setter
    def auto_install(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_install", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the ruleset associated to this Web Analytics Site.
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ruleset_id", value)

    @property
    @pulumi.getter(name="siteTag")
    def site_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The Web Analytics site tag.
        """
        return pulumi.get(self, "site_tag")

    @site_tag.setter
    def site_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_tag", value)

    @property
    @pulumi.getter(name="siteToken")
    def site_token(self) -> Optional[pulumi.Input[str]]:
        """
        The token for the Web Analytics site.
        """
        return pulumi.get(self, "site_token")

    @site_token.setter
    def site_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_token", value)

    @property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[str]]:
        """
        The encoded JS snippet to add to your site's HTML page if auto_install is false.
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippet", value)

    @property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_tag")

    @zone_tag.setter
    def zone_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_tag", value)


class WebAnalyticsSite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_install: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 zone_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Web Analytics Site resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.WebAnalyticsSite("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            zone_tag="0da42c8d2132a9ddaf714f9e7c920711",
            auto_install=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/webAnalyticsSite:WebAnalyticsSite example <account_id>/<site_tag>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] auto_install: Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] host: The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] zone_tag: The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAnalyticsSiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Web Analytics Site resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.WebAnalyticsSite("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            zone_tag="0da42c8d2132a9ddaf714f9e7c920711",
            auto_install=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/webAnalyticsSite:WebAnalyticsSite example <account_id>/<site_tag>
        ```

        :param str resource_name: The name of the resource.
        :param WebAnalyticsSiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAnalyticsSiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_install: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 zone_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAnalyticsSiteArgs.__new__(WebAnalyticsSiteArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if auto_install is None and not opts.urn:
                raise TypeError("Missing required property 'auto_install'")
            __props__.__dict__["auto_install"] = auto_install
            __props__.__dict__["host"] = host
            __props__.__dict__["zone_tag"] = zone_tag
            __props__.__dict__["ruleset_id"] = None
            __props__.__dict__["site_tag"] = None
            __props__.__dict__["site_token"] = None
            __props__.__dict__["snippet"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["siteToken", "snippet"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WebAnalyticsSite, __self__).__init__(
            'cloudflare:index/webAnalyticsSite:WebAnalyticsSite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            auto_install: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            ruleset_id: Optional[pulumi.Input[str]] = None,
            site_tag: Optional[pulumi.Input[str]] = None,
            site_token: Optional[pulumi.Input[str]] = None,
            snippet: Optional[pulumi.Input[str]] = None,
            zone_tag: Optional[pulumi.Input[str]] = None) -> 'WebAnalyticsSite':
        """
        Get an existing WebAnalyticsSite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] auto_install: Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] host: The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[str] ruleset_id: The ID for the ruleset associated to this Web Analytics Site.
        :param pulumi.Input[str] site_tag: The Web Analytics site tag.
        :param pulumi.Input[str] site_token: The token for the Web Analytics site.
        :param pulumi.Input[str] snippet: The encoded JS snippet to add to your site's HTML page if auto_install is false.
        :param pulumi.Input[str] zone_tag: The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAnalyticsSiteState.__new__(_WebAnalyticsSiteState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["auto_install"] = auto_install
        __props__.__dict__["host"] = host
        __props__.__dict__["ruleset_id"] = ruleset_id
        __props__.__dict__["site_tag"] = site_tag
        __props__.__dict__["site_token"] = site_token
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["zone_tag"] = zone_tag
        return WebAnalyticsSite(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="autoInstall")
    def auto_install(self) -> pulumi.Output[bool]:
        """
        Whether Cloudflare will automatically inject the JavaScript snippet for orange-clouded sites. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "auto_install")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[str]]:
        """
        The hostname to use for gray-clouded sites. Must provide only one of `zone_tag`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> pulumi.Output[str]:
        """
        The ID for the ruleset associated to this Web Analytics Site.
        """
        return pulumi.get(self, "ruleset_id")

    @property
    @pulumi.getter(name="siteTag")
    def site_tag(self) -> pulumi.Output[str]:
        """
        The Web Analytics site tag.
        """
        return pulumi.get(self, "site_tag")

    @property
    @pulumi.getter(name="siteToken")
    def site_token(self) -> pulumi.Output[str]:
        """
        The token for the Web Analytics site.
        """
        return pulumi.get(self, "site_token")

    @property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[str]:
        """
        The encoded JS snippet to add to your site's HTML page if auto_install is false.
        """
        return pulumi.get(self, "snippet")

    @property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> pulumi.Output[Optional[str]]:
        """
        The zone identifier for orange-clouded sites. Must provide only one of `host`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_tag")

