"""Base Schemas

Revision ID: bc42c1e4cc1a
Revises: 
Create Date: 2022-06-06 08:56:29.835844

"""
from alembic import op
import sqlalchemy as sa
import geoalchemy2
from geoalchemy2 import Geometry

# revision identifiers, used by Alembic.
revision = 'bc42c1e4cc1a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.execute("CREATE EXTENSION IF NOT EXISTS postgis")
    # create placeholder reference annotation table target
    op.create_table('reference_table',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('bound_2tag',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.Column('pt2_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag2', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_2tag_created'), 'bound_2tag', ['created'], unique=False)
    op.create_index(op.f('ix_bound_2tag_deleted'), 'bound_2tag', ['deleted'], unique=False)
    op.create_table('bound_2tag_user',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.Column('pt2_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag2', sa.String(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_2tag_user_created'), 'bound_2tag_user', ['created'], unique=False)
    op.create_index(op.f('ix_bound_2tag_user_deleted'), 'bound_2tag_user', ['deleted'], unique=False)
    op.create_table('bound_tag',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_tag_created'), 'bound_tag', ['created'], unique=False)
    op.create_index(op.f('ix_bound_tag_deleted'), 'bound_tag', ['deleted'], unique=False)
    op.create_table('bound_tag_user',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_tag_user_created'), 'bound_tag_user', ['created'], unique=False)
    op.create_index(op.f('ix_bound_tag_user_deleted'), 'bound_tag_user', ['deleted'], unique=False)
    op.create_table('cell_type_local',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('classification_system', sa.String(), nullable=True),
    sa.Column('cell_type', sa.String(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cell_type_local_created'), 'cell_type_local', ['created'], unique=False)
    op.create_index(op.f('ix_cell_type_local_deleted'), 'cell_type_local', ['deleted'], unique=False)
    op.create_table('compartment_proofread_status',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('valid_id', sa.BigInteger(), nullable=True),
    sa.Column('status_dendrite', sa.String(), nullable=True),
    sa.Column('status_axon', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_compartment_proofread_status_created'), 'compartment_proofread_status', ['created'], unique=False)
    op.create_index(op.f('ix_compartment_proofread_status_deleted'), 'compartment_proofread_status', ['deleted'], unique=False)
    op.create_table('contact',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('size', sa.Integer(), nullable=True),
    sa.Column('sidea_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('sideb_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('ctr_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_contact_created'), 'contact', ['created'], unique=False)
    op.create_index(op.f('ix_contact_deleted'), 'contact', ['deleted'], unique=False)
    op.create_table('derived_numeric_value',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('pt_dependent_chunk', sa.BigInteger(), nullable=True),
    sa.Column('pt_level', sa.BigInteger(), nullable=True),
    sa.Column('value', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_numeric_value_created'), 'derived_numeric_value', ['created'], unique=False)
    op.create_index(op.f('ix_derived_numeric_value_deleted'), 'derived_numeric_value', ['deleted'], unique=False)
    op.create_table('derived_spatial_point',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('dependent_chunk', sa.BigInteger(), nullable=True),
    sa.Column('level', sa.BigInteger(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_spatial_point_created'), 'derived_spatial_point', ['created'], unique=False)
    op.create_index(op.f('ix_derived_spatial_point_deleted'), 'derived_spatial_point', ['deleted'], unique=False)
    op.create_table('derived_tag',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('pt_dependent_chunk', sa.BigInteger(), nullable=True),
    sa.Column('pt_level', sa.BigInteger(), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_tag_created'), 'derived_tag', ['created'], unique=False)
    op.create_index(op.f('ix_derived_tag_deleted'), 'derived_tag', ['deleted'], unique=False)
    op.create_table('extended_classical_cell_type',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('cell_type', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_extended_classical_cell_type_created'), 'extended_classical_cell_type', ['created'], unique=False)
    op.create_index(op.f('ix_extended_classical_cell_type_deleted'), 'extended_classical_cell_type', ['deleted'], unique=False)
    op.create_table('fly_nt_synapse',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pre_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('post_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('connection_score', sa.Float(), nullable=True),
    sa.Column('cleft_score', sa.Float(), nullable=True),
    sa.Column('gaba', sa.Float(), nullable=True),
    sa.Column('ach', sa.Float(), nullable=True),
    sa.Column('glut', sa.Float(), nullable=True),
    sa.Column('oct', sa.Float(), nullable=True),
    sa.Column('ser', sa.Float(), nullable=True),
    sa.Column('da', sa.Float(), nullable=True),
    sa.Column('valid_nt', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_fly_nt_synapse_created'), 'fly_nt_synapse', ['created'], unique=False)
    op.create_index(op.f('ix_fly_nt_synapse_deleted'), 'fly_nt_synapse', ['deleted'], unique=False)
    op.create_table('fly_synapse',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pre_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('post_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('connection_score', sa.Float(), nullable=True),
    sa.Column('cleft_score', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_fly_synapse_created'), 'fly_synapse', ['created'], unique=False)
    op.create_index(op.f('ix_fly_synapse_deleted'), 'fly_synapse', ['deleted'], unique=False)
    op.create_table('glia_contact',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('glia_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('object_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('size', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_glia_contact_created'), 'glia_contact', ['created'], unique=False)
    op.create_index(op.f('ix_glia_contact_deleted'), 'glia_contact', ['deleted'], unique=False)
    op.create_table('microns_func_coreg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('func_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_coreg_created'), 'microns_func_coreg', ['created'], unique=False)
    op.create_index(op.f('ix_microns_func_coreg_deleted'), 'microns_func_coreg', ['deleted'], unique=False)
    op.create_table('microns_func_unit_coreg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('session', sa.Integer(), nullable=True),
    sa.Column('scan_idx', sa.Integer(), nullable=True),
    sa.Column('unit_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_unit_coreg_created'), 'microns_func_unit_coreg', ['created'], unique=False)
    op.create_index(op.f('ix_microns_func_unit_coreg_deleted'), 'microns_func_unit_coreg', ['deleted'], unique=False)
    op.create_table('microns_func_unit_ext_coreg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('session', sa.Integer(), nullable=True),
    sa.Column('scan_idx', sa.Integer(), nullable=True),
    sa.Column('unit_id', sa.Integer(), nullable=True),
    sa.Column('nucleus_id', sa.Integer(), nullable=True),
    sa.Column('field', sa.Integer(), nullable=True),
    sa.Column('residual', sa.Float(), nullable=True),
    sa.Column('score', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_unit_ext_coreg_created'), 'microns_func_unit_ext_coreg', ['created'], unique=False)
    op.create_index(op.f('ix_microns_func_unit_ext_coreg_deleted'), 'microns_func_unit_ext_coreg', ['deleted'], unique=False)
    op.create_table('nocleft_synapse',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pre_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('post_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('score', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nocleft_synapse_created'), 'nocleft_synapse', ['created'], unique=False)
    op.create_index(op.f('ix_nocleft_synapse_deleted'), 'nocleft_synapse', ['deleted'], unique=False)
    op.create_table('nucleus_detection',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('volume', sa.Float(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('bb_start_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('bb_end_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nucleus_detection_created'), 'nucleus_detection', ['created'], unique=False)
    op.create_index(op.f('ix_nucleus_detection_deleted'), 'nucleus_detection', ['deleted'], unique=False)
    op.create_table('plastic_synapse',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pre_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('post_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('ctr_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('size', sa.Float(), nullable=True),
    sa.Column('plasticity', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_plastic_synapse_created'), 'plastic_synapse', ['created'], unique=False)
    op.create_index(op.f('ix_plastic_synapse_deleted'), 'plastic_synapse', ['deleted'], unique=False)
    op.create_table('proofread_status',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('valid_id', sa.BigInteger(), nullable=True),
    sa.Column('status', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_proofread_status_created'), 'proofread_status', ['created'], unique=False)
    op.create_index(op.f('ix_proofread_status_deleted'), 'proofread_status', ['deleted'], unique=False)
    op.create_table('proofreading_boolstatus_user',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('valid_id', sa.BigInteger(), nullable=True),
    sa.Column('proofread', sa.Boolean(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_proofreading_boolstatus_user_created'), 'proofreading_boolstatus_user', ['created'], unique=False)
    op.create_index(op.f('ix_proofreading_boolstatus_user_deleted'), 'proofreading_boolstatus_user', ['deleted'], unique=False)

    op.create_table('synapse',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('pre_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('post_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('ctr_pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.Column('size', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_synapse_created'), 'synapse', ['created'], unique=False)
    op.create_index(op.f('ix_synapse_deleted'), 'synapse', ['deleted'], unique=False)
    op.create_table('bound_2tag__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('pt2_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt2_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['bound_2tag.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_2tag__tests_pcg_pt2_root_id'), 'bound_2tag__tests_pcg', ['pt2_root_id'], unique=False)
    op.create_index(op.f('ix_bound_2tag__tests_pcg_pt_root_id'), 'bound_2tag__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('bound_2tag_user__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('pt2_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt2_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['bound_2tag_user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_2tag_user__tests_pcg_pt2_root_id'), 'bound_2tag_user__tests_pcg', ['pt2_root_id'], unique=False)
    op.create_index(op.f('ix_bound_2tag_user__tests_pcg_pt_root_id'), 'bound_2tag_user__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('bound_tag__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['bound_tag.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_tag__tests_pcg_pt_root_id'), 'bound_tag__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('bound_tag_user__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['bound_tag_user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bound_tag_user__tests_pcg_pt_root_id'), 'bound_tag_user__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('bouton_shape',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('shape', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_bouton_shape_created'), 'bouton_shape', ['created'], unique=False)
    op.create_index(op.f('ix_bouton_shape_deleted'), 'bouton_shape', ['deleted'], unique=False)
    op.create_index(op.f('ix_bouton_shape_target_id'), 'bouton_shape', ['target_id'], unique=False)
    op.create_table('cell_type_local__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['cell_type_local.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cell_type_local__tests_pcg_pt_root_id'), 'cell_type_local__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('cell_type_reference',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('classification_system', sa.String(), nullable=True),
    sa.Column('cell_type', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cell_type_reference_created'), 'cell_type_reference', ['created'], unique=False)
    op.create_index(op.f('ix_cell_type_reference_deleted'), 'cell_type_reference', ['deleted'], unique=False)
    op.create_index(op.f('ix_cell_type_reference_target_id'), 'cell_type_reference', ['target_id'], unique=False)
    op.create_table('compartment_proofread_status__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['compartment_proofread_status.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_compartment_proofread_status__tests_pcg_pt_root_id'), 'compartment_proofread_status__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('contact__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('sidea_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('sidea_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('sideb_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('sideb_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['contact.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_contact__tests_pcg_sidea_pt_root_id'), 'contact__tests_pcg', ['sidea_pt_root_id'], unique=False)
    op.create_index(op.f('ix_contact__tests_pcg_sideb_pt_root_id'), 'contact__tests_pcg', ['sideb_pt_root_id'], unique=False)
    op.create_table('derived_numeric_value__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['derived_numeric_value.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_numeric_value__tests_pcg_pt_root_id'), 'derived_numeric_value__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('derived_spatial_point__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['derived_spatial_point.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_spatial_point__tests_pcg_root_id'), 'derived_spatial_point__tests_pcg', ['root_id'], unique=False)
    op.create_table('derived_tag__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['derived_tag.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_derived_tag__tests_pcg_pt_root_id'), 'derived_tag__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('extended_classical_cell_type__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['extended_classical_cell_type.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_extended_classical_cell_type__tests_pcg_pt_root_id'), 'extended_classical_cell_type__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('fly_neuropil',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('neuropil', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_fly_neuropil_created'), 'fly_neuropil', ['created'], unique=False)
    op.create_index(op.f('ix_fly_neuropil_deleted'), 'fly_neuropil', ['deleted'], unique=False)
    op.create_index(op.f('ix_fly_neuropil_target_id'), 'fly_neuropil', ['target_id'], unique=False)
    op.create_table('fly_nt_synapse__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pre_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pre_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['fly_nt_synapse.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_fly_nt_synapse__tests_pcg_post_pt_root_id'), 'fly_nt_synapse__tests_pcg', ['post_pt_root_id'], unique=False)
    op.create_index(op.f('ix_fly_nt_synapse__tests_pcg_pre_pt_root_id'), 'fly_nt_synapse__tests_pcg', ['pre_pt_root_id'], unique=False)
    op.create_table('fly_synapse__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pre_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pre_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['fly_synapse.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_fly_synapse__tests_pcg_post_pt_root_id'), 'fly_synapse__tests_pcg', ['post_pt_root_id'], unique=False)
    op.create_index(op.f('ix_fly_synapse__tests_pcg_pre_pt_root_id'), 'fly_synapse__tests_pcg', ['pre_pt_root_id'], unique=False)
    op.create_table('glia_contact__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('glia_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('glia_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('object_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('object_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['glia_contact.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_glia_contact__tests_pcg_glia_pt_root_id'), 'glia_contact__tests_pcg', ['glia_pt_root_id'], unique=False)
    op.create_index(op.f('ix_glia_contact__tests_pcg_object_pt_root_id'), 'glia_contact__tests_pcg', ['object_pt_root_id'], unique=False)
    op.create_table('microns_func_coreg__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['microns_func_coreg.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_coreg__tests_pcg_pt_root_id'), 'microns_func_coreg__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('microns_func_unit_coreg__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['microns_func_unit_coreg.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_unit_coreg__tests_pcg_pt_root_id'), 'microns_func_unit_coreg__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('microns_func_unit_ext_coreg__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['microns_func_unit_ext_coreg.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_microns_func_unit_ext_coreg__tests_pcg_pt_root_id'), 'microns_func_unit_ext_coreg__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('nocleft_synapse__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pre_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pre_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['nocleft_synapse.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nocleft_synapse__tests_pcg_post_pt_root_id'), 'nocleft_synapse__tests_pcg', ['post_pt_root_id'], unique=False)
    op.create_index(op.f('ix_nocleft_synapse__tests_pcg_pre_pt_root_id'), 'nocleft_synapse__tests_pcg', ['pre_pt_root_id'], unique=False)
    op.create_table('nucleus_detection__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['nucleus_detection.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nucleus_detection__tests_pcg_pt_root_id'), 'nucleus_detection__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('plastic_synapse__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pre_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pre_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['plastic_synapse.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_plastic_synapse__tests_pcg_post_pt_root_id'), 'plastic_synapse__tests_pcg', ['post_pt_root_id'], unique=False)
    op.create_index(op.f('ix_plastic_synapse__tests_pcg_pre_pt_root_id'), 'plastic_synapse__tests_pcg', ['pre_pt_root_id'], unique=False)
    op.create_table('postsynaptic_compartment',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('compartment', sa.String(), nullable=True),
    sa.Column('on_spine', sa.Boolean(), nullable=True),
    sa.Column('dendrite_class', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_postsynaptic_compartment_created'), 'postsynaptic_compartment', ['created'], unique=False)
    op.create_index(op.f('ix_postsynaptic_compartment_deleted'), 'postsynaptic_compartment', ['deleted'], unique=False)
    op.create_index(op.f('ix_postsynaptic_compartment_target_id'), 'postsynaptic_compartment', ['target_id'], unique=False)
    op.create_table('presynaptic_bouton_type',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('bouton_type', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_presynaptic_bouton_type_created'), 'presynaptic_bouton_type', ['created'], unique=False)
    op.create_index(op.f('ix_presynaptic_bouton_type_deleted'), 'presynaptic_bouton_type', ['deleted'], unique=False)
    op.create_index(op.f('ix_presynaptic_bouton_type_target_id'), 'presynaptic_bouton_type', ['target_id'], unique=False)
    op.create_table('proofread_status__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['proofread_status.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_proofread_status__tests_pcg_pt_root_id'), 'proofread_status__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('proofreading_boolstatus_user__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['proofreading_boolstatus_user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_proofreading_boolstatus_user__tests_pcg_pt_root_id'), 'proofreading_boolstatus_user__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('reference_point',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_position', Geometry(geometry_type='POINTZ', dimension=3, use_N_D_index=True, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_point_created'), 'reference_point', ['created'], unique=False)
    op.create_index(op.f('ix_reference_point_deleted'), 'reference_point', ['deleted'], unique=False)
    op.create_index(op.f('ix_reference_point_target_id'), 'reference_point', ['target_id'], unique=False)
    op.create_table('reference_synapse_valid',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.Column('is_valid', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_synapse_valid_created'), 'reference_synapse_valid', ['created'], unique=False)
    op.create_index(op.f('ix_reference_synapse_valid_deleted'), 'reference_synapse_valid', ['deleted'], unique=False)
    op.create_index(op.f('ix_reference_synapse_valid_target_id'), 'reference_synapse_valid', ['target_id'], unique=False)
    op.create_table('synapse__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pre_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pre_pt_root_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('post_pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['synapse.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_synapse__tests_pcg_post_pt_root_id'), 'synapse__tests_pcg', ['post_pt_root_id'], unique=False)
    op.create_index(op.f('ix_synapse__tests_pcg_pre_pt_root_id'), 'synapse__tests_pcg', ['pre_pt_root_id'], unique=False)
    op.create_table('bouton_shape__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['bouton_shape.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('cell_type_reference__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['cell_type_reference.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('fly_neuropil__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['fly_neuropil.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('postsynaptic_compartment__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['postsynaptic_compartment.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('presynaptic_bouton_type__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['presynaptic_bouton_type.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('reference_point__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('pt_supervoxel_id', sa.BigInteger(), nullable=True),
    sa.Column('pt_root_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['reference_point.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_point__tests_pcg_pt_root_id'), 'reference_point__tests_pcg', ['pt_root_id'], unique=False)
    op.create_table('reference_synapse_valid__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['reference_synapse_valid.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('reference_synapse_valid__tests_pcg')
    op.drop_index(op.f('ix_reference_point__tests_pcg_pt_root_id'), table_name='reference_point__tests_pcg')
    op.drop_table('reference_point__tests_pcg')
    op.drop_table('presynaptic_bouton_type__tests_pcg')
    op.drop_table('postsynaptic_compartment__tests_pcg')
    op.drop_table('fly_neuropil__tests_pcg')
    op.drop_table('cell_type_reference__tests_pcg')
    op.drop_table('bouton_shape__tests_pcg')
    op.drop_index(op.f('ix_synapse__tests_pcg_pre_pt_root_id'), table_name='synapse__tests_pcg')
    op.drop_index(op.f('ix_synapse__tests_pcg_post_pt_root_id'), table_name='synapse__tests_pcg')
    op.drop_table('synapse__tests_pcg')
    op.drop_index(op.f('ix_reference_synapse_valid_target_id'), table_name='reference_synapse_valid')
    op.drop_index(op.f('ix_reference_synapse_valid_deleted'), table_name='reference_synapse_valid')
    op.drop_index(op.f('ix_reference_synapse_valid_created'), table_name='reference_synapse_valid')
    op.drop_table('reference_synapse_valid')
    op.drop_index(op.f('ix_reference_point_target_id'), table_name='reference_point')
    op.drop_index(op.f('ix_reference_point_deleted'), table_name='reference_point')
    op.drop_index(op.f('ix_reference_point_created'), table_name='reference_point')
    op.drop_table('reference_point')
    op.drop_index(op.f('ix_proofreading_boolstatus_user__tests_pcg_pt_root_id'), table_name='proofreading_boolstatus_user__tests_pcg')
    op.drop_table('proofreading_boolstatus_user__tests_pcg')
    op.drop_index(op.f('ix_proofread_status__tests_pcg_pt_root_id'), table_name='proofread_status__tests_pcg')
    op.drop_table('proofread_status__tests_pcg')
    op.drop_index(op.f('ix_presynaptic_bouton_type_target_id'), table_name='presynaptic_bouton_type')
    op.drop_index(op.f('ix_presynaptic_bouton_type_deleted'), table_name='presynaptic_bouton_type')
    op.drop_index(op.f('ix_presynaptic_bouton_type_created'), table_name='presynaptic_bouton_type')
    op.drop_table('presynaptic_bouton_type')
    op.drop_index(op.f('ix_postsynaptic_compartment_target_id'), table_name='postsynaptic_compartment')
    op.drop_index(op.f('ix_postsynaptic_compartment_deleted'), table_name='postsynaptic_compartment')
    op.drop_index(op.f('ix_postsynaptic_compartment_created'), table_name='postsynaptic_compartment')
    op.drop_table('postsynaptic_compartment')
    op.drop_index(op.f('ix_plastic_synapse__tests_pcg_pre_pt_root_id'), table_name='plastic_synapse__tests_pcg')
    op.drop_index(op.f('ix_plastic_synapse__tests_pcg_post_pt_root_id'), table_name='plastic_synapse__tests_pcg')
    op.drop_table('plastic_synapse__tests_pcg')
    op.drop_index(op.f('ix_nucleus_detection__tests_pcg_pt_root_id'), table_name='nucleus_detection__tests_pcg')
    op.drop_table('nucleus_detection__tests_pcg')
    op.drop_index(op.f('ix_nocleft_synapse__tests_pcg_pre_pt_root_id'), table_name='nocleft_synapse__tests_pcg')
    op.drop_index(op.f('ix_nocleft_synapse__tests_pcg_post_pt_root_id'), table_name='nocleft_synapse__tests_pcg')
    op.drop_table('nocleft_synapse__tests_pcg')
    op.drop_index(op.f('ix_microns_func_unit_ext_coreg__tests_pcg_pt_root_id'), table_name='microns_func_unit_ext_coreg__tests_pcg')
    op.drop_table('microns_func_unit_ext_coreg__tests_pcg')
    op.drop_index(op.f('ix_microns_func_unit_coreg__tests_pcg_pt_root_id'), table_name='microns_func_unit_coreg__tests_pcg')
    op.drop_table('microns_func_unit_coreg__tests_pcg')
    op.drop_index(op.f('ix_microns_func_coreg__tests_pcg_pt_root_id'), table_name='microns_func_coreg__tests_pcg')
    op.drop_table('microns_func_coreg__tests_pcg')
    op.drop_index(op.f('ix_glia_contact__tests_pcg_object_pt_root_id'), table_name='glia_contact__tests_pcg')
    op.drop_index(op.f('ix_glia_contact__tests_pcg_glia_pt_root_id'), table_name='glia_contact__tests_pcg')
    op.drop_table('glia_contact__tests_pcg')
    op.drop_index(op.f('ix_fly_synapse__tests_pcg_pre_pt_root_id'), table_name='fly_synapse__tests_pcg')
    op.drop_index(op.f('ix_fly_synapse__tests_pcg_post_pt_root_id'), table_name='fly_synapse__tests_pcg')
    op.drop_table('fly_synapse__tests_pcg')
    op.drop_index(op.f('ix_fly_nt_synapse__tests_pcg_pre_pt_root_id'), table_name='fly_nt_synapse__tests_pcg')
    op.drop_index(op.f('ix_fly_nt_synapse__tests_pcg_post_pt_root_id'), table_name='fly_nt_synapse__tests_pcg')
    op.drop_table('fly_nt_synapse__tests_pcg')
    op.drop_index(op.f('ix_fly_neuropil_target_id'), table_name='fly_neuropil')
    op.drop_index(op.f('ix_fly_neuropil_deleted'), table_name='fly_neuropil')
    op.drop_index(op.f('ix_fly_neuropil_created'), table_name='fly_neuropil')
    op.drop_table('fly_neuropil')
    op.drop_index(op.f('ix_extended_classical_cell_type__tests_pcg_pt_root_id'), table_name='extended_classical_cell_type__tests_pcg')
    op.drop_table('extended_classical_cell_type__tests_pcg')
    op.drop_index(op.f('ix_derived_tag__tests_pcg_pt_root_id'), table_name='derived_tag__tests_pcg')
    op.drop_table('derived_tag__tests_pcg')
    op.drop_index(op.f('ix_derived_spatial_point__tests_pcg_root_id'), table_name='derived_spatial_point__tests_pcg')
    op.drop_table('derived_spatial_point__tests_pcg')
    op.drop_index(op.f('ix_derived_numeric_value__tests_pcg_pt_root_id'), table_name='derived_numeric_value__tests_pcg')
    op.drop_table('derived_numeric_value__tests_pcg')
    op.drop_index(op.f('ix_contact__tests_pcg_sideb_pt_root_id'), table_name='contact__tests_pcg')
    op.drop_index(op.f('ix_contact__tests_pcg_sidea_pt_root_id'), table_name='contact__tests_pcg')
    op.drop_table('contact__tests_pcg')
    op.drop_index(op.f('ix_compartment_proofread_status__tests_pcg_pt_root_id'), table_name='compartment_proofread_status__tests_pcg')
    op.drop_table('compartment_proofread_status__tests_pcg')
    op.drop_index(op.f('ix_cell_type_reference_target_id'), table_name='cell_type_reference')
    op.drop_index(op.f('ix_cell_type_reference_deleted'), table_name='cell_type_reference')
    op.drop_index(op.f('ix_cell_type_reference_created'), table_name='cell_type_reference')
    op.drop_table('cell_type_reference')
    op.drop_index(op.f('ix_cell_type_local__tests_pcg_pt_root_id'), table_name='cell_type_local__tests_pcg')
    op.drop_table('cell_type_local__tests_pcg')
    op.drop_index(op.f('ix_bouton_shape_target_id'), table_name='bouton_shape')
    op.drop_index(op.f('ix_bouton_shape_deleted'), table_name='bouton_shape')
    op.drop_index(op.f('ix_bouton_shape_created'), table_name='bouton_shape')
    op.drop_table('bouton_shape')
    op.drop_index(op.f('ix_bound_tag_user__tests_pcg_pt_root_id'), table_name='bound_tag_user__tests_pcg')
    op.drop_table('bound_tag_user__tests_pcg')
    op.drop_index(op.f('ix_bound_tag__tests_pcg_pt_root_id'), table_name='bound_tag__tests_pcg')
    op.drop_table('bound_tag__tests_pcg')
    op.drop_index(op.f('ix_bound_2tag_user__tests_pcg_pt_root_id'), table_name='bound_2tag_user__tests_pcg')
    op.drop_index(op.f('ix_bound_2tag_user__tests_pcg_pt2_root_id'), table_name='bound_2tag_user__tests_pcg')
    op.drop_table('bound_2tag_user__tests_pcg')
    op.drop_index(op.f('ix_bound_2tag__tests_pcg_pt_root_id'), table_name='bound_2tag__tests_pcg')
    op.drop_index(op.f('ix_bound_2tag__tests_pcg_pt2_root_id'), table_name='bound_2tag__tests_pcg')
    op.drop_table('bound_2tag__tests_pcg')
    op.drop_index(op.f('ix_synapse_deleted'), table_name='synapse')
    op.drop_index(op.f('ix_synapse_created'), table_name='synapse')
    op.drop_table('synapse')
    op.drop_table('reference_table')
    op.drop_index(op.f('ix_proofreading_boolstatus_user_deleted'), table_name='proofreading_boolstatus_user')
    op.drop_index(op.f('ix_proofreading_boolstatus_user_created'), table_name='proofreading_boolstatus_user')
    op.drop_table('proofreading_boolstatus_user')
    op.drop_index(op.f('ix_proofread_status_deleted'), table_name='proofread_status')
    op.drop_index(op.f('ix_proofread_status_created'), table_name='proofread_status')
    op.drop_table('proofread_status')
    op.drop_index(op.f('ix_plastic_synapse_deleted'), table_name='plastic_synapse')
    op.drop_index(op.f('ix_plastic_synapse_created'), table_name='plastic_synapse')
    op.drop_table('plastic_synapse')
    op.drop_index(op.f('ix_nucleus_detection_deleted'), table_name='nucleus_detection')
    op.drop_index(op.f('ix_nucleus_detection_created'), table_name='nucleus_detection')
    op.drop_table('nucleus_detection')
    op.drop_index(op.f('ix_nocleft_synapse_deleted'), table_name='nocleft_synapse')
    op.drop_index(op.f('ix_nocleft_synapse_created'), table_name='nocleft_synapse')
    op.drop_table('nocleft_synapse')
    op.drop_index(op.f('ix_microns_func_unit_ext_coreg_deleted'), table_name='microns_func_unit_ext_coreg')
    op.drop_index(op.f('ix_microns_func_unit_ext_coreg_created'), table_name='microns_func_unit_ext_coreg')
    op.drop_table('microns_func_unit_ext_coreg')
    op.drop_index(op.f('ix_microns_func_unit_coreg_deleted'), table_name='microns_func_unit_coreg')
    op.drop_index(op.f('ix_microns_func_unit_coreg_created'), table_name='microns_func_unit_coreg')
    op.drop_table('microns_func_unit_coreg')
    op.drop_index(op.f('ix_microns_func_coreg_deleted'), table_name='microns_func_coreg')
    op.drop_index(op.f('ix_microns_func_coreg_created'), table_name='microns_func_coreg')
    op.drop_table('microns_func_coreg')
    op.drop_index(op.f('ix_glia_contact_deleted'), table_name='glia_contact')
    op.drop_index(op.f('ix_glia_contact_created'), table_name='glia_contact')
    op.drop_table('glia_contact')
    op.drop_index(op.f('ix_fly_synapse_deleted'), table_name='fly_synapse')
    op.drop_index(op.f('ix_fly_synapse_created'), table_name='fly_synapse')
    op.drop_table('fly_synapse')
    op.drop_index(op.f('ix_fly_nt_synapse_deleted'), table_name='fly_nt_synapse')
    op.drop_index(op.f('ix_fly_nt_synapse_created'), table_name='fly_nt_synapse')
    op.drop_table('fly_nt_synapse')
    op.drop_index(op.f('ix_extended_classical_cell_type_deleted'), table_name='extended_classical_cell_type')
    op.drop_index(op.f('ix_extended_classical_cell_type_created'), table_name='extended_classical_cell_type')
    op.drop_table('extended_classical_cell_type')
    op.drop_index(op.f('ix_derived_tag_deleted'), table_name='derived_tag')
    op.drop_index(op.f('ix_derived_tag_created'), table_name='derived_tag')
    op.drop_table('derived_tag')
    op.drop_index(op.f('ix_derived_spatial_point_deleted'), table_name='derived_spatial_point')
    op.drop_index(op.f('ix_derived_spatial_point_created'), table_name='derived_spatial_point')
    op.drop_table('derived_spatial_point')
    op.drop_index(op.f('ix_derived_numeric_value_deleted'), table_name='derived_numeric_value')
    op.drop_index(op.f('ix_derived_numeric_value_created'), table_name='derived_numeric_value')
    op.drop_table('derived_numeric_value')
    op.drop_index(op.f('ix_contact_deleted'), table_name='contact')
    op.drop_index(op.f('ix_contact_created'), table_name='contact')
    op.drop_table('contact')
    op.drop_index(op.f('ix_compartment_proofread_status_deleted'), table_name='compartment_proofread_status')
    op.drop_index(op.f('ix_compartment_proofread_status_created'), table_name='compartment_proofread_status')
    op.drop_table('compartment_proofread_status')
    op.drop_index(op.f('ix_cell_type_local_deleted'), table_name='cell_type_local')
    op.drop_index(op.f('ix_cell_type_local_created'), table_name='cell_type_local')
    op.drop_table('cell_type_local')
    op.drop_index(op.f('ix_bound_tag_user_deleted'), table_name='bound_tag_user')
    op.drop_index(op.f('ix_bound_tag_user_created'), table_name='bound_tag_user')
    op.drop_table('bound_tag_user')
    op.drop_index(op.f('ix_bound_tag_deleted'), table_name='bound_tag')
    op.drop_index(op.f('ix_bound_tag_created'), table_name='bound_tag')
    op.drop_table('bound_tag')
    op.drop_index(op.f('ix_bound_2tag_user_deleted'), table_name='bound_2tag_user')
    op.drop_index(op.f('ix_bound_2tag_user_created'), table_name='bound_2tag_user')
    op.drop_table('bound_2tag_user')
    op.drop_index(op.f('ix_bound_2tag_deleted'), table_name='bound_2tag')
    op.drop_index(op.f('ix_bound_2tag_created'), table_name='bound_2tag')
    op.drop_table('bound_2tag')
    # ### end Alembic commands ###
