# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### ApiObject <a name="cdk8s.ApiObject"></a>

#### Initializers <a name="cdk8s.ApiObject.Initializer"></a>

```typescript
import { ApiObject } from 'cdk8s'

new ApiObject(scope: Construct, id: string, props: ApiObjectProps)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

the construct scope.

---

##### `id`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.id"></a>

- *Type:* `string`

namespace.

---

##### `props`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.props"></a>

- *Type:* [`cdk8s.ApiObjectProps`](#cdk8s.ApiObjectProps)

options.

---

#### Methods <a name="Methods"></a>

##### `addDependency` <a name="cdk8s.ApiObject.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct)
```

###### `dependencies`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.dependencies"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

the dependencies to add.

---

##### `addJsonPatch` <a name="cdk8s.ApiObject.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch)
```

###### `ops`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.ops"></a>

- *Type:* [`cdk8s.JsonPatch`](#cdk8s.JsonPatch)

The JSON-Patch operations to apply.

---

##### `toJson` <a name="cdk8s.ApiObject.toJson"></a>

```typescript
public toJson()
```

#### Static Functions <a name="Static Functions"></a>

##### `of` <a name="cdk8s.ApiObject.of"></a>

```typescript
import { ApiObject } from 'cdk8s'

ApiObject.of(c: IConstruct)
```

###### `c`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.c"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

The higher-level construct.

---

#### Properties <a name="Properties"></a>

##### `apiGroup`<sup>Required</sup> <a name="cdk8s.ApiObject.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* `string`

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="cdk8s.ApiObject.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* `string`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="cdk8s.ApiObject.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* [`cdk8s.Chart`](#cdk8s.Chart)

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.ApiObject.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* `string`

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="cdk8s.ApiObject.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* [`cdk8s.ApiObjectMetadataDefinition`](#cdk8s.ApiObjectMetadataDefinition)

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="cdk8s.ApiObject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---


### App <a name="cdk8s.App"></a>

Represents a cdk8s application.

#### Initializers <a name="cdk8s.App.Initializer"></a>

```typescript
import { App } from 'cdk8s'

new App(props?: AppProps)
```

##### `props`<sup>Optional</sup> <a name="cdk8s.App.parameter.props"></a>

- *Type:* [`cdk8s.AppProps`](#cdk8s.AppProps)

configuration options.

---

#### Methods <a name="Methods"></a>

##### `synth` <a name="cdk8s.App.synth"></a>

```typescript
public synth()
```

##### `synthYaml` <a name="cdk8s.App.synthYaml"></a>

```typescript
public synthYaml()
```


#### Properties <a name="Properties"></a>

##### `charts`<sup>Required</sup> <a name="cdk8s.App.property.charts"></a>

```typescript
public readonly charts: Chart[];
```

- *Type:* [`cdk8s.Chart`](#cdk8s.Chart)[]

Returns all the charts in this app, sorted topologically.

---

##### `outdir`<sup>Required</sup> <a name="cdk8s.App.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* `string`

The output directory into which manifests will be synthesized.

---

##### `outputFileExtension`<sup>Required</sup> <a name="cdk8s.App.property.outputFileExtension"></a>

```typescript
public readonly outputFileExtension: string;
```

- *Type:* `string`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yamlOutputType`<sup>Required</sup> <a name="cdk8s.App.property.yamlOutputType"></a>

```typescript
public readonly yamlOutputType: YamlOutputType;
```

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---


### Chart <a name="cdk8s.Chart"></a>

#### Initializers <a name="cdk8s.Chart.Initializer"></a>

```typescript
import { Chart } from 'cdk8s'

new Chart(scope: Construct, id: string, props?: ChartProps)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Chart.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Chart.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Optional</sup> <a name="cdk8s.Chart.parameter.props"></a>

- *Type:* [`cdk8s.ChartProps`](#cdk8s.ChartProps)

---

#### Methods <a name="Methods"></a>

##### `addDependency` <a name="cdk8s.Chart.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct)
```

###### `dependencies`<sup>Required</sup> <a name="cdk8s.Chart.parameter.dependencies"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

the dependencies to add.

---

##### `generateObjectName` <a name="cdk8s.Chart.generateObjectName"></a>

```typescript
public generateObjectName(apiObject: ApiObject)
```

###### `apiObject`<sup>Required</sup> <a name="cdk8s.Chart.parameter.apiObject"></a>

- *Type:* [`cdk8s.ApiObject`](#cdk8s.ApiObject)

The API object to generate a name for.

---

##### `toJson` <a name="cdk8s.Chart.toJson"></a>

```typescript
public toJson()
```

#### Static Functions <a name="Static Functions"></a>

##### `isChart` <a name="cdk8s.Chart.isChart"></a>

```typescript
import { Chart } from 'cdk8s'

Chart.isChart(x: any)
```

###### `x`<sup>Required</sup> <a name="cdk8s.Chart.parameter.x"></a>

- *Type:* `any`

---

##### `of` <a name="cdk8s.Chart.of"></a>

```typescript
import { Chart } from 'cdk8s'

Chart.of(c: IConstruct)
```

###### `c`<sup>Required</sup> <a name="cdk8s.Chart.parameter.c"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

a construct node.

---

#### Properties <a name="Properties"></a>

##### `labels`<sup>Required</sup> <a name="cdk8s.Chart.property.labels"></a>

```typescript
public readonly labels: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: `string`}

Labels applied to all resources in this chart.

This is an immutable copy.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.Chart.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* `string`

The default namespace for all objects in this chart.

---


### Helm <a name="cdk8s.Helm"></a>

Represents a Helm deployment.

Use this construct to import an existing Helm chart and incorporate it into your constructs.

#### Initializers <a name="cdk8s.Helm.Initializer"></a>

```typescript
import { Helm } from 'cdk8s'

new Helm(scope: Construct, id: string, props: HelmProps)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Helm.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Helm.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="cdk8s.Helm.parameter.props"></a>

- *Type:* [`cdk8s.HelmProps`](#cdk8s.HelmProps)

---



#### Properties <a name="Properties"></a>

##### `releaseName`<sup>Required</sup> <a name="cdk8s.Helm.property.releaseName"></a>

```typescript
public readonly releaseName: string;
```

- *Type:* `string`

The helm release name.

---


### Include <a name="cdk8s.Include"></a>

Reads a YAML manifest from a file or a URL and defines all resources as API objects within the defined scope.

The names (`metadata.name`) of imported resources will be preserved as-is
from the manifest.

#### Initializers <a name="cdk8s.Include.Initializer"></a>

```typescript
import { Include } from 'cdk8s'

new Include(scope: Construct, id: string, props: IncludeProps)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Include.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Include.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="cdk8s.Include.parameter.props"></a>

- *Type:* [`cdk8s.IncludeProps`](#cdk8s.IncludeProps)

---



#### Properties <a name="Properties"></a>

##### `apiObjects`<sup>Required</sup> <a name="cdk8s.Include.property.apiObjects"></a>

```typescript
public readonly apiObjects: ApiObject[];
```

- *Type:* [`cdk8s.ApiObject`](#cdk8s.ApiObject)[]

Returns all the included API objects.

---


## Structs <a name="Structs"></a>

### ApiObjectMetadata <a name="cdk8s.ApiObjectMetadata"></a>

Metadata associated with this object.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { ApiObjectMetadata } from 'cdk8s'

const apiObjectMetadata: ApiObjectMetadata = { ... }
```

##### `annotations`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.annotations"></a>

```typescript
public readonly annotations: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: `string`}
- *Default:* No annotations.

Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

They are not queryable and should be
preserved when modifying objects.

> http://kubernetes.io/docs/user-guide/annotations

---

##### `finalizers`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.finalizers"></a>

```typescript
public readonly finalizers: string[];
```

- *Type:* `string`[]
- *Default:* No finalizers.

Namespaced keys that tell Kubernetes to wait until specific conditions are met before it fully deletes resources marked for deletion.

Must be empty before the object is deleted from the registry. Each entry is
an identifier for the responsible component that will remove the entry from
the list. If the deletionTimestamp of the object is non-nil, entries in
this list can only be removed. Finalizers may be processed and removed in
any order.  Order is NOT enforced because it introduces significant risk of
stuck finalizers. finalizers is a shared field, any actor with permission
can reorder it. If the finalizer list is processed in order, then this can
lead to a situation in which the component responsible for the first
finalizer in the list is waiting for a signal (field value, external
system, or other) produced by a component responsible for a finalizer later
in the list, resulting in a deadlock. Without enforced ordering finalizers
are free to order amongst themselves and are not vulnerable to ordering
changes in the list.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/finalizers/

---

##### `labels`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.labels"></a>

```typescript
public readonly labels: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: `string`}
- *Default:* No labels.

Map of string keys and values that can be used to organize and categorize (scope and select) objects.

May match selectors of replication controllers and services.

> http://kubernetes.io/docs/user-guide/labels

---

##### `name`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`
- *Default:* an app-unique name generated by the chart

The unique, namespace-global, name of this object inside the Kubernetes cluster.

Normally, you shouldn't specify names for objects and let the CDK generate
a name for you that is application-unique. The names CDK generates are
composed from the construct path components, separated by dots and a suffix
that is based on a hash of the entire path, to ensure uniqueness.

You can supply custom name allocation logic by overriding the
`chart.generateObjectName` method.

If you use an explicit name here, bear in mind that this reduces the
composability of your construct because it won't be possible to include
more than one instance in any app. Therefore it is highly recommended to
leave this unspecified.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* `string`
- *Default:* undefined (will be assigned to the 'default' namespace)

Namespace defines the space within each name must be unique.

An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation.
Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty. Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces

---

##### `ownerReferences`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.ownerReferences"></a>

```typescript
public readonly ownerReferences: OwnerReference[];
```

- *Type:* [`cdk8s.OwnerReference`](#cdk8s.OwnerReference)[]
- *Default:* automatically set by Kubernetes

List of objects depended by this object.

If ALL objects in the list have
been deleted, this object will be garbage collected. If this object is
managed by a controller, then an entry in this list will point to this
controller, with the controller field set to true. There cannot be more
than one managing controller.

Kubernetes sets the value of this field automatically for objects that are
dependents of other objects like ReplicaSets, DaemonSets, Deployments, Jobs
and CronJobs, and ReplicationControllers. You can also configure these
relationships manually by changing the value of this field. However, you
usually don't need to and can allow Kubernetes to automatically manage the
relationships.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/

---

### ApiObjectProps <a name="cdk8s.ApiObjectProps"></a>

Options for defining API objects.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { ApiObjectProps } from 'cdk8s'

const apiObjectProps: ApiObjectProps = { ... }
```

##### `apiVersion`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* `string`

API version.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* `string`

Resource kind.

---

##### `metadata`<sup>Optional</sup> <a name="cdk8s.ApiObjectProps.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadata;
```

- *Type:* [`cdk8s.ApiObjectMetadata`](#cdk8s.ApiObjectMetadata)

Object metadata.

If `name` is not specified, an app-unique name will be allocated by the
framework based on the path of the construct within thes construct tree.

---

### AppProps <a name="cdk8s.AppProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { AppProps } from 'cdk8s'

const appProps: AppProps = { ... }
```

##### `outdir`<sup>Optional</sup> <a name="cdk8s.AppProps.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* `string`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

##### `outputFileExtension`<sup>Optional</sup> <a name="cdk8s.AppProps.property.outputFileExtension"></a>

```typescript
public readonly outputFileExtension: string;
```

- *Type:* `string`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yamlOutputType`<sup>Optional</sup> <a name="cdk8s.AppProps.property.yamlOutputType"></a>

```typescript
public readonly yamlOutputType: YamlOutputType;
```

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

### ChartProps <a name="cdk8s.ChartProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { ChartProps } from 'cdk8s'

const chartProps: ChartProps = { ... }
```

##### `labels`<sup>Optional</sup> <a name="cdk8s.ChartProps.property.labels"></a>

```typescript
public readonly labels: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: `string`}
- *Default:* no common labels

Labels to apply to all resources in this chart.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ChartProps.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* `string`
- *Default:* no namespace is synthesized (usually this implies "default")

The default namespace for all objects defined in this chart (directly or indirectly).

This namespace will only apply to objects that don't have a
`namespace` explicitly defined for them.

---

### CronOptions <a name="cdk8s.CronOptions"></a>

Options to configure a cron expression.

All fields are strings so you can use complex expressions. Absence of
a field implies '*' or '?', whichever one is appropriate.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { CronOptions } from 'cdk8s'

const cronOptions: CronOptions = { ... }
```

##### `day`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.day"></a>

```typescript
public readonly day: string;
```

- *Type:* `string`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

##### `hour`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.hour"></a>

```typescript
public readonly hour: string;
```

- *Type:* `string`
- *Default:* Every hour

The hour to run this rule at.

---

##### `minute`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.minute"></a>

```typescript
public readonly minute: string;
```

- *Type:* `string`
- *Default:* Every minute

The minute to run this rule at.

---

##### `month`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.month"></a>

```typescript
public readonly month: string;
```

- *Type:* `string`
- *Default:* Every month

The month to run this rule at.

---

##### `weekDay`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.weekDay"></a>

```typescript
public readonly weekDay: string;
```

- *Type:* `string`
- *Default:* Any day of the week

The day of the week to run this rule at.

---

##### `year`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.year"></a>

```typescript
public readonly year: string;
```

- *Type:* `string`
- *Default:* Every year

The year to run this rule at.

---

### GroupVersionKind <a name="cdk8s.GroupVersionKind"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { GroupVersionKind } from 'cdk8s'

const groupVersionKind: GroupVersionKind = { ... }
```

##### `apiVersion`<sup>Required</sup> <a name="cdk8s.GroupVersionKind.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* `string`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `kind`<sup>Required</sup> <a name="cdk8s.GroupVersionKind.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* `string`

The object kind.

---

### HelmProps <a name="cdk8s.HelmProps"></a>

Options for `Helm`.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { HelmProps } from 'cdk8s'

const helmProps: HelmProps = { ... }
```

##### `chart`<sup>Required</sup> <a name="cdk8s.HelmProps.property.chart"></a>

```typescript
public readonly chart: string;
```

- *Type:* `string`

The chart name to use. It can be a chart from a helm repository or a local directory.

This name is passed to `helm template` and has all the relevant semantics.

---

##### `helmExecutable`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.helmExecutable"></a>

```typescript
public readonly helmExecutable: string;
```

- *Type:* `string`
- *Default:* "helm"

The local helm executable to use in order to create the manifest the chart.

---

##### `helmFlags`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.helmFlags"></a>

```typescript
public readonly helmFlags: string[];
```

- *Type:* `string`[]
- *Default:* []

Additional flags to add to the `helm` execution.

---

##### `releaseName`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.releaseName"></a>

```typescript
public readonly releaseName: string;
```

- *Type:* `string`
- *Default:* if unspecified, a name will be allocated based on the construct path

The release name.

> https://helm.sh/docs/intro/using_helm/#three-big-concepts

---

##### `values`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.values"></a>

```typescript
public readonly values: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: `any`}
- *Default:* If no values are specified, chart will use the defaults.

Values to pass to the chart.

---

### IncludeProps <a name="cdk8s.IncludeProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { IncludeProps } from 'cdk8s'

const includeProps: IncludeProps = { ... }
```

##### `url`<sup>Required</sup> <a name="cdk8s.IncludeProps.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

Local file path or URL which includes a Kubernetes YAML manifest.

---

### NameOptions <a name="cdk8s.NameOptions"></a>

Options for name generation.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { NameOptions } from 'cdk8s'

const nameOptions: NameOptions = { ... }
```

##### `delimiter`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.delimiter"></a>

```typescript
public readonly delimiter: string;
```

- *Type:* `string`
- *Default:* "-"

Delimiter to use between components.

---

##### `extra`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.extra"></a>

```typescript
public readonly extra: string[];
```

- *Type:* `string`[]
- *Default:* [] use the construct path components

Extra components to include in the name.

---

##### `includeHash`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.includeHash"></a>

```typescript
public readonly includeHash: boolean;
```

- *Type:* `boolean`
- *Default:* true

Include a short hash as last part of the name.

---

##### `maxLen`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.maxLen"></a>

```typescript
public readonly maxLen: number;
```

- *Type:* `number`
- *Default:* 63

Maximum allowed length for the name.

---

### OwnerReference <a name="cdk8s.OwnerReference"></a>

OwnerReference contains enough information to let you identify an owning object.

An owning object must be in the same namespace as the dependent, or
be cluster-scoped, so there is no namespace field.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { OwnerReference } from 'cdk8s'

const ownerReference: OwnerReference = { ... }
```

##### `apiVersion`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* `string`

API version of the referent.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* `string`

Kind of the referent.

> https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

---

##### `name`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

Name of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#names

---

##### `uid`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.uid"></a>

```typescript
public readonly uid: string;
```

- *Type:* `string`

UID of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#uids

---

##### `blockOwnerDeletion`<sup>Optional</sup> <a name="cdk8s.OwnerReference.property.blockOwnerDeletion"></a>

```typescript
public readonly blockOwnerDeletion: boolean;
```

- *Type:* `boolean`
- *Default:* false. To set this field, a user needs "delete" permission of the
owner, otherwise 422 (Unprocessable Entity) will be returned.

If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.

Defaults to false. To set this field, a user needs "delete"
permission of the owner, otherwise 422 (Unprocessable Entity) will be
returned.

---

##### `controller`<sup>Optional</sup> <a name="cdk8s.OwnerReference.property.controller"></a>

```typescript
public readonly controller: boolean;
```

- *Type:* `boolean`

If true, this reference points to the managing controller.

---

### SizeConversionOptions <a name="cdk8s.SizeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { SizeConversionOptions } from 'cdk8s'

const sizeConversionOptions: SizeConversionOptions = { ... }
```

##### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.property.rounding"></a>

```typescript
public readonly rounding: SizeRoundingBehavior;
```

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

### TimeConversionOptions <a name="cdk8s.TimeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { TimeConversionOptions } from 'cdk8s'

const timeConversionOptions: TimeConversionOptions = { ... }
```

##### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.property.integral"></a>

```typescript
public readonly integral: boolean;
```

- *Type:* `boolean`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

## Classes <a name="Classes"></a>

### ApiObjectMetadataDefinition <a name="cdk8s.ApiObjectMetadataDefinition"></a>

Object metadata.

#### Initializers <a name="cdk8s.ApiObjectMetadataDefinition.Initializer"></a>

```typescript
import { ApiObjectMetadataDefinition } from 'cdk8s'

new ApiObjectMetadataDefinition(options?: ApiObjectMetadata)
```

##### `options`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.options"></a>

- *Type:* [`cdk8s.ApiObjectMetadata`](#cdk8s.ApiObjectMetadata)

---

#### Methods <a name="Methods"></a>

##### `add` <a name="cdk8s.ApiObjectMetadataDefinition.add"></a>

```typescript
public add(key: string, value: any)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `string`

Metadata key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `any`

Metadata value.

---

##### `addAnnotation` <a name="cdk8s.ApiObjectMetadataDefinition.addAnnotation"></a>

```typescript
public addAnnotation(key: string, value: string)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `string`

The key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `string`

The value.

---

##### `addFinalizers` <a name="cdk8s.ApiObjectMetadataDefinition.addFinalizers"></a>

```typescript
public addFinalizers(finalizers: string)
```

###### `finalizers`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.finalizers"></a>

- *Type:* `string`

the finalizers.

---

##### `addLabel` <a name="cdk8s.ApiObjectMetadataDefinition.addLabel"></a>

```typescript
public addLabel(key: string, value: string)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `string`

The key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `string`

The value.

---

##### `addOwnerReference` <a name="cdk8s.ApiObjectMetadataDefinition.addOwnerReference"></a>

```typescript
public addOwnerReference(owner: OwnerReference)
```

###### `owner`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.owner"></a>

- *Type:* [`cdk8s.OwnerReference`](#cdk8s.OwnerReference)

the owner.

---

##### `getLabel` <a name="cdk8s.ApiObjectMetadataDefinition.getLabel"></a>

```typescript
public getLabel(key: string)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `string`

the label.

---

##### `toJson` <a name="cdk8s.ApiObjectMetadataDefinition.toJson"></a>

```typescript
public toJson()
```


#### Properties <a name="Properties"></a>

##### `name`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadataDefinition.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadataDefinition.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* `string`

The object's namespace.

---


### DependencyGraph <a name="cdk8s.DependencyGraph"></a>

Represents the dependency graph for a given Node.

This graph includes the dependency relationships between all nodes in the
node (construct) sub-tree who's root is this Node.

Note that this means that lonely nodes (no dependencies and no dependants) are also included in this graph as
childless children of the root node of the graph.

The graph does not include cross-scope dependencies. That is, if a child on the current scope depends on a node
from a different scope, that relationship is not represented in this graph.

#### Initializers <a name="cdk8s.DependencyGraph.Initializer"></a>

```typescript
import { DependencyGraph } from 'cdk8s'

new DependencyGraph(node: Node)
```

##### `node`<sup>Required</sup> <a name="cdk8s.DependencyGraph.parameter.node"></a>

- *Type:* [`constructs.Node`](#constructs.Node)

---

#### Methods <a name="Methods"></a>

##### `topology` <a name="cdk8s.DependencyGraph.topology"></a>

```typescript
public topology()
```


#### Properties <a name="Properties"></a>

##### `root`<sup>Required</sup> <a name="cdk8s.DependencyGraph.property.root"></a>

```typescript
public readonly root: DependencyVertex;
```

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)

Returns the root of the graph.

Note that this vertex will always have `null` as its `.value` since it is an artifical root
that binds all the connected spaces of the graph.

---


### DependencyVertex <a name="cdk8s.DependencyVertex"></a>

Represents a vertex in the graph.

The value of each vertex is an `IConstruct` that is accessible via the `.value` getter.

#### Initializers <a name="cdk8s.DependencyVertex.Initializer"></a>

```typescript
import { DependencyVertex } from 'cdk8s'

new DependencyVertex(value?: IConstruct)
```

##### `value`<sup>Optional</sup> <a name="cdk8s.DependencyVertex.parameter.value"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

---

#### Methods <a name="Methods"></a>

##### `addChild` <a name="cdk8s.DependencyVertex.addChild"></a>

```typescript
public addChild(dep: DependencyVertex)
```

###### `dep`<sup>Required</sup> <a name="cdk8s.DependencyVertex.parameter.dep"></a>

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)

The dependency.

---

##### `topology` <a name="cdk8s.DependencyVertex.topology"></a>

```typescript
public topology()
```


#### Properties <a name="Properties"></a>

##### `inbound`<sup>Required</sup> <a name="cdk8s.DependencyVertex.property.inbound"></a>

```typescript
public readonly inbound: DependencyVertex[];
```

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)[]

Returns the parents of the vertex (i.e dependants).

---

##### `outbound`<sup>Required</sup> <a name="cdk8s.DependencyVertex.property.outbound"></a>

```typescript
public readonly outbound: DependencyVertex[];
```

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)[]

Returns the children of the vertex (i.e dependencies).

---

##### `value`<sup>Optional</sup> <a name="cdk8s.DependencyVertex.property.value"></a>

```typescript
public readonly value: IConstruct;
```

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

Returns the IConstruct this graph vertex represents.

`null` in case this is the root of the graph.

---


### Duration <a name="cdk8s.Duration"></a>

Represents a length of time.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

#### Methods <a name="Methods"></a>

##### `toDays` <a name="cdk8s.Duration.toDays"></a>

```typescript
public toDays(opts?: TimeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Duration.parameter.opts"></a>

- *Type:* [`cdk8s.TimeConversionOptions`](#cdk8s.TimeConversionOptions)

---

##### `toHours` <a name="cdk8s.Duration.toHours"></a>

```typescript
public toHours(opts?: TimeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Duration.parameter.opts"></a>

- *Type:* [`cdk8s.TimeConversionOptions`](#cdk8s.TimeConversionOptions)

---

##### `toHumanString` <a name="cdk8s.Duration.toHumanString"></a>

```typescript
public toHumanString()
```

##### `toIsoString` <a name="cdk8s.Duration.toIsoString"></a>

```typescript
public toIsoString()
```

##### `toMilliseconds` <a name="cdk8s.Duration.toMilliseconds"></a>

```typescript
public toMilliseconds(opts?: TimeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Duration.parameter.opts"></a>

- *Type:* [`cdk8s.TimeConversionOptions`](#cdk8s.TimeConversionOptions)

---

##### `toMinutes` <a name="cdk8s.Duration.toMinutes"></a>

```typescript
public toMinutes(opts?: TimeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Duration.parameter.opts"></a>

- *Type:* [`cdk8s.TimeConversionOptions`](#cdk8s.TimeConversionOptions)

---

##### `toSeconds` <a name="cdk8s.Duration.toSeconds"></a>

```typescript
public toSeconds(opts?: TimeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Duration.parameter.opts"></a>

- *Type:* [`cdk8s.TimeConversionOptions`](#cdk8s.TimeConversionOptions)

---

##### `unitLabel` <a name="cdk8s.Duration.unitLabel"></a>

```typescript
public unitLabel()
```

#### Static Functions <a name="Static Functions"></a>

##### `days` <a name="cdk8s.Duration.days"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.days(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `number`

the amount of Days the `Duration` will represent.

---

##### `hours` <a name="cdk8s.Duration.hours"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.hours(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `number`

the amount of Hours the `Duration` will represent.

---

##### `millis` <a name="cdk8s.Duration.millis"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.millis(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `number`

the amount of Milliseconds the `Duration` will represent.

---

##### `minutes` <a name="cdk8s.Duration.minutes"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.minutes(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `number`

the amount of Minutes the `Duration` will represent.

---

##### `parse` <a name="cdk8s.Duration.parse"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.parse(duration: string)
```

###### `duration`<sup>Required</sup> <a name="cdk8s.Duration.parameter.duration"></a>

- *Type:* `string`

an ISO-formtted duration to be parsed.

---

##### `seconds` <a name="cdk8s.Duration.seconds"></a>

```typescript
import { Duration } from 'cdk8s'

Duration.seconds(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `number`

the amount of Seconds the `Duration` will represent.

---



### JsonPatch <a name="cdk8s.JsonPatch"></a>

Utility for applying RFC-6902 JSON-Patch to a document.

Use the the `JsonPatch.apply(doc, ...ops)` function to apply a set of
operations to a JSON document and return the result.

Operations can be created using the factory methods `JsonPatch.add()`,
`JsonPatch.remove()`, etc.


#### Static Functions <a name="Static Functions"></a>

##### `add` <a name="cdk8s.JsonPatch.add"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.add(path: string, value: any)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `any`

---

##### `apply` <a name="cdk8s.JsonPatch.apply"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.apply(document: any, ops: JsonPatch)
```

###### `document`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.document"></a>

- *Type:* `any`

The document to patch.

---

###### `ops`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.ops"></a>

- *Type:* [`cdk8s.JsonPatch`](#cdk8s.JsonPatch)

The operations to apply.

---

##### `copy` <a name="cdk8s.JsonPatch.copy"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.copy(from: string, path: string)
```

###### `from`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `string`

---

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

##### `move` <a name="cdk8s.JsonPatch.move"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.move(from: string, path: string)
```

###### `from`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `string`

---

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

##### `remove` <a name="cdk8s.JsonPatch.remove"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.remove(path: string)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

##### `replace` <a name="cdk8s.JsonPatch.replace"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.replace(path: string, value: any)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `any`

---

##### `test` <a name="cdk8s.JsonPatch.test"></a>

```typescript
import { JsonPatch } from 'cdk8s'

JsonPatch.test(path: string, value: any)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `string`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `any`

---



### Lazy <a name="cdk8s.Lazy"></a>

#### Methods <a name="Methods"></a>

##### `produce` <a name="cdk8s.Lazy.produce"></a>

```typescript
public produce()
```

#### Static Functions <a name="Static Functions"></a>

##### `any` <a name="cdk8s.Lazy.any"></a>

```typescript
import { Lazy } from 'cdk8s'

Lazy.any(producer: IAnyProducer)
```

###### `producer`<sup>Required</sup> <a name="cdk8s.Lazy.parameter.producer"></a>

- *Type:* [`cdk8s.IAnyProducer`](#cdk8s.IAnyProducer)

---



### Names <a name="cdk8s.Names"></a>

Utilities for generating unique and stable names.


#### Static Functions <a name="Static Functions"></a>

##### `toDnsLabel` <a name="cdk8s.Names.toDnsLabel"></a>

```typescript
import { Names } from 'cdk8s'

Names.toDnsLabel(scope: Construct, options?: NameOptions)
```

###### `scope`<sup>Required</sup> <a name="cdk8s.Names.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The construct for which to render the DNS label.

---

###### `options`<sup>Optional</sup> <a name="cdk8s.Names.parameter.options"></a>

- *Type:* [`cdk8s.NameOptions`](#cdk8s.NameOptions)

Name options.

---

##### `toLabelValue` <a name="cdk8s.Names.toLabelValue"></a>

```typescript
import { Names } from 'cdk8s'

Names.toLabelValue(scope: Construct, options?: NameOptions)
```

###### `scope`<sup>Required</sup> <a name="cdk8s.Names.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The construct for which to render the DNS label.

---

###### `options`<sup>Optional</sup> <a name="cdk8s.Names.parameter.options"></a>

- *Type:* [`cdk8s.NameOptions`](#cdk8s.NameOptions)

Name options.

---



### Schedule <a name="cdk8s.Schedule"></a>

Represents a schedule.

Note that rates cannot be defined in fractions of minutes.

#### Initializers <a name="cdk8s.Schedule.Initializer"></a>

```typescript
import { Schedule } from 'cdk8s'

new Schedule()
```


#### Static Functions <a name="Static Functions"></a>

##### `cron` <a name="cdk8s.Schedule.cron"></a>

```typescript
import { Schedule } from 'cdk8s'

Schedule.cron(options: CronOptions)
```

###### `options`<sup>Required</sup> <a name="cdk8s.Schedule.parameter.options"></a>

- *Type:* [`cdk8s.CronOptions`](#cdk8s.CronOptions)

---

##### `expression` <a name="cdk8s.Schedule.expression"></a>

```typescript
import { Schedule } from 'cdk8s'

Schedule.expression(expression: string)
```

###### `expression`<sup>Required</sup> <a name="cdk8s.Schedule.parameter.expression"></a>

- *Type:* `string`

The expression to use.

Must be in a format of 'value unit'

---

##### `rate` <a name="cdk8s.Schedule.rate"></a>

```typescript
import { Schedule } from 'cdk8s'

Schedule.rate(duration: Duration)
```

###### `duration`<sup>Required</sup> <a name="cdk8s.Schedule.parameter.duration"></a>

- *Type:* [`cdk8s.Duration`](#cdk8s.Duration)

---

#### Properties <a name="Properties"></a>

##### `expressionString`<sup>Required</sup> <a name="cdk8s.Schedule.property.expressionString"></a>

```typescript
public readonly expressionString: string;
```

- *Type:* `string`

Retrieve the expression for this schedule.

---


### Size <a name="cdk8s.Size"></a>

Represents the amount of digital storage.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

When the amount is passed as a token, unit conversion is not possible.

#### Methods <a name="Methods"></a>

##### `toGibibytes` <a name="cdk8s.Size.toGibibytes"></a>

```typescript
public toGibibytes(opts?: SizeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Size.parameter.opts"></a>

- *Type:* [`cdk8s.SizeConversionOptions`](#cdk8s.SizeConversionOptions)

---

##### `toKibibytes` <a name="cdk8s.Size.toKibibytes"></a>

```typescript
public toKibibytes(opts?: SizeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Size.parameter.opts"></a>

- *Type:* [`cdk8s.SizeConversionOptions`](#cdk8s.SizeConversionOptions)

---

##### `toMebibytes` <a name="cdk8s.Size.toMebibytes"></a>

```typescript
public toMebibytes(opts?: SizeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Size.parameter.opts"></a>

- *Type:* [`cdk8s.SizeConversionOptions`](#cdk8s.SizeConversionOptions)

---

##### `toPebibytes` <a name="cdk8s.Size.toPebibytes"></a>

```typescript
public toPebibytes(opts?: SizeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Size.parameter.opts"></a>

- *Type:* [`cdk8s.SizeConversionOptions`](#cdk8s.SizeConversionOptions)

---

##### `toTebibytes` <a name="cdk8s.Size.toTebibytes"></a>

```typescript
public toTebibytes(opts?: SizeConversionOptions)
```

###### `opts`<sup>Optional</sup> <a name="cdk8s.Size.parameter.opts"></a>

- *Type:* [`cdk8s.SizeConversionOptions`](#cdk8s.SizeConversionOptions)

---

#### Static Functions <a name="Static Functions"></a>

##### `gibibytes` <a name="cdk8s.Size.gibibytes"></a>

```typescript
import { Size } from 'cdk8s'

Size.gibibytes(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `number`

---

##### `kibibytes` <a name="cdk8s.Size.kibibytes"></a>

```typescript
import { Size } from 'cdk8s'

Size.kibibytes(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `number`

---

##### `mebibytes` <a name="cdk8s.Size.mebibytes"></a>

```typescript
import { Size } from 'cdk8s'

Size.mebibytes(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `number`

---

##### `pebibyte` <a name="cdk8s.Size.pebibyte"></a>

```typescript
import { Size } from 'cdk8s'

Size.pebibyte(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `number`

---

##### `tebibytes` <a name="cdk8s.Size.tebibytes"></a>

```typescript
import { Size } from 'cdk8s'

Size.tebibytes(amount: number)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `number`

---



### Testing <a name="cdk8s.Testing"></a>

Testing utilities for cdk8s applications.


#### Static Functions <a name="Static Functions"></a>

##### `app` <a name="cdk8s.Testing.app"></a>

```typescript
import { Testing } from 'cdk8s'

Testing.app(props?: AppProps)
```

###### `props`<sup>Optional</sup> <a name="cdk8s.Testing.parameter.props"></a>

- *Type:* [`cdk8s.AppProps`](#cdk8s.AppProps)

---

##### `chart` <a name="cdk8s.Testing.chart"></a>

```typescript
import { Testing } from 'cdk8s'

Testing.chart()
```

##### `synth` <a name="cdk8s.Testing.synth"></a>

```typescript
import { Testing } from 'cdk8s'

Testing.synth(chart: Chart)
```

###### `chart`<sup>Required</sup> <a name="cdk8s.Testing.parameter.chart"></a>

- *Type:* [`cdk8s.Chart`](#cdk8s.Chart)

---



### Yaml <a name="cdk8s.Yaml"></a>

YAML utilities.


#### Static Functions <a name="Static Functions"></a>

##### ~~`formatObjects`~~ <a name="cdk8s.Yaml.formatObjects"></a>

```typescript
import { Yaml } from 'cdk8s'

Yaml.formatObjects(docs: any[])
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* `any`[]

---

##### `load` <a name="cdk8s.Yaml.load"></a>

```typescript
import { Yaml } from 'cdk8s'

Yaml.load(urlOrFile: string)
```

###### `urlOrFile`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.urlOrFile"></a>

- *Type:* `string`

a URL of a file path to load from.

---

##### `save` <a name="cdk8s.Yaml.save"></a>

```typescript
import { Yaml } from 'cdk8s'

Yaml.save(filePath: string, docs: any[])
```

###### `filePath`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.filePath"></a>

- *Type:* `string`

The output path.

---

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* `any`[]

The set of objects.

---

##### `stringify` <a name="cdk8s.Yaml.stringify"></a>

```typescript
import { Yaml } from 'cdk8s'

Yaml.stringify(docs: any)
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* `any`

A set of objects to convert to YAML.

---

##### `tmp` <a name="cdk8s.Yaml.tmp"></a>

```typescript
import { Yaml } from 'cdk8s'

Yaml.tmp(docs: any[])
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* `any`[]

the set of documents to save.

---



## Protocols <a name="Protocols"></a>

### IAnyProducer <a name="cdk8s.IAnyProducer"></a>

- *Implemented By:* [`cdk8s.IAnyProducer`](#cdk8s.IAnyProducer)

#### Methods <a name="Methods"></a>

##### `produce` <a name="cdk8s.IAnyProducer.produce"></a>

```typescript
public produce()
```


## Enums <a name="Enums"></a>

### SizeRoundingBehavior <a name="SizeRoundingBehavior"></a>

Rounding behaviour when converting between units of `Size`.

#### `FAIL` <a name="cdk8s.SizeRoundingBehavior.FAIL"></a>

Fail the conversion if the result is not an integer.

---


#### `FLOOR` <a name="cdk8s.SizeRoundingBehavior.FLOOR"></a>

If the result is not an integer, round it to the closest integer less than the result.

---


#### `NONE` <a name="cdk8s.SizeRoundingBehavior.NONE"></a>

Don't round.

Return even if the result is a fraction.

---


### YamlOutputType <a name="YamlOutputType"></a>

The method to divide YAML output into files.

#### `FILE_PER_APP` <a name="cdk8s.YamlOutputType.FILE_PER_APP"></a>

All resources are output into a single YAML file.

---


#### `FILE_PER_CHART` <a name="cdk8s.YamlOutputType.FILE_PER_CHART"></a>

Resources are split into seperate files by chart.

---


#### `FILE_PER_RESOURCE` <a name="cdk8s.YamlOutputType.FILE_PER_RESOURCE"></a>

Each resource is output to its own file.

---


#### `FOLDER_PER_CHART_FILE_PER_RESOURCE` <a name="cdk8s.YamlOutputType.FOLDER_PER_CHART_FILE_PER_RESOURCE"></a>

Each chart in its own folder and each resource in its own file.

---

