# -*- coding: utf-8 -*-
#
# PYME documentation build configuration file, created by
# sphinx-quickstart on Fri Oct 29 10:45:44 2010.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os

import mock
import numpy

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.append(os.path.abspath('..'))
import PYME.version
 
#MOCK_MODULES = ['numpy', 'tables', 'scipy', 'scipy.interpolate', 'scipy.special', 'scipy.io', 
#				'scipy.cow', 'scipy.fftpack', 'scipy.ndimage', 'scipy.linalg', 'scipy.spatial',
#				'scipy.misc', 'pylab', 'win32api', ]
#MOCK_MODULES += ['matplotlib', 'matplotlib.pyplot', 'matplotlib.colors', 'fftw3f', 'pywinusb']
#for mod_name in MOCK_MODULES:
#    sys.modules[mod_name] = mock.Mock()

#traitsui causes lots of crashes when imported without a GUI. Circumvent it by 
from PYME.misc import mock_traitsui
sys.modules['traitsui'] = mock.Mock()
sys.modules['traitsui.api'] = mock_traitsui
sys.modules['traitsui.wx'] = mock.Mock()
sys.modules['traitsui.wx.editor'] = mock.Mock()
sys.modules['traitsui.basic_editor_factory'] = mock.Mock()

from PYME.misc import mock_traits
sys.modules['traits.api'] = mock_traits
sys.modules['traits']  = mock.Mock()

from PYME.misc import mock_ctypes
sys.modules['ctypes'] = mock_ctypes

sys.modules['six']  = mock.Mock()
sys.modules['six.moves']  = mock.Mock()

sys.modules['Cython'] = mock.Mock()
sys.modules['Cython.Build'] = mock.Mock()

sys.modules['notebook'] = mock.Mock()
sys.modules['neuroglancer'] = mock.Mock()

#PIL imports
sys.modules['Image'] = mock.Mock()
sys.modules['ImageFile'] = mock.Mock()
sys.modules['ImagePalette'] = mock.Mock()
sys.modules['PIL'] = mock.Mock()

sys.modules['skimage'] = mock.Mock()
sys.modules['pyfftw'] = mock.Mock()
sys.modules['quaternion'] = mock.Mock()
    
sys.modules['wx'] = mock.MagicMock()
sys.modules['wx.aui'] = mock.Mock()
sys.modules['wx.lib'] = mock.Mock()
sys.modules['wx.stc'] = mock.Mock()
sys.modules['wx.core'] = mock.Mock()
sys.modules['wx.lib.newevent'] = mock.Mock()
sys.modules['wx.lib.mixins'] = mock.MagicMock()
sys.modules['wx.lib.mixins.listctrl'] = mock.Mock()
sys.modules['wx.lib.mixins.treemixin'] = mock.Mock()
sys.modules['wx.lib.dialogs'] = mock.Mock()
sys.modules['wx.lib.agw'] = mock.Mock()
sys.modules['wx.lib.agw.aui'] = mock.Mock()
sys.modules['wx.lib.agw.cubecolourdialog'] = mock.Mock()
sys.modules['wx.lib.scrolledpanel'] = mock.Mock()
sys.modules['wx.gizmos'] = mock.Mock()
sys.modules['wx.grid'] = mock.Mock()
sys.modules['wx.html2'] = mock.Mock()
sys.modules['wx.html'] = mock.Mock()
sys.modules['wx.lib.agw.aui.aui_utilities'] = mock.Mock()
sys.modules['wx.py.shell'] = mock.Mock()
sys.modules['wx.glcanvas'] = mock.Mock()

sys.modules['OpenGL'] = mock.Mock()
sys.modules['OpenGL.GL'] = mock.Mock()
sys.modules['OpenGL.GLU'] = mock.Mock()

sys.modules['scipy'] = mock.Mock()
sys.modules['scipy.ndimage'] = mock.Mock()
sys.modules['scipy.ndimage.interpolation'] = mock.Mock()
sys.modules['scipy.fftpack'] = mock.Mock()
sys.modules['scipy.optimize'] = mock.Mock()
sys.modules['scipy.signal'] = mock.Mock()
sys.modules['scipy.spatial'] = mock.Mock()
sys.modules['scipy.interpolate'] = mock.Mock()
sys.modules['scipy.special'] = mock.Mock()
sys.modules['scipy.stats'] = mock.Mock()
sys.modules['scipy.misc'] = mock.Mock()
sys.modules['scipy.integrate'] = mock.Mock()
sys.modules['scipy.linalg'] = mock.Mock()

sys.modules['skimage.filters'] = mock.Mock()
sys.modules['skimage.measure'] = mock.Mock()
sys.modules['sklearn'] = mock.Mock()

sys.modules['matplotlib'] = mock.MagicMock()
sys.modules['matplotlib.cm'] = mock.Mock()
sys.modules['matplotlib.colors'] = mock.Mock()
sys.modules['matplotlib.figure'] = mock.Mock()
sys.modules['matplotlib.backends'] = mock.Mock()
sys.modules['matplotlib.backends.backend_wxagg'] = mock.Mock()
sys.modules['matplotlib.backends.backend_wx'] = mock.Mock()
sys.modules['matplotlib.backend_bases'] = mock.Mock()

sys.modules['tables'] = mock.Mock()
sys.modules['yaml'] = mock.Mock()
sys.modules['toposort'] = mock.Mock()
sys.modules['matplotlib.pyplot'] = mock.Mock()
#sys.modules['matplotlib.colormaps'] = {}
sys.modules['cherrypy'] = mock.Mock()
sys.modules['pandas'] = mock.Mock()
sys.modules['zeroconf'] = mock.Mock()
sys.modules['zeroconf'].__version__ = '0.35'

sys.modules['tornado'] = mock.Mock()
sys.modules['tornado.web'] = mock.Mock()
sys.modules['tornado.ioloop'] = mock.Mock()
sys.modules['jwt'] = mock.Mock()
sys.modules['terminado'] = mock.Mock()
#sys.modules['neuroglancer'] = mock.Mock()

sys.modules['django'] = mock.Mock()
sys.modules['django.utils'] = mock.Mock()
sys.modules['django.utils.encoding'] = mock.Mock()
sys.modules['django.utils.html'] = mock.Mock()
sys.modules['django.forms'] = mock.Mock()
sys.modules['django.forms.widgets'] = mock.Mock()
sys.modules['django.forms.utils'] = mock.Mock()
sys.modules['pandas'] = mock.Mock()

sys.modules['Pyro'] = mock.Mock() # TODO - expunge pyro??
sys.modules['Pyro.core'] = mock.Mock()
sys.modules['Pyro.util'] = mock.Mock()
sys.modules['Pyro.constants'] = mock.Mock()

sys.modules['ujson'] = mock.Mock()
sys.modules['dask'] = mock.Mock()
sys.modules['dask.array'] = mock.Mock()
sys.modules['javabridge'] = mock.Mock()
sys.modules['bioformats'] = mock.Mock()
sys.modules['mayavi'] = mock.Mock()
sys.modules['fftw3f'] = mock.Mock()
sys.modules['jigna'] = mock.Mock()
sys.modules['jigna.web_app'] = mock.Mock()
sys.modules['jigna.vue_template'] = mock.Mock()
sys.modules['MySQLdb'] = mock.Mock()
sys.modules['guppy'] = mock.Mock()
sys.modules['apt'] = mock.Mock()
sys.modules['gflags'] = mock.Mock()
sys.modules['tweepy'] = mock.Mock()

sys.modules['PYME.contrib.TextCtrlAutoComplete'] = mock.Mock()

import wx
import wx.gizmos
import wx.lib.mixins.listctrl
import wx.lib.agw.aui
#import wx.py.shell
#from wx.lib.agw.aui.aui_utilities import BitmapFromBits

class mClass(object):
    pass
class mClass1(object):
  pass
class mClass2(object):
  pass

wx.Frame = mClass
wx.Panel = mClass
wx.Dialog = mClass
wx.ListCtrl = mClass
wx.gizmos.TreeListCtrl = mClass1
wx.lib.mixins.listctrl.ListCtrlAutoWidthMixin = mClass2
wx.lib.agw.aui.AuiToolBar = mClass1

import wx.lib.newevent
wx.lib.newevent.NewCommandEvent = lambda : (None,None)

#import matplotlib
#matplotlib.colormaps = {}
import matplotlib.cm
matplotlib.cm.cmapnames = []
import matplotlib.backend_bases
matplotlib.backend_bases.NavigationToolbar2 = mClass2


# -- General configuration -----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.doctest', 'sphinx.ext.todo', 'sphinx.ext.coverage', 'sphinx.ext.mathjax', 'sphinx.ext.autosummary', 'numpydoc'] # 'sphinx.ext.napoleon']#,

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'PYME'
copyright = u'2020, PYME Developer Community'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = PYME.version.version #'0.1'
# The full version, including alpha/beta/rc tags.
release = PYME.version.version #'0.1'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['_build', '_hidden']#, 'api']
exclude_patterns = ['_build/*', '_hidden/*']#, 'api/*']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

numfig=True

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

numpydoc_show_class_members = False #True
numpydoc_show_inherited_class_members = False
class_members_toctree=False
autoclass_content = 'both'

todo_include_todos = True


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
#html_theme = 'sphinxdoc'#'default'
html_theme = 'sphinx_rtd_theme'#'default'


# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = '../PYME/resources/icons/pymeLogo.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

#html_context = {
#    'css_files': [
#      '_static/theme_overrides.css', # override wide tables in RTD theme
#    ],
#}

html_css_files = ["_static/theme_overrides.css"]  # override wide tables in RTD theme

# If false, no module index is generated.
html_use_modindex = True

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'PYMEdoc'


# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'PYME.tex', u'PYME Documentation',
   u'David Baddeley', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True
