# Tutorial

Welcome to the comprehensive CREDTOOLS (Credible Set Tools) tutorial! This guide will walk you through using CREDTOOLS for genetic fine-mapping analysis across different ancestries and cohorts.

## Tutorial Structure

1. **[Getting Started](tutorial/getting-started.md)** - Learn what CREDTOOLS can do and its overall framework
2. **[Quick Start](tutorial/quick-start.md)** - Jump right in with the `credtools pipeline` command
3. **[Single Input](tutorial/single-input.md)** - Fine-map a single study
4. **[Multi Input](tutorial/multi-input.md)** - Combine multiple studies
5. **[Advanced Topics](tutorial/advanced.md)** - Custom workflows and optimization

## Prerequisites

- CREDTOOLS installed (see [Installation](installation.md))
- Basic understanding of fine-mapping concepts
- Python 3.9 or higher

## Example Data

Throughout this tutorial, we'll use example datasets included with CREDTOOLS. You can find them in the `exampledata/` directory after installation.


## Navigation

Use the navigation menu on the left to jump between sections, or follow the tutorial sequentially using the "Next" links at the bottom of each page.

Let's get started! 👉 [Getting Started](tutorial/getting-started.md) 