# Contributing to LouieAI Python Library

Thank you for your interest in contributing! We're excited to work with you to make LouieAI better.

## Welcome!

Whether you're fixing a bug, adding a feature, or improving documentation, every contribution matters. This guide will help you understand our process and community.

**For technical setup and development details, see [DEVELOP.md](DEVELOP.md).**

## Getting Started

1. **Check existing issues** - See if someone's already working on it
2. **Fork the repository** - Create your own copy
3. **Set up your environment** - See [DEVELOP.md](DEVELOP.md) for details
4. **Make your changes** - Follow our patterns and style
5. **Submit a PR** - We'll review and provide feedback

## Developer Certificate of Origin

We use the DCO to ensure all contributions can be legally included. Simply add a sign-off to your commits:

```bash
git commit -s -m "Your commit message"
```

This adds `Signed-off-by: Your Name <email>` to your commit. No paperwork required!

[Learn more about DCO](https://developercertificate.org/)

## Types of Contributions

### 🐛 Bug Reports
- Check if the bug is already reported
- Include minimal reproduction steps
- Share your environment details
- Be patient - we're a small team!

### ✨ Feature Requests
- Open an issue to discuss first
- Explain the use case, not just the solution
- Be open to alternative approaches
- Consider starting with a smaller scope

### 🔧 Code Contributions
- **Features**: Open issue → Discuss → Implement → PR
- **Bugs**: Reproduce → Fix with tests → PR
- **Refactoring**: Discuss first in an issue
- See [DEVELOP.md](DEVELOP.md) for technical workflow

### 📚 Documentation
- Fix typos and clarify confusing sections
- Add examples from your experience
- Improve getting started guides
- Share your integration stories

## What to Expect

### Response Times
- First response: Within 3 business days
- Review iterations: Best effort, usually 1-2 days
- Merge decision: After CI passes and review complete

### Review Process
- Automated checks run first (tests, linting)
- Human review focuses on design and usability
- We may suggest changes or alternatives
- All feedback is meant to improve the project

### After Your PR is Merged
- We'll include you in release notes
- Your contribution helps the entire community
- Consider tackling another issue!

## Making a Good PR

### Title: Be Clear and Specific
- ✅ `fix: handle JWT token expiration correctly`
- ❌ `fix bug`
- ✅ `feat: add retry logic for network errors`
- ❌ `update client.py`

### Description: Tell a Story
1. **What** changed and **why**
2. **How** you tested it
3. **What** issue it closes (if any)

Don't worry about being perfect - we'll help you improve it!

## Community Values

### We Strive To:
- **Be welcoming**: Everyone was new once
- **Be helpful**: Share knowledge generously
- **Be patient**: Good things take time
- **Be respectful**: Diverse perspectives make us stronger

### Code of Conduct
We follow our [Code of Conduct](CODE_OF_CONDUCT.md). Please read it.

## Where to Get Help

### 🤔 Questions?
- Check our [documentation](https://louieai.readthedocs.io)
- Search existing [issues](https://github.com/graphistry/louie-py/issues)
- Open a [discussion](https://github.com/graphistry/louie-py/discussions)

### 🔧 Technical Setup?
- See [DEVELOP.md](DEVELOP.md) for detailed instructions
- Check [troubleshooting guide](https://louieai.readthedocs.io/en/latest/troubleshooting/)
- Ask in discussions - we're here to help!

### 🔒 Security Issues?
- See [SECURITY.md](SECURITY.md) for reporting process
- Do not open public issues for security vulnerabilities

## Recognition

### All Contributors Are Valued! 
We appreciate:
- 🐛 Bug reporters who help us improve
- 💡 Idea contributors who shape our direction
- 🔨 Code contributors who build features
- 📚 Documentation writers who help others
- 💬 Community members who answer questions

Your contributions will be included in release notes!

## Using AI Tools (Optional)

We sometimes use AI assistants for development. If you're interested, check out `ai/templates/PLAN.md` for our approach. It's completely optional!

---

**Ready to start?** Check [DEVELOP.md](DEVELOP.md) for setup, pick an issue, and let's build something great together! 🚀