# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InternalUserArgs', 'InternalUser']

@pulumi.input_type
class InternalUserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[_builtins.str],
                 account_name_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_password: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_id_store: Optional[pulumi.Input[_builtins.str]] = None,
                 password_never_expires: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a InternalUser resource.
        :param pulumi.Input[_builtins.str] password: The password of the internal user
        :param pulumi.Input[_builtins.str] account_name_alias: The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        :param pulumi.Input[_builtins.bool] change_password: Requires the user to change the password
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] custom_attributes: Key value map
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] email: Email address
        :param pulumi.Input[_builtins.str] enable_password: This field is added in ISE 2.0 to support TACACS+
        :param pulumi.Input[_builtins.bool] enabled: Whether the user is enabled/disabled
        :param pulumi.Input[_builtins.str] first_name: First name of the internal user
        :param pulumi.Input[_builtins.str] identity_groups: Comma separated list of identity group IDs.
        :param pulumi.Input[_builtins.str] last_name: Last name of the internal user
        :param pulumi.Input[_builtins.str] name: The name of the internal user
        :param pulumi.Input[_builtins.str] password_id_store: The ID store where the internal user's password is kept
                 - Default value: `Internal Users`
        :param pulumi.Input[_builtins.bool] password_never_expires: Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
                 - Default value: `false`
        """
        pulumi.set(__self__, "password", password)
        if account_name_alias is not None:
            pulumi.set(__self__, "account_name_alias", account_name_alias)
        if change_password is not None:
            pulumi.set(__self__, "change_password", change_password)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enable_password is not None:
            pulumi.set(__self__, "enable_password", enable_password)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if identity_groups is not None:
            pulumi.set(__self__, "identity_groups", identity_groups)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_id_store is not None:
            pulumi.set(__self__, "password_id_store", password_id_store)
        if password_never_expires is not None:
            pulumi.set(__self__, "password_never_expires", password_never_expires)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the internal user
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="accountNameAlias")
    def account_name_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        """
        return pulumi.get(self, "account_name_alias")

    @account_name_alias.setter
    def account_name_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_alias", value)

    @_builtins.property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Requires the user to change the password
          - Default value: `true`
        """
        return pulumi.get(self, "change_password")

    @change_password.setter
    def change_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "change_password", value)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key value map
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enablePassword")
    def enable_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is added in ISE 2.0 to support TACACS+
        """
        return pulumi.get(self, "enable_password")

    @enable_password.setter
    def enable_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_password", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user is enabled/disabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        First name of the internal user
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="identityGroups")
    def identity_groups(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of identity group IDs.
        """
        return pulumi.get(self, "identity_groups")

    @identity_groups.setter
    def identity_groups(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_groups", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last name of the internal user
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the internal user
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="passwordIdStore")
    def password_id_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID store where the internal user's password is kept
          - Default value: `Internal Users`
        """
        return pulumi.get(self, "password_id_store")

    @password_id_store.setter
    def password_id_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_id_store", value)

    @_builtins.property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
          - Default value: `false`
        """
        return pulumi.get(self, "password_never_expires")

    @password_never_expires.setter
    def password_never_expires(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_never_expires", value)


@pulumi.input_type
class _InternalUserState:
    def __init__(__self__, *,
                 account_name_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_password: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_id_store: Optional[pulumi.Input[_builtins.str]] = None,
                 password_never_expires: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering InternalUser resources.
        :param pulumi.Input[_builtins.str] account_name_alias: The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        :param pulumi.Input[_builtins.bool] change_password: Requires the user to change the password
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] custom_attributes: Key value map
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] email: Email address
        :param pulumi.Input[_builtins.str] enable_password: This field is added in ISE 2.0 to support TACACS+
        :param pulumi.Input[_builtins.bool] enabled: Whether the user is enabled/disabled
        :param pulumi.Input[_builtins.str] first_name: First name of the internal user
        :param pulumi.Input[_builtins.str] identity_groups: Comma separated list of identity group IDs.
        :param pulumi.Input[_builtins.str] last_name: Last name of the internal user
        :param pulumi.Input[_builtins.str] name: The name of the internal user
        :param pulumi.Input[_builtins.str] password: The password of the internal user
        :param pulumi.Input[_builtins.str] password_id_store: The ID store where the internal user's password is kept
                 - Default value: `Internal Users`
        :param pulumi.Input[_builtins.bool] password_never_expires: Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
                 - Default value: `false`
        """
        if account_name_alias is not None:
            pulumi.set(__self__, "account_name_alias", account_name_alias)
        if change_password is not None:
            pulumi.set(__self__, "change_password", change_password)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enable_password is not None:
            pulumi.set(__self__, "enable_password", enable_password)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if identity_groups is not None:
            pulumi.set(__self__, "identity_groups", identity_groups)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_id_store is not None:
            pulumi.set(__self__, "password_id_store", password_id_store)
        if password_never_expires is not None:
            pulumi.set(__self__, "password_never_expires", password_never_expires)

    @_builtins.property
    @pulumi.getter(name="accountNameAlias")
    def account_name_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        """
        return pulumi.get(self, "account_name_alias")

    @account_name_alias.setter
    def account_name_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_alias", value)

    @_builtins.property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Requires the user to change the password
          - Default value: `true`
        """
        return pulumi.get(self, "change_password")

    @change_password.setter
    def change_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "change_password", value)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key value map
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enablePassword")
    def enable_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is added in ISE 2.0 to support TACACS+
        """
        return pulumi.get(self, "enable_password")

    @enable_password.setter
    def enable_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_password", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user is enabled/disabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        First name of the internal user
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="identityGroups")
    def identity_groups(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of identity group IDs.
        """
        return pulumi.get(self, "identity_groups")

    @identity_groups.setter
    def identity_groups(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_groups", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last name of the internal user
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the internal user
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the internal user
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordIdStore")
    def password_id_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID store where the internal user's password is kept
          - Default value: `Internal Users`
        """
        return pulumi.get(self, "password_id_store")

    @password_id_store.setter
    def password_id_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_id_store", value)

    @_builtins.property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
          - Default value: `false`
        """
        return pulumi.get(self, "password_never_expires")

    @password_never_expires.setter
    def password_never_expires(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_never_expires", value)


@pulumi.type_token("ise:identitymanagement/internalUser:InternalUser")
class InternalUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_password: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_id_store: Optional[pulumi.Input[_builtins.str]] = None,
                 password_never_expires: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage an Internal User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.InternalUser("example",
            name="UserTF",
            password="Cisco123",
            change_password=True,
            email="aaa@cisco.com",
            account_name_alias="User 1",
            enable_password="Cisco123",
            enabled=True,
            password_never_expires=False,
            first_name="John",
            last_name="Doe",
            password_id_store="Internal Users",
            description="My first Terraform user")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/internalUser:InternalUser example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name_alias: The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        :param pulumi.Input[_builtins.bool] change_password: Requires the user to change the password
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] custom_attributes: Key value map
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] email: Email address
        :param pulumi.Input[_builtins.str] enable_password: This field is added in ISE 2.0 to support TACACS+
        :param pulumi.Input[_builtins.bool] enabled: Whether the user is enabled/disabled
        :param pulumi.Input[_builtins.str] first_name: First name of the internal user
        :param pulumi.Input[_builtins.str] identity_groups: Comma separated list of identity group IDs.
        :param pulumi.Input[_builtins.str] last_name: Last name of the internal user
        :param pulumi.Input[_builtins.str] name: The name of the internal user
        :param pulumi.Input[_builtins.str] password: The password of the internal user
        :param pulumi.Input[_builtins.str] password_id_store: The ID store where the internal user's password is kept
                 - Default value: `Internal Users`
        :param pulumi.Input[_builtins.bool] password_never_expires: Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
                 - Default value: `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InternalUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage an Internal User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.InternalUser("example",
            name="UserTF",
            password="Cisco123",
            change_password=True,
            email="aaa@cisco.com",
            account_name_alias="User 1",
            enable_password="Cisco123",
            enabled=True,
            password_never_expires=False,
            first_name="John",
            last_name="Doe",
            password_id_store="Internal Users",
            description="My first Terraform user")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/internalUser:InternalUser example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param InternalUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InternalUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_password: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_id_store: Optional[pulumi.Input[_builtins.str]] = None,
                 password_never_expires: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InternalUserArgs.__new__(InternalUserArgs)

            __props__.__dict__["account_name_alias"] = account_name_alias
            __props__.__dict__["change_password"] = change_password
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["enable_password"] = enable_password
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["identity_groups"] = identity_groups
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["password_id_store"] = password_id_store
            __props__.__dict__["password_never_expires"] = password_never_expires
        super(InternalUser, __self__).__init__(
            'ise:identitymanagement/internalUser:InternalUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name_alias: Optional[pulumi.Input[_builtins.str]] = None,
            change_password: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            enable_password: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity_groups: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_id_store: Optional[pulumi.Input[_builtins.str]] = None,
            password_never_expires: Optional[pulumi.Input[_builtins.bool]] = None) -> 'InternalUser':
        """
        Get an existing InternalUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name_alias: The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        :param pulumi.Input[_builtins.bool] change_password: Requires the user to change the password
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] custom_attributes: Key value map
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] email: Email address
        :param pulumi.Input[_builtins.str] enable_password: This field is added in ISE 2.0 to support TACACS+
        :param pulumi.Input[_builtins.bool] enabled: Whether the user is enabled/disabled
        :param pulumi.Input[_builtins.str] first_name: First name of the internal user
        :param pulumi.Input[_builtins.str] identity_groups: Comma separated list of identity group IDs.
        :param pulumi.Input[_builtins.str] last_name: Last name of the internal user
        :param pulumi.Input[_builtins.str] name: The name of the internal user
        :param pulumi.Input[_builtins.str] password: The password of the internal user
        :param pulumi.Input[_builtins.str] password_id_store: The ID store where the internal user's password is kept
                 - Default value: `Internal Users`
        :param pulumi.Input[_builtins.bool] password_never_expires: Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
                 - Default value: `false`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InternalUserState.__new__(_InternalUserState)

        __props__.__dict__["account_name_alias"] = account_name_alias
        __props__.__dict__["change_password"] = change_password
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["enable_password"] = enable_password
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["identity_groups"] = identity_groups
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["password_id_store"] = password_id_store
        __props__.__dict__["password_never_expires"] = password_never_expires
        return InternalUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountNameAlias")
    def account_name_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Account Name Alias will be used to send email notifications about password expiration. This field is only supported from ISE 3.2.
        """
        return pulumi.get(self, "account_name_alias")

    @_builtins.property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> pulumi.Output[_builtins.bool]:
        """
        Requires the user to change the password
          - Default value: `true`
        """
        return pulumi.get(self, "change_password")

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key value map
        """
        return pulumi.get(self, "custom_attributes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email address
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="enablePassword")
    def enable_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This field is added in ISE 2.0 to support TACACS+
        """
        return pulumi.get(self, "enable_password")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the user is enabled/disabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        First name of the internal user
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="identityGroups")
    def identity_groups(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comma separated list of identity group IDs.
        """
        return pulumi.get(self, "identity_groups")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Last name of the internal user
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the internal user
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the internal user
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordIdStore")
    def password_id_store(self) -> pulumi.Output[_builtins.str]:
        """
        The ID store where the internal user's password is kept
          - Default value: `Internal Users`
        """
        return pulumi.get(self, "password_id_store")

    @_builtins.property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to `true` to indicate the user password never expires. This will not apply to Users who are also ISE Admins. This field is only supported from ISE 3.2.
          - Default value: `false`
        """
        return pulumi.get(self, "password_never_expires")

