# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurityGroupAclArgs', 'SecurityGroupAcl']

@pulumi.input_type
class SecurityGroupAclArgs:
    def __init__(__self__, *,
                 acl_content: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SecurityGroupAcl resource.
        :param pulumi.Input[_builtins.str] acl_content: Content of ACL
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] ip_version: IP Version
                 - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
                 - Default value: `IP_AGNOSTIC`
        :param pulumi.Input[_builtins.str] name: The name of the security group ACL
        :param pulumi.Input[_builtins.bool] read_only: Read-only
        """
        pulumi.set(__self__, "acl_content", acl_content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="aclContent")
    def acl_content(self) -> pulumi.Input[_builtins.str]:
        """
        Content of ACL
        """
        return pulumi.get(self, "acl_content")

    @acl_content.setter
    def acl_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP Version
          - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
          - Default value: `IP_AGNOSTIC`
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security group ACL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read-only
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class _SecurityGroupAclState:
    def __init__(__self__, *,
                 acl_content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SecurityGroupAcl resources.
        :param pulumi.Input[_builtins.str] acl_content: Content of ACL
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] ip_version: IP Version
                 - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
                 - Default value: `IP_AGNOSTIC`
        :param pulumi.Input[_builtins.str] name: The name of the security group ACL
        :param pulumi.Input[_builtins.bool] read_only: Read-only
        """
        if acl_content is not None:
            pulumi.set(__self__, "acl_content", acl_content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="aclContent")
    def acl_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content of ACL
        """
        return pulumi.get(self, "acl_content")

    @acl_content.setter
    def acl_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP Version
          - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
          - Default value: `IP_AGNOSTIC`
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security group ACL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read-only
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.type_token("ise:trustsec/securityGroupAcl:SecurityGroupAcl")
class SecurityGroupAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a TrustSec Security Group ACL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.SecurityGroupAcl("example",
            name="ACL1",
            description="SG ACL 1",
            acl_content="Permit IP",
            ip_version="IPV4",
            read_only=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/securityGroupAcl:SecurityGroupAcl example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_content: Content of ACL
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] ip_version: IP Version
                 - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
                 - Default value: `IP_AGNOSTIC`
        :param pulumi.Input[_builtins.str] name: The name of the security group ACL
        :param pulumi.Input[_builtins.bool] read_only: Read-only
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TrustSec Security Group ACL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.SecurityGroupAcl("example",
            name="ACL1",
            description="SG ACL 1",
            acl_content="Permit IP",
            ip_version="IPV4",
            read_only=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/securityGroupAcl:SecurityGroupAcl example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGroupAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupAclArgs.__new__(SecurityGroupAclArgs)

            if acl_content is None and not opts.urn:
                raise TypeError("Missing required property 'acl_content'")
            __props__.__dict__["acl_content"] = acl_content
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["name"] = name
            __props__.__dict__["read_only"] = read_only
        super(SecurityGroupAcl, __self__).__init__(
            'ise:trustsec/securityGroupAcl:SecurityGroupAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_content: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            read_only: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SecurityGroupAcl':
        """
        Get an existing SecurityGroupAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_content: Content of ACL
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] ip_version: IP Version
                 - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
                 - Default value: `IP_AGNOSTIC`
        :param pulumi.Input[_builtins.str] name: The name of the security group ACL
        :param pulumi.Input[_builtins.bool] read_only: Read-only
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupAclState.__new__(_SecurityGroupAclState)

        __props__.__dict__["acl_content"] = acl_content
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["name"] = name
        __props__.__dict__["read_only"] = read_only
        return SecurityGroupAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclContent")
    def acl_content(self) -> pulumi.Output[_builtins.str]:
        """
        Content of ACL
        """
        return pulumi.get(self, "acl_content")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        IP Version
          - Choices: `IPV4`, `IPV6`, `IP_AGNOSTIC`
          - Default value: `IP_AGNOSTIC`
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security group ACL
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Read-only
        """
        return pulumi.get(self, "read_only")

