# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 risk: pulumi.Input[_builtins.str],
                 able_to_transfer_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 alg_disable_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 consume_big_bandwidth: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 default: Optional[pulumi.Input['ApplicationDefaultArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive_behavior: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_type_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerability: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_appid_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 parent_app: Optional[pulumi.Input[_builtins.str]] = None,
                 pervasive_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategory: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_half_closed_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 technology: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tunnel_applications: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnel_other_application: Optional[pulumi.Input[_builtins.bool]] = None,
                 udp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 virus_ident: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[_builtins.str] category: Category
        :param pulumi.Input[_builtins.str] risk: Risk
        :param pulumi.Input[_builtins.bool] able_to_transfer_file: Able to transfer file
        :param pulumi.Input[_builtins.str] alg_disable_capability: Alg disable capability
        :param pulumi.Input[_builtins.bool] consume_big_bandwidth: Consume big bandwidth
        :param pulumi.Input[_builtins.bool] data_ident: Data ident
        :param pulumi.Input['ApplicationDefaultArgs'] default: Default
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive_behavior: Evasive behavior
        :param pulumi.Input[_builtins.bool] file_type_ident: File type ident
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerability: Has known vulnerability
        :param pulumi.Input[_builtins.str] name: The name of the application
        :param pulumi.Input[_builtins.bool] no_appid_caching: No appid caching
        :param pulumi.Input[_builtins.str] parent_app: Parent app
        :param pulumi.Input[_builtins.bool] pervasive_use: Pervasive use
        :param pulumi.Input[_builtins.bool] prone_to_misuse: Prone to misuse
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]] signatures: Signature
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subcategory: Subcategory
        :param pulumi.Input[_builtins.int] tcp_half_closed_timeout: timeout for half-close session in seconds
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout: timeout for session in time_wait state in seconds
        :param pulumi.Input[_builtins.int] tcp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.str] technology: Technology
        :param pulumi.Input[_builtins.int] timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] tunnel_applications: Tunnel applications
        :param pulumi.Input[_builtins.bool] tunnel_other_application: Tunnel other application
        :param pulumi.Input[_builtins.int] udp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] used_by_malware: Used by malware
        :param pulumi.Input[_builtins.bool] virus_ident: Virus ident
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "risk", risk)
        if able_to_transfer_file is not None:
            pulumi.set(__self__, "able_to_transfer_file", able_to_transfer_file)
        if alg_disable_capability is not None:
            pulumi.set(__self__, "alg_disable_capability", alg_disable_capability)
        if consume_big_bandwidth is not None:
            pulumi.set(__self__, "consume_big_bandwidth", consume_big_bandwidth)
        if data_ident is not None:
            pulumi.set(__self__, "data_ident", data_ident)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if evasive_behavior is not None:
            pulumi.set(__self__, "evasive_behavior", evasive_behavior)
        if file_type_ident is not None:
            pulumi.set(__self__, "file_type_ident", file_type_ident)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if has_known_vulnerability is not None:
            pulumi.set(__self__, "has_known_vulnerability", has_known_vulnerability)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_appid_caching is not None:
            pulumi.set(__self__, "no_appid_caching", no_appid_caching)
        if parent_app is not None:
            pulumi.set(__self__, "parent_app", parent_app)
        if pervasive_use is not None:
            pulumi.set(__self__, "pervasive_use", pervasive_use)
        if prone_to_misuse is not None:
            pulumi.set(__self__, "prone_to_misuse", prone_to_misuse)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subcategory is not None:
            pulumi.set(__self__, "subcategory", subcategory)
        if tcp_half_closed_timeout is not None:
            pulumi.set(__self__, "tcp_half_closed_timeout", tcp_half_closed_timeout)
        if tcp_time_wait_timeout is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout", tcp_time_wait_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if technology is not None:
            pulumi.set(__self__, "technology", technology)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tunnel_applications is not None:
            pulumi.set(__self__, "tunnel_applications", tunnel_applications)
        if tunnel_other_application is not None:
            pulumi.set(__self__, "tunnel_other_application", tunnel_other_application)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)
        if used_by_malware is not None:
            pulumi.set(__self__, "used_by_malware", used_by_malware)
        if virus_ident is not None:
            pulumi.set(__self__, "virus_ident", virus_ident)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        Category
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def risk(self) -> pulumi.Input[_builtins.str]:
        """
        Risk
        """
        return pulumi.get(self, "risk")

    @risk.setter
    def risk(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "risk", value)

    @_builtins.property
    @pulumi.getter(name="ableToTransferFile")
    def able_to_transfer_file(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Able to transfer file
        """
        return pulumi.get(self, "able_to_transfer_file")

    @able_to_transfer_file.setter
    def able_to_transfer_file(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "able_to_transfer_file", value)

    @_builtins.property
    @pulumi.getter(name="algDisableCapability")
    def alg_disable_capability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alg disable capability
        """
        return pulumi.get(self, "alg_disable_capability")

    @alg_disable_capability.setter
    def alg_disable_capability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alg_disable_capability", value)

    @_builtins.property
    @pulumi.getter(name="consumeBigBandwidth")
    def consume_big_bandwidth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Consume big bandwidth
        """
        return pulumi.get(self, "consume_big_bandwidth")

    @consume_big_bandwidth.setter
    def consume_big_bandwidth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "consume_big_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="dataIdent")
    def data_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Data ident
        """
        return pulumi.get(self, "data_ident")

    @data_ident.setter
    def data_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_ident", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input['ApplicationDefaultArgs']]:
        """
        Default
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input['ApplicationDefaultArgs']]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="evasiveBehavior")
    def evasive_behavior(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Evasive behavior
        """
        return pulumi.get(self, "evasive_behavior")

    @evasive_behavior.setter
    def evasive_behavior(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "evasive_behavior", value)

    @_builtins.property
    @pulumi.getter(name="fileTypeIdent")
    def file_type_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        File type ident
        """
        return pulumi.get(self, "file_type_ident")

    @file_type_ident.setter
    def file_type_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "file_type_ident", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerability")
    def has_known_vulnerability(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Has known vulnerability
        """
        return pulumi.get(self, "has_known_vulnerability")

    @has_known_vulnerability.setter
    def has_known_vulnerability(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_known_vulnerability", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noAppidCaching")
    def no_appid_caching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        No appid caching
        """
        return pulumi.get(self, "no_appid_caching")

    @no_appid_caching.setter
    def no_appid_caching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_appid_caching", value)

    @_builtins.property
    @pulumi.getter(name="parentApp")
    def parent_app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent app
        """
        return pulumi.get(self, "parent_app")

    @parent_app.setter
    def parent_app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_app", value)

    @_builtins.property
    @pulumi.getter(name="pervasiveUse")
    def pervasive_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Pervasive use
        """
        return pulumi.get(self, "pervasive_use")

    @pervasive_use.setter
    def pervasive_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pervasive_use", value)

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prone to misuse
        """
        return pulumi.get(self, "prone_to_misuse")

    @prone_to_misuse.setter
    def prone_to_misuse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prone_to_misuse", value)

    @_builtins.property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]]:
        """
        Signature
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]]):
        pulumi.set(self, "signatures", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subcategory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategory")

    @subcategory.setter
    def subcategory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subcategory", value)

    @_builtins.property
    @pulumi.getter(name="tcpHalfClosedTimeout")
    def tcp_half_closed_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout for half-close session in seconds
        """
        return pulumi.get(self, "tcp_half_closed_timeout")

    @tcp_half_closed_timeout.setter
    def tcp_half_closed_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_half_closed_timeout", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeout")
    def tcp_time_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout for session in time_wait state in seconds
        """
        return pulumi.get(self, "tcp_time_wait_timeout")

    @tcp_time_wait_timeout.setter
    def tcp_time_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_time_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "tcp_timeout")

    @tcp_timeout.setter
    def tcp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_timeout", value)

    @_builtins.property
    @pulumi.getter
    def technology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Technology
        """
        return pulumi.get(self, "technology")

    @technology.setter
    def technology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "technology", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="tunnelApplications")
    def tunnel_applications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Tunnel applications
        """
        return pulumi.get(self, "tunnel_applications")

    @tunnel_applications.setter
    def tunnel_applications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnel_applications", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOtherApplication")
    def tunnel_other_application(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Tunnel other application
        """
        return pulumi.get(self, "tunnel_other_application")

    @tunnel_other_application.setter
    def tunnel_other_application(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnel_other_application", value)

    @_builtins.property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "udp_timeout")

    @udp_timeout.setter
    def udp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_timeout", value)

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used by malware
        """
        return pulumi.get(self, "used_by_malware")

    @used_by_malware.setter
    def used_by_malware(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_by_malware", value)

    @_builtins.property
    @pulumi.getter(name="virusIdent")
    def virus_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Virus ident
        """
        return pulumi.get(self, "virus_ident")

    @virus_ident.setter
    def virus_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virus_ident", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 able_to_transfer_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 alg_disable_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 consume_big_bandwidth: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 default: Optional[pulumi.Input['ApplicationDefaultArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive_behavior: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_type_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerability: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_appid_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 parent_app: Optional[pulumi.Input[_builtins.str]] = None,
                 pervasive_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risk: Optional[pulumi.Input[_builtins.str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategory: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_half_closed_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 technology: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tunnel_applications: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnel_other_application: Optional[pulumi.Input[_builtins.bool]] = None,
                 udp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 virus_ident: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[_builtins.bool] able_to_transfer_file: Able to transfer file
        :param pulumi.Input[_builtins.str] alg_disable_capability: Alg disable capability
        :param pulumi.Input[_builtins.str] category: Category
        :param pulumi.Input[_builtins.bool] consume_big_bandwidth: Consume big bandwidth
        :param pulumi.Input[_builtins.bool] data_ident: Data ident
        :param pulumi.Input['ApplicationDefaultArgs'] default: Default
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive_behavior: Evasive behavior
        :param pulumi.Input[_builtins.bool] file_type_ident: File type ident
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerability: Has known vulnerability
        :param pulumi.Input[_builtins.str] name: The name of the application
        :param pulumi.Input[_builtins.bool] no_appid_caching: No appid caching
        :param pulumi.Input[_builtins.str] parent_app: Parent app
        :param pulumi.Input[_builtins.bool] pervasive_use: Pervasive use
        :param pulumi.Input[_builtins.bool] prone_to_misuse: Prone to misuse
        :param pulumi.Input[_builtins.str] risk: Risk
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]] signatures: Signature
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subcategory: Subcategory
        :param pulumi.Input[_builtins.int] tcp_half_closed_timeout: timeout for half-close session in seconds
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout: timeout for session in time_wait state in seconds
        :param pulumi.Input[_builtins.int] tcp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.str] technology: Technology
        :param pulumi.Input[_builtins.int] timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] tunnel_applications: Tunnel applications
        :param pulumi.Input[_builtins.bool] tunnel_other_application: Tunnel other application
        :param pulumi.Input[_builtins.int] udp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] used_by_malware: Used by malware
        :param pulumi.Input[_builtins.bool] virus_ident: Virus ident
        """
        if able_to_transfer_file is not None:
            pulumi.set(__self__, "able_to_transfer_file", able_to_transfer_file)
        if alg_disable_capability is not None:
            pulumi.set(__self__, "alg_disable_capability", alg_disable_capability)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if consume_big_bandwidth is not None:
            pulumi.set(__self__, "consume_big_bandwidth", consume_big_bandwidth)
        if data_ident is not None:
            pulumi.set(__self__, "data_ident", data_ident)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if evasive_behavior is not None:
            pulumi.set(__self__, "evasive_behavior", evasive_behavior)
        if file_type_ident is not None:
            pulumi.set(__self__, "file_type_ident", file_type_ident)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if has_known_vulnerability is not None:
            pulumi.set(__self__, "has_known_vulnerability", has_known_vulnerability)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_appid_caching is not None:
            pulumi.set(__self__, "no_appid_caching", no_appid_caching)
        if parent_app is not None:
            pulumi.set(__self__, "parent_app", parent_app)
        if pervasive_use is not None:
            pulumi.set(__self__, "pervasive_use", pervasive_use)
        if prone_to_misuse is not None:
            pulumi.set(__self__, "prone_to_misuse", prone_to_misuse)
        if risk is not None:
            pulumi.set(__self__, "risk", risk)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subcategory is not None:
            pulumi.set(__self__, "subcategory", subcategory)
        if tcp_half_closed_timeout is not None:
            pulumi.set(__self__, "tcp_half_closed_timeout", tcp_half_closed_timeout)
        if tcp_time_wait_timeout is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout", tcp_time_wait_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if technology is not None:
            pulumi.set(__self__, "technology", technology)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tunnel_applications is not None:
            pulumi.set(__self__, "tunnel_applications", tunnel_applications)
        if tunnel_other_application is not None:
            pulumi.set(__self__, "tunnel_other_application", tunnel_other_application)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)
        if used_by_malware is not None:
            pulumi.set(__self__, "used_by_malware", used_by_malware)
        if virus_ident is not None:
            pulumi.set(__self__, "virus_ident", virus_ident)

    @_builtins.property
    @pulumi.getter(name="ableToTransferFile")
    def able_to_transfer_file(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Able to transfer file
        """
        return pulumi.get(self, "able_to_transfer_file")

    @able_to_transfer_file.setter
    def able_to_transfer_file(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "able_to_transfer_file", value)

    @_builtins.property
    @pulumi.getter(name="algDisableCapability")
    def alg_disable_capability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alg disable capability
        """
        return pulumi.get(self, "alg_disable_capability")

    @alg_disable_capability.setter
    def alg_disable_capability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alg_disable_capability", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Category
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="consumeBigBandwidth")
    def consume_big_bandwidth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Consume big bandwidth
        """
        return pulumi.get(self, "consume_big_bandwidth")

    @consume_big_bandwidth.setter
    def consume_big_bandwidth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "consume_big_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="dataIdent")
    def data_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Data ident
        """
        return pulumi.get(self, "data_ident")

    @data_ident.setter
    def data_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_ident", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input['ApplicationDefaultArgs']]:
        """
        Default
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input['ApplicationDefaultArgs']]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="evasiveBehavior")
    def evasive_behavior(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Evasive behavior
        """
        return pulumi.get(self, "evasive_behavior")

    @evasive_behavior.setter
    def evasive_behavior(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "evasive_behavior", value)

    @_builtins.property
    @pulumi.getter(name="fileTypeIdent")
    def file_type_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        File type ident
        """
        return pulumi.get(self, "file_type_ident")

    @file_type_ident.setter
    def file_type_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "file_type_ident", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerability")
    def has_known_vulnerability(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Has known vulnerability
        """
        return pulumi.get(self, "has_known_vulnerability")

    @has_known_vulnerability.setter
    def has_known_vulnerability(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_known_vulnerability", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noAppidCaching")
    def no_appid_caching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        No appid caching
        """
        return pulumi.get(self, "no_appid_caching")

    @no_appid_caching.setter
    def no_appid_caching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_appid_caching", value)

    @_builtins.property
    @pulumi.getter(name="parentApp")
    def parent_app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent app
        """
        return pulumi.get(self, "parent_app")

    @parent_app.setter
    def parent_app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_app", value)

    @_builtins.property
    @pulumi.getter(name="pervasiveUse")
    def pervasive_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Pervasive use
        """
        return pulumi.get(self, "pervasive_use")

    @pervasive_use.setter
    def pervasive_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pervasive_use", value)

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prone to misuse
        """
        return pulumi.get(self, "prone_to_misuse")

    @prone_to_misuse.setter
    def prone_to_misuse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prone_to_misuse", value)

    @_builtins.property
    @pulumi.getter
    def risk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Risk
        """
        return pulumi.get(self, "risk")

    @risk.setter
    def risk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "risk", value)

    @_builtins.property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]]:
        """
        Signature
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSignatureArgs']]]]):
        pulumi.set(self, "signatures", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subcategory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategory")

    @subcategory.setter
    def subcategory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subcategory", value)

    @_builtins.property
    @pulumi.getter(name="tcpHalfClosedTimeout")
    def tcp_half_closed_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout for half-close session in seconds
        """
        return pulumi.get(self, "tcp_half_closed_timeout")

    @tcp_half_closed_timeout.setter
    def tcp_half_closed_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_half_closed_timeout", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeout")
    def tcp_time_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout for session in time_wait state in seconds
        """
        return pulumi.get(self, "tcp_time_wait_timeout")

    @tcp_time_wait_timeout.setter
    def tcp_time_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_time_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "tcp_timeout")

    @tcp_timeout.setter
    def tcp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_timeout", value)

    @_builtins.property
    @pulumi.getter
    def technology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Technology
        """
        return pulumi.get(self, "technology")

    @technology.setter
    def technology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "technology", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="tunnelApplications")
    def tunnel_applications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Tunnel applications
        """
        return pulumi.get(self, "tunnel_applications")

    @tunnel_applications.setter
    def tunnel_applications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnel_applications", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOtherApplication")
    def tunnel_other_application(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Tunnel other application
        """
        return pulumi.get(self, "tunnel_other_application")

    @tunnel_other_application.setter
    def tunnel_other_application(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnel_other_application", value)

    @_builtins.property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "udp_timeout")

    @udp_timeout.setter
    def udp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_timeout", value)

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used by malware
        """
        return pulumi.get(self, "used_by_malware")

    @used_by_malware.setter
    def used_by_malware(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_by_malware", value)

    @_builtins.property
    @pulumi.getter(name="virusIdent")
    def virus_ident(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Virus ident
        """
        return pulumi.get(self, "virus_ident")

    @virus_ident.setter
    def virus_ident(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virus_ident", value)


@pulumi.type_token("scm:index/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 able_to_transfer_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 alg_disable_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 consume_big_bandwidth: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 default: Optional[pulumi.Input[Union['ApplicationDefaultArgs', 'ApplicationDefaultArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive_behavior: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_type_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerability: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_appid_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 parent_app: Optional[pulumi.Input[_builtins.str]] = None,
                 pervasive_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risk: Optional[pulumi.Input[_builtins.str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSignatureArgs', 'ApplicationSignatureArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategory: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_half_closed_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 technology: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tunnel_applications: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnel_other_application: Optional[pulumi.Input[_builtins.bool]] = None,
                 udp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 virus_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Application resource

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] able_to_transfer_file: Able to transfer file
        :param pulumi.Input[_builtins.str] alg_disable_capability: Alg disable capability
        :param pulumi.Input[_builtins.str] category: Category
        :param pulumi.Input[_builtins.bool] consume_big_bandwidth: Consume big bandwidth
        :param pulumi.Input[_builtins.bool] data_ident: Data ident
        :param pulumi.Input[Union['ApplicationDefaultArgs', 'ApplicationDefaultArgsDict']] default: Default
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive_behavior: Evasive behavior
        :param pulumi.Input[_builtins.bool] file_type_ident: File type ident
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerability: Has known vulnerability
        :param pulumi.Input[_builtins.str] name: The name of the application
        :param pulumi.Input[_builtins.bool] no_appid_caching: No appid caching
        :param pulumi.Input[_builtins.str] parent_app: Parent app
        :param pulumi.Input[_builtins.bool] pervasive_use: Pervasive use
        :param pulumi.Input[_builtins.bool] prone_to_misuse: Prone to misuse
        :param pulumi.Input[_builtins.str] risk: Risk
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSignatureArgs', 'ApplicationSignatureArgsDict']]]] signatures: Signature
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subcategory: Subcategory
        :param pulumi.Input[_builtins.int] tcp_half_closed_timeout: timeout for half-close session in seconds
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout: timeout for session in time_wait state in seconds
        :param pulumi.Input[_builtins.int] tcp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.str] technology: Technology
        :param pulumi.Input[_builtins.int] timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] tunnel_applications: Tunnel applications
        :param pulumi.Input[_builtins.bool] tunnel_other_application: Tunnel other application
        :param pulumi.Input[_builtins.int] udp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] used_by_malware: Used by malware
        :param pulumi.Input[_builtins.bool] virus_ident: Virus ident
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Application resource

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 able_to_transfer_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 alg_disable_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 consume_big_bandwidth: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 default: Optional[pulumi.Input[Union['ApplicationDefaultArgs', 'ApplicationDefaultArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive_behavior: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_type_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerability: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_appid_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 parent_app: Optional[pulumi.Input[_builtins.str]] = None,
                 pervasive_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risk: Optional[pulumi.Input[_builtins.str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSignatureArgs', 'ApplicationSignatureArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategory: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_half_closed_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 technology: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tunnel_applications: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnel_other_application: Optional[pulumi.Input[_builtins.bool]] = None,
                 udp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 virus_ident: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["able_to_transfer_file"] = able_to_transfer_file
            __props__.__dict__["alg_disable_capability"] = alg_disable_capability
            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["consume_big_bandwidth"] = consume_big_bandwidth
            __props__.__dict__["data_ident"] = data_ident
            __props__.__dict__["default"] = default
            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["evasive_behavior"] = evasive_behavior
            __props__.__dict__["file_type_ident"] = file_type_ident
            __props__.__dict__["folder"] = folder
            __props__.__dict__["has_known_vulnerability"] = has_known_vulnerability
            __props__.__dict__["name"] = name
            __props__.__dict__["no_appid_caching"] = no_appid_caching
            __props__.__dict__["parent_app"] = parent_app
            __props__.__dict__["pervasive_use"] = pervasive_use
            __props__.__dict__["prone_to_misuse"] = prone_to_misuse
            if risk is None and not opts.urn:
                raise TypeError("Missing required property 'risk'")
            __props__.__dict__["risk"] = risk
            __props__.__dict__["signatures"] = signatures
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["subcategory"] = subcategory
            __props__.__dict__["tcp_half_closed_timeout"] = tcp_half_closed_timeout
            __props__.__dict__["tcp_time_wait_timeout"] = tcp_time_wait_timeout
            __props__.__dict__["tcp_timeout"] = tcp_timeout
            __props__.__dict__["technology"] = technology
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tunnel_applications"] = tunnel_applications
            __props__.__dict__["tunnel_other_application"] = tunnel_other_application
            __props__.__dict__["udp_timeout"] = udp_timeout
            __props__.__dict__["used_by_malware"] = used_by_malware
            __props__.__dict__["virus_ident"] = virus_ident
            __props__.__dict__["tfid"] = None
        super(Application, __self__).__init__(
            'scm:index/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            able_to_transfer_file: Optional[pulumi.Input[_builtins.bool]] = None,
            alg_disable_capability: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            consume_big_bandwidth: Optional[pulumi.Input[_builtins.bool]] = None,
            data_ident: Optional[pulumi.Input[_builtins.bool]] = None,
            default: Optional[pulumi.Input[Union['ApplicationDefaultArgs', 'ApplicationDefaultArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            evasive_behavior: Optional[pulumi.Input[_builtins.bool]] = None,
            file_type_ident: Optional[pulumi.Input[_builtins.bool]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            has_known_vulnerability: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            no_appid_caching: Optional[pulumi.Input[_builtins.bool]] = None,
            parent_app: Optional[pulumi.Input[_builtins.str]] = None,
            pervasive_use: Optional[pulumi.Input[_builtins.bool]] = None,
            prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
            risk: Optional[pulumi.Input[_builtins.str]] = None,
            signatures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSignatureArgs', 'ApplicationSignatureArgsDict']]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            subcategory: Optional[pulumi.Input[_builtins.str]] = None,
            tcp_half_closed_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tcp_time_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tcp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            technology: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tunnel_applications: Optional[pulumi.Input[_builtins.bool]] = None,
            tunnel_other_application: Optional[pulumi.Input[_builtins.bool]] = None,
            udp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
            virus_ident: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] able_to_transfer_file: Able to transfer file
        :param pulumi.Input[_builtins.str] alg_disable_capability: Alg disable capability
        :param pulumi.Input[_builtins.str] category: Category
        :param pulumi.Input[_builtins.bool] consume_big_bandwidth: Consume big bandwidth
        :param pulumi.Input[_builtins.bool] data_ident: Data ident
        :param pulumi.Input[Union['ApplicationDefaultArgs', 'ApplicationDefaultArgsDict']] default: Default
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive_behavior: Evasive behavior
        :param pulumi.Input[_builtins.bool] file_type_ident: File type ident
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerability: Has known vulnerability
        :param pulumi.Input[_builtins.str] name: The name of the application
        :param pulumi.Input[_builtins.bool] no_appid_caching: No appid caching
        :param pulumi.Input[_builtins.str] parent_app: Parent app
        :param pulumi.Input[_builtins.bool] pervasive_use: Pervasive use
        :param pulumi.Input[_builtins.bool] prone_to_misuse: Prone to misuse
        :param pulumi.Input[_builtins.str] risk: Risk
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSignatureArgs', 'ApplicationSignatureArgsDict']]]] signatures: Signature
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subcategory: Subcategory
        :param pulumi.Input[_builtins.int] tcp_half_closed_timeout: timeout for half-close session in seconds
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout: timeout for session in time_wait state in seconds
        :param pulumi.Input[_builtins.int] tcp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.str] technology: Technology
        :param pulumi.Input[_builtins.int] timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] tunnel_applications: Tunnel applications
        :param pulumi.Input[_builtins.bool] tunnel_other_application: Tunnel other application
        :param pulumi.Input[_builtins.int] udp_timeout: timeout in seconds
        :param pulumi.Input[_builtins.bool] used_by_malware: Used by malware
        :param pulumi.Input[_builtins.bool] virus_ident: Virus ident
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["able_to_transfer_file"] = able_to_transfer_file
        __props__.__dict__["alg_disable_capability"] = alg_disable_capability
        __props__.__dict__["category"] = category
        __props__.__dict__["consume_big_bandwidth"] = consume_big_bandwidth
        __props__.__dict__["data_ident"] = data_ident
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["evasive_behavior"] = evasive_behavior
        __props__.__dict__["file_type_ident"] = file_type_ident
        __props__.__dict__["folder"] = folder
        __props__.__dict__["has_known_vulnerability"] = has_known_vulnerability
        __props__.__dict__["name"] = name
        __props__.__dict__["no_appid_caching"] = no_appid_caching
        __props__.__dict__["parent_app"] = parent_app
        __props__.__dict__["pervasive_use"] = pervasive_use
        __props__.__dict__["prone_to_misuse"] = prone_to_misuse
        __props__.__dict__["risk"] = risk
        __props__.__dict__["signatures"] = signatures
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["subcategory"] = subcategory
        __props__.__dict__["tcp_half_closed_timeout"] = tcp_half_closed_timeout
        __props__.__dict__["tcp_time_wait_timeout"] = tcp_time_wait_timeout
        __props__.__dict__["tcp_timeout"] = tcp_timeout
        __props__.__dict__["technology"] = technology
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tunnel_applications"] = tunnel_applications
        __props__.__dict__["tunnel_other_application"] = tunnel_other_application
        __props__.__dict__["udp_timeout"] = udp_timeout
        __props__.__dict__["used_by_malware"] = used_by_malware
        __props__.__dict__["virus_ident"] = virus_ident
        return Application(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ableToTransferFile")
    def able_to_transfer_file(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Able to transfer file
        """
        return pulumi.get(self, "able_to_transfer_file")

    @_builtins.property
    @pulumi.getter(name="algDisableCapability")
    def alg_disable_capability(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alg disable capability
        """
        return pulumi.get(self, "alg_disable_capability")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Category
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="consumeBigBandwidth")
    def consume_big_bandwidth(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Consume big bandwidth
        """
        return pulumi.get(self, "consume_big_bandwidth")

    @_builtins.property
    @pulumi.getter(name="dataIdent")
    def data_ident(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Data ident
        """
        return pulumi.get(self, "data_ident")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional['outputs.ApplicationDefault']]:
        """
        Default
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="evasiveBehavior")
    def evasive_behavior(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Evasive behavior
        """
        return pulumi.get(self, "evasive_behavior")

    @_builtins.property
    @pulumi.getter(name="fileTypeIdent")
    def file_type_ident(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        File type ident
        """
        return pulumi.get(self, "file_type_ident")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerability")
    def has_known_vulnerability(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Has known vulnerability
        """
        return pulumi.get(self, "has_known_vulnerability")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noAppidCaching")
    def no_appid_caching(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        No appid caching
        """
        return pulumi.get(self, "no_appid_caching")

    @_builtins.property
    @pulumi.getter(name="parentApp")
    def parent_app(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Parent app
        """
        return pulumi.get(self, "parent_app")

    @_builtins.property
    @pulumi.getter(name="pervasiveUse")
    def pervasive_use(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Pervasive use
        """
        return pulumi.get(self, "pervasive_use")

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Prone to misuse
        """
        return pulumi.get(self, "prone_to_misuse")

    @_builtins.property
    @pulumi.getter
    def risk(self) -> pulumi.Output[_builtins.str]:
        """
        Risk
        """
        return pulumi.get(self, "risk")

    @_builtins.property
    @pulumi.getter
    def signatures(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationSignature']]]:
        """
        Signature
        """
        return pulumi.get(self, "signatures")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def subcategory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategory")

    @_builtins.property
    @pulumi.getter(name="tcpHalfClosedTimeout")
    def tcp_half_closed_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        timeout for half-close session in seconds
        """
        return pulumi.get(self, "tcp_half_closed_timeout")

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeout")
    def tcp_time_wait_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        timeout for session in time_wait state in seconds
        """
        return pulumi.get(self, "tcp_time_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "tcp_timeout")

    @_builtins.property
    @pulumi.getter
    def technology(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Technology
        """
        return pulumi.get(self, "technology")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="tunnelApplications")
    def tunnel_applications(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Tunnel applications
        """
        return pulumi.get(self, "tunnel_applications")

    @_builtins.property
    @pulumi.getter(name="tunnelOtherApplication")
    def tunnel_other_application(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Tunnel other application
        """
        return pulumi.get(self, "tunnel_other_application")

    @_builtins.property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        timeout in seconds
        """
        return pulumi.get(self, "udp_timeout")

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Used by malware
        """
        return pulumi.get(self, "used_by_malware")

    @_builtins.property
    @pulumi.getter(name="virusIdent")
    def virus_ident(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Virus ident
        """
        return pulumi.get(self, "virus_ident")

