# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationFilterArgs', 'ApplicationFilter']

@pulumi.input_type
class ApplicationFilterArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 excessive_bandwidth_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerabilities: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_saas: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_appid: Optional[pulumi.Input[_builtins.bool]] = None,
                 pervasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 saas_certifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 saas_risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tagging: Optional[pulumi.Input['ApplicationFilterTaggingArgs']] = None,
                 technologies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transfers_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnels_other_apps: Optional[pulumi.Input[_builtins.bool]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ApplicationFilter resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Category
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] excessive_bandwidth_use: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Exclude
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerabilities: only True is a valid value
        :param pulumi.Input[_builtins.bool] is_saas: only True is a valid value
        :param pulumi.Input[_builtins.str] name: Alphanumeric string [ 0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.bool] new_appid: only True is a valid value
        :param pulumi.Input[_builtins.bool] pervasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] prone_to_misuse: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] risks: Risk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_certifications: Saas certifications
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_risks: Saas risk
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subcategories: Subcategory
        :param pulumi.Input['ApplicationFilterTaggingArgs'] tagging: Tagging
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technologies: Technology
        :param pulumi.Input[_builtins.bool] transfers_files: only True is a valid value
        :param pulumi.Input[_builtins.bool] tunnels_other_apps: only True is a valid value
        :param pulumi.Input[_builtins.bool] used_by_malware: only True is a valid value
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if evasive is not None:
            pulumi.set(__self__, "evasive", evasive)
        if excessive_bandwidth_use is not None:
            pulumi.set(__self__, "excessive_bandwidth_use", excessive_bandwidth_use)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if has_known_vulnerabilities is not None:
            pulumi.set(__self__, "has_known_vulnerabilities", has_known_vulnerabilities)
        if is_saas is not None:
            pulumi.set(__self__, "is_saas", is_saas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_appid is not None:
            pulumi.set(__self__, "new_appid", new_appid)
        if pervasive is not None:
            pulumi.set(__self__, "pervasive", pervasive)
        if prone_to_misuse is not None:
            pulumi.set(__self__, "prone_to_misuse", prone_to_misuse)
        if risks is not None:
            pulumi.set(__self__, "risks", risks)
        if saas_certifications is not None:
            pulumi.set(__self__, "saas_certifications", saas_certifications)
        if saas_risks is not None:
            pulumi.set(__self__, "saas_risks", saas_risks)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subcategories is not None:
            pulumi.set(__self__, "subcategories", subcategories)
        if tagging is not None:
            pulumi.set(__self__, "tagging", tagging)
        if technologies is not None:
            pulumi.set(__self__, "technologies", technologies)
        if transfers_files is not None:
            pulumi.set(__self__, "transfers_files", transfers_files)
        if tunnels_other_apps is not None:
            pulumi.set(__self__, "tunnels_other_apps", tunnels_other_apps)
        if used_by_malware is not None:
            pulumi.set(__self__, "used_by_malware", used_by_malware)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Category
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def evasive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "evasive")

    @evasive.setter
    def evasive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "evasive", value)

    @_builtins.property
    @pulumi.getter(name="excessiveBandwidthUse")
    def excessive_bandwidth_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "excessive_bandwidth_use")

    @excessive_bandwidth_use.setter
    def excessive_bandwidth_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "excessive_bandwidth_use", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Exclude
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerabilities")
    def has_known_vulnerabilities(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "has_known_vulnerabilities")

    @has_known_vulnerabilities.setter
    def has_known_vulnerabilities(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_known_vulnerabilities", value)

    @_builtins.property
    @pulumi.getter(name="isSaas")
    def is_saas(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "is_saas")

    @is_saas.setter
    def is_saas(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_saas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string [ 0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newAppid")
    def new_appid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "new_appid")

    @new_appid.setter
    def new_appid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_appid", value)

    @_builtins.property
    @pulumi.getter
    def pervasive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "pervasive")

    @pervasive.setter
    def pervasive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pervasive", value)

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "prone_to_misuse")

    @prone_to_misuse.setter
    def prone_to_misuse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prone_to_misuse", value)

    @_builtins.property
    @pulumi.getter
    def risks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Risk
        """
        return pulumi.get(self, "risks")

    @risks.setter
    def risks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "risks", value)

    @_builtins.property
    @pulumi.getter(name="saasCertifications")
    def saas_certifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Saas certifications
        """
        return pulumi.get(self, "saas_certifications")

    @saas_certifications.setter
    def saas_certifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "saas_certifications", value)

    @_builtins.property
    @pulumi.getter(name="saasRisks")
    def saas_risks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Saas risk
        """
        return pulumi.get(self, "saas_risks")

    @saas_risks.setter
    def saas_risks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "saas_risks", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subcategories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategories")

    @subcategories.setter
    def subcategories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subcategories", value)

    @_builtins.property
    @pulumi.getter
    def tagging(self) -> Optional[pulumi.Input['ApplicationFilterTaggingArgs']]:
        """
        Tagging
        """
        return pulumi.get(self, "tagging")

    @tagging.setter
    def tagging(self, value: Optional[pulumi.Input['ApplicationFilterTaggingArgs']]):
        pulumi.set(self, "tagging", value)

    @_builtins.property
    @pulumi.getter
    def technologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Technology
        """
        return pulumi.get(self, "technologies")

    @technologies.setter
    def technologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technologies", value)

    @_builtins.property
    @pulumi.getter(name="transfersFiles")
    def transfers_files(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "transfers_files")

    @transfers_files.setter
    def transfers_files(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transfers_files", value)

    @_builtins.property
    @pulumi.getter(name="tunnelsOtherApps")
    def tunnels_other_apps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "tunnels_other_apps")

    @tunnels_other_apps.setter
    def tunnels_other_apps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnels_other_apps", value)

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "used_by_malware")

    @used_by_malware.setter
    def used_by_malware(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_by_malware", value)


@pulumi.input_type
class _ApplicationFilterState:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 excessive_bandwidth_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerabilities: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_saas: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_appid: Optional[pulumi.Input[_builtins.bool]] = None,
                 pervasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 saas_certifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 saas_risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tagging: Optional[pulumi.Input['ApplicationFilterTaggingArgs']] = None,
                 technologies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 transfers_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnels_other_apps: Optional[pulumi.Input[_builtins.bool]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ApplicationFilter resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Category
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] excessive_bandwidth_use: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Exclude
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerabilities: only True is a valid value
        :param pulumi.Input[_builtins.bool] is_saas: only True is a valid value
        :param pulumi.Input[_builtins.str] name: Alphanumeric string [ 0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.bool] new_appid: only True is a valid value
        :param pulumi.Input[_builtins.bool] pervasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] prone_to_misuse: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] risks: Risk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_certifications: Saas certifications
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_risks: Saas risk
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subcategories: Subcategory
        :param pulumi.Input['ApplicationFilterTaggingArgs'] tagging: Tagging
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technologies: Technology
        :param pulumi.Input[_builtins.bool] transfers_files: only True is a valid value
        :param pulumi.Input[_builtins.bool] tunnels_other_apps: only True is a valid value
        :param pulumi.Input[_builtins.bool] used_by_malware: only True is a valid value
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if evasive is not None:
            pulumi.set(__self__, "evasive", evasive)
        if excessive_bandwidth_use is not None:
            pulumi.set(__self__, "excessive_bandwidth_use", excessive_bandwidth_use)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if has_known_vulnerabilities is not None:
            pulumi.set(__self__, "has_known_vulnerabilities", has_known_vulnerabilities)
        if is_saas is not None:
            pulumi.set(__self__, "is_saas", is_saas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_appid is not None:
            pulumi.set(__self__, "new_appid", new_appid)
        if pervasive is not None:
            pulumi.set(__self__, "pervasive", pervasive)
        if prone_to_misuse is not None:
            pulumi.set(__self__, "prone_to_misuse", prone_to_misuse)
        if risks is not None:
            pulumi.set(__self__, "risks", risks)
        if saas_certifications is not None:
            pulumi.set(__self__, "saas_certifications", saas_certifications)
        if saas_risks is not None:
            pulumi.set(__self__, "saas_risks", saas_risks)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subcategories is not None:
            pulumi.set(__self__, "subcategories", subcategories)
        if tagging is not None:
            pulumi.set(__self__, "tagging", tagging)
        if technologies is not None:
            pulumi.set(__self__, "technologies", technologies)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if transfers_files is not None:
            pulumi.set(__self__, "transfers_files", transfers_files)
        if tunnels_other_apps is not None:
            pulumi.set(__self__, "tunnels_other_apps", tunnels_other_apps)
        if used_by_malware is not None:
            pulumi.set(__self__, "used_by_malware", used_by_malware)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Category
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def evasive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "evasive")

    @evasive.setter
    def evasive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "evasive", value)

    @_builtins.property
    @pulumi.getter(name="excessiveBandwidthUse")
    def excessive_bandwidth_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "excessive_bandwidth_use")

    @excessive_bandwidth_use.setter
    def excessive_bandwidth_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "excessive_bandwidth_use", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Exclude
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerabilities")
    def has_known_vulnerabilities(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "has_known_vulnerabilities")

    @has_known_vulnerabilities.setter
    def has_known_vulnerabilities(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_known_vulnerabilities", value)

    @_builtins.property
    @pulumi.getter(name="isSaas")
    def is_saas(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "is_saas")

    @is_saas.setter
    def is_saas(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_saas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string [ 0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newAppid")
    def new_appid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "new_appid")

    @new_appid.setter
    def new_appid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_appid", value)

    @_builtins.property
    @pulumi.getter
    def pervasive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "pervasive")

    @pervasive.setter
    def pervasive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pervasive", value)

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "prone_to_misuse")

    @prone_to_misuse.setter
    def prone_to_misuse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prone_to_misuse", value)

    @_builtins.property
    @pulumi.getter
    def risks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Risk
        """
        return pulumi.get(self, "risks")

    @risks.setter
    def risks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "risks", value)

    @_builtins.property
    @pulumi.getter(name="saasCertifications")
    def saas_certifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Saas certifications
        """
        return pulumi.get(self, "saas_certifications")

    @saas_certifications.setter
    def saas_certifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "saas_certifications", value)

    @_builtins.property
    @pulumi.getter(name="saasRisks")
    def saas_risks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Saas risk
        """
        return pulumi.get(self, "saas_risks")

    @saas_risks.setter
    def saas_risks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "saas_risks", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subcategories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategories")

    @subcategories.setter
    def subcategories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subcategories", value)

    @_builtins.property
    @pulumi.getter
    def tagging(self) -> Optional[pulumi.Input['ApplicationFilterTaggingArgs']]:
        """
        Tagging
        """
        return pulumi.get(self, "tagging")

    @tagging.setter
    def tagging(self, value: Optional[pulumi.Input['ApplicationFilterTaggingArgs']]):
        pulumi.set(self, "tagging", value)

    @_builtins.property
    @pulumi.getter
    def technologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Technology
        """
        return pulumi.get(self, "technologies")

    @technologies.setter
    def technologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technologies", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="transfersFiles")
    def transfers_files(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "transfers_files")

    @transfers_files.setter
    def transfers_files(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transfers_files", value)

    @_builtins.property
    @pulumi.getter(name="tunnelsOtherApps")
    def tunnels_other_apps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "tunnels_other_apps")

    @tunnels_other_apps.setter
    def tunnels_other_apps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunnels_other_apps", value)

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "used_by_malware")

    @used_by_malware.setter
    def used_by_malware(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_by_malware", value)


@pulumi.type_token("scm:index/applicationFilter:ApplicationFilter")
class ApplicationFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 excessive_bandwidth_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerabilities: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_saas: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_appid: Optional[pulumi.Input[_builtins.bool]] = None,
                 pervasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 saas_certifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 saas_risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tagging: Optional[pulumi.Input[Union['ApplicationFilterTaggingArgs', 'ApplicationFilterTaggingArgsDict']]] = None,
                 technologies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transfers_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnels_other_apps: Optional[pulumi.Input[_builtins.bool]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ApplicationFilter resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_application_filter1 = scm.ApplicationFilter("scm_application_filter_1",
            folder="Shared",
            name="scm_application_filter_1",
            categories=["business-systems"],
            risks=[1],
            evasive=True,
            tagging={
                "no_tag": True,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Category
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] excessive_bandwidth_use: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Exclude
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerabilities: only True is a valid value
        :param pulumi.Input[_builtins.bool] is_saas: only True is a valid value
        :param pulumi.Input[_builtins.str] name: Alphanumeric string [ 0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.bool] new_appid: only True is a valid value
        :param pulumi.Input[_builtins.bool] pervasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] prone_to_misuse: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] risks: Risk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_certifications: Saas certifications
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_risks: Saas risk
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subcategories: Subcategory
        :param pulumi.Input[Union['ApplicationFilterTaggingArgs', 'ApplicationFilterTaggingArgsDict']] tagging: Tagging
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technologies: Technology
        :param pulumi.Input[_builtins.bool] transfers_files: only True is a valid value
        :param pulumi.Input[_builtins.bool] tunnels_other_apps: only True is a valid value
        :param pulumi.Input[_builtins.bool] used_by_malware: only True is a valid value
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationFilterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ApplicationFilter resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_application_filter1 = scm.ApplicationFilter("scm_application_filter_1",
            folder="Shared",
            name="scm_application_filter_1",
            categories=["business-systems"],
            risks=[1],
            evasive=True,
            tagging={
                "no_tag": True,
            })
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 evasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 excessive_bandwidth_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 has_known_vulnerabilities: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_saas: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_appid: Optional[pulumi.Input[_builtins.bool]] = None,
                 pervasive: Optional[pulumi.Input[_builtins.bool]] = None,
                 prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
                 risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 saas_certifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 saas_risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subcategories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tagging: Optional[pulumi.Input[Union['ApplicationFilterTaggingArgs', 'ApplicationFilterTaggingArgsDict']]] = None,
                 technologies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transfers_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 tunnels_other_apps: Optional[pulumi.Input[_builtins.bool]] = None,
                 used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationFilterArgs.__new__(ApplicationFilterArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["device"] = device
            __props__.__dict__["evasive"] = evasive
            __props__.__dict__["excessive_bandwidth_use"] = excessive_bandwidth_use
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["folder"] = folder
            __props__.__dict__["has_known_vulnerabilities"] = has_known_vulnerabilities
            __props__.__dict__["is_saas"] = is_saas
            __props__.__dict__["name"] = name
            __props__.__dict__["new_appid"] = new_appid
            __props__.__dict__["pervasive"] = pervasive
            __props__.__dict__["prone_to_misuse"] = prone_to_misuse
            __props__.__dict__["risks"] = risks
            __props__.__dict__["saas_certifications"] = saas_certifications
            __props__.__dict__["saas_risks"] = saas_risks
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["subcategories"] = subcategories
            __props__.__dict__["tagging"] = tagging
            __props__.__dict__["technologies"] = technologies
            __props__.__dict__["transfers_files"] = transfers_files
            __props__.__dict__["tunnels_other_apps"] = tunnels_other_apps
            __props__.__dict__["used_by_malware"] = used_by_malware
            __props__.__dict__["tfid"] = None
        super(ApplicationFilter, __self__).__init__(
            'scm:index/applicationFilter:ApplicationFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            evasive: Optional[pulumi.Input[_builtins.bool]] = None,
            excessive_bandwidth_use: Optional[pulumi.Input[_builtins.bool]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            has_known_vulnerabilities: Optional[pulumi.Input[_builtins.bool]] = None,
            is_saas: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_appid: Optional[pulumi.Input[_builtins.bool]] = None,
            pervasive: Optional[pulumi.Input[_builtins.bool]] = None,
            prone_to_misuse: Optional[pulumi.Input[_builtins.bool]] = None,
            risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            saas_certifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            saas_risks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            subcategories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tagging: Optional[pulumi.Input[Union['ApplicationFilterTaggingArgs', 'ApplicationFilterTaggingArgsDict']]] = None,
            technologies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            transfers_files: Optional[pulumi.Input[_builtins.bool]] = None,
            tunnels_other_apps: Optional[pulumi.Input[_builtins.bool]] = None,
            used_by_malware: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ApplicationFilter':
        """
        Get an existing ApplicationFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Category
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] evasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] excessive_bandwidth_use: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Exclude
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] has_known_vulnerabilities: only True is a valid value
        :param pulumi.Input[_builtins.bool] is_saas: only True is a valid value
        :param pulumi.Input[_builtins.str] name: Alphanumeric string [ 0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.bool] new_appid: only True is a valid value
        :param pulumi.Input[_builtins.bool] pervasive: only True is a valid value
        :param pulumi.Input[_builtins.bool] prone_to_misuse: only True is a valid value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] risks: Risk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_certifications: Saas certifications
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] saas_risks: Saas risk
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subcategories: Subcategory
        :param pulumi.Input[Union['ApplicationFilterTaggingArgs', 'ApplicationFilterTaggingArgsDict']] tagging: Tagging
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technologies: Technology
        :param pulumi.Input[_builtins.bool] transfers_files: only True is a valid value
        :param pulumi.Input[_builtins.bool] tunnels_other_apps: only True is a valid value
        :param pulumi.Input[_builtins.bool] used_by_malware: only True is a valid value
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationFilterState.__new__(_ApplicationFilterState)

        __props__.__dict__["categories"] = categories
        __props__.__dict__["device"] = device
        __props__.__dict__["evasive"] = evasive
        __props__.__dict__["excessive_bandwidth_use"] = excessive_bandwidth_use
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["folder"] = folder
        __props__.__dict__["has_known_vulnerabilities"] = has_known_vulnerabilities
        __props__.__dict__["is_saas"] = is_saas
        __props__.__dict__["name"] = name
        __props__.__dict__["new_appid"] = new_appid
        __props__.__dict__["pervasive"] = pervasive
        __props__.__dict__["prone_to_misuse"] = prone_to_misuse
        __props__.__dict__["risks"] = risks
        __props__.__dict__["saas_certifications"] = saas_certifications
        __props__.__dict__["saas_risks"] = saas_risks
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["subcategories"] = subcategories
        __props__.__dict__["tagging"] = tagging
        __props__.__dict__["technologies"] = technologies
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["transfers_files"] = transfers_files
        __props__.__dict__["tunnels_other_apps"] = tunnels_other_apps
        __props__.__dict__["used_by_malware"] = used_by_malware
        return ApplicationFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Category
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def evasive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "evasive")

    @_builtins.property
    @pulumi.getter(name="excessiveBandwidthUse")
    def excessive_bandwidth_use(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "excessive_bandwidth_use")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Exclude
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerabilities")
    def has_known_vulnerabilities(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "has_known_vulnerabilities")

    @_builtins.property
    @pulumi.getter(name="isSaas")
    def is_saas(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "is_saas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Alphanumeric string [ 0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newAppid")
    def new_appid(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "new_appid")

    @_builtins.property
    @pulumi.getter
    def pervasive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "pervasive")

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "prone_to_misuse")

    @_builtins.property
    @pulumi.getter
    def risks(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Risk
        """
        return pulumi.get(self, "risks")

    @_builtins.property
    @pulumi.getter(name="saasCertifications")
    def saas_certifications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Saas certifications
        """
        return pulumi.get(self, "saas_certifications")

    @_builtins.property
    @pulumi.getter(name="saasRisks")
    def saas_risks(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Saas risk
        """
        return pulumi.get(self, "saas_risks")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def subcategories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategories")

    @_builtins.property
    @pulumi.getter
    def tagging(self) -> pulumi.Output[Optional['outputs.ApplicationFilterTagging']]:
        """
        Tagging
        """
        return pulumi.get(self, "tagging")

    @_builtins.property
    @pulumi.getter
    def technologies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Technology
        """
        return pulumi.get(self, "technologies")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="transfersFiles")
    def transfers_files(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "transfers_files")

    @_builtins.property
    @pulumi.getter(name="tunnelsOtherApps")
    def tunnels_other_apps(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "tunnels_other_apps")

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        only True is a valid value
        """
        return pulumi.get(self, "used_by_malware")

