# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsProxyArgs', 'DnsProxy']

@pulumi.input_type
class DnsProxyArgs:
    def __init__(__self__, *,
                 default: pulumi.Input['DnsProxyDefaultArgs'],
                 cache: Optional[pulumi.Input['DnsProxyCacheArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_servers: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 static_entries: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]] = None,
                 tcp_queries: Optional[pulumi.Input['DnsProxyTcpQueriesArgs']] = None,
                 udp_queries: Optional[pulumi.Input['DnsProxyUdpQueriesArgs']] = None):
        """
        The set of arguments for constructing a DnsProxy resource.
        :param pulumi.Input['DnsProxyDefaultArgs'] default: Default
        :param pulumi.Input['DnsProxyCacheArgs'] cache: Cache
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]] domain_servers: DNS proxy rules
        :param pulumi.Input[_builtins.bool] enabled: Enable DNS proxy?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interfaces: Interfaces on which to enable DNS proxy service
        :param pulumi.Input[_builtins.str] name: DNS proxy name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]] static_entries: Static entries
        :param pulumi.Input['DnsProxyTcpQueriesArgs'] tcp_queries: Tcp queries
        :param pulumi.Input['DnsProxyUdpQueriesArgs'] udp_queries: Udp queries
        """
        pulumi.set(__self__, "default", default)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if domain_servers is not None:
            pulumi.set(__self__, "domain_servers", domain_servers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if static_entries is not None:
            pulumi.set(__self__, "static_entries", static_entries)
        if tcp_queries is not None:
            pulumi.set(__self__, "tcp_queries", tcp_queries)
        if udp_queries is not None:
            pulumi.set(__self__, "udp_queries", udp_queries)

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Input['DnsProxyDefaultArgs']:
        """
        Default
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: pulumi.Input['DnsProxyDefaultArgs']):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['DnsProxyCacheArgs']]:
        """
        Cache
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['DnsProxyCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="domainServers")
    def domain_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]]:
        """
        DNS proxy rules
        """
        return pulumi.get(self, "domain_servers")

    @domain_servers.setter
    def domain_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]]):
        pulumi.set(self, "domain_servers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DNS proxy?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Interfaces on which to enable DNS proxy service
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS proxy name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="staticEntries")
    def static_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]]:
        """
        Static entries
        """
        return pulumi.get(self, "static_entries")

    @static_entries.setter
    def static_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]]):
        pulumi.set(self, "static_entries", value)

    @_builtins.property
    @pulumi.getter(name="tcpQueries")
    def tcp_queries(self) -> Optional[pulumi.Input['DnsProxyTcpQueriesArgs']]:
        """
        Tcp queries
        """
        return pulumi.get(self, "tcp_queries")

    @tcp_queries.setter
    def tcp_queries(self, value: Optional[pulumi.Input['DnsProxyTcpQueriesArgs']]):
        pulumi.set(self, "tcp_queries", value)

    @_builtins.property
    @pulumi.getter(name="udpQueries")
    def udp_queries(self) -> Optional[pulumi.Input['DnsProxyUdpQueriesArgs']]:
        """
        Udp queries
        """
        return pulumi.get(self, "udp_queries")

    @udp_queries.setter
    def udp_queries(self, value: Optional[pulumi.Input['DnsProxyUdpQueriesArgs']]):
        pulumi.set(self, "udp_queries", value)


@pulumi.input_type
class _DnsProxyState:
    def __init__(__self__, *,
                 cache: Optional[pulumi.Input['DnsProxyCacheArgs']] = None,
                 default: Optional[pulumi.Input['DnsProxyDefaultArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_servers: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 static_entries: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]] = None,
                 tcp_queries: Optional[pulumi.Input['DnsProxyTcpQueriesArgs']] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_queries: Optional[pulumi.Input['DnsProxyUdpQueriesArgs']] = None):
        """
        Input properties used for looking up and filtering DnsProxy resources.
        :param pulumi.Input['DnsProxyCacheArgs'] cache: Cache
        :param pulumi.Input['DnsProxyDefaultArgs'] default: Default
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]] domain_servers: DNS proxy rules
        :param pulumi.Input[_builtins.bool] enabled: Enable DNS proxy?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interfaces: Interfaces on which to enable DNS proxy service
        :param pulumi.Input[_builtins.str] name: DNS proxy name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]] static_entries: Static entries
        :param pulumi.Input['DnsProxyTcpQueriesArgs'] tcp_queries: Tcp queries
        :param pulumi.Input['DnsProxyUdpQueriesArgs'] udp_queries: Udp queries
        """
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if domain_servers is not None:
            pulumi.set(__self__, "domain_servers", domain_servers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if static_entries is not None:
            pulumi.set(__self__, "static_entries", static_entries)
        if tcp_queries is not None:
            pulumi.set(__self__, "tcp_queries", tcp_queries)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if udp_queries is not None:
            pulumi.set(__self__, "udp_queries", udp_queries)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['DnsProxyCacheArgs']]:
        """
        Cache
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['DnsProxyCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input['DnsProxyDefaultArgs']]:
        """
        Default
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input['DnsProxyDefaultArgs']]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="domainServers")
    def domain_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]]:
        """
        DNS proxy rules
        """
        return pulumi.get(self, "domain_servers")

    @domain_servers.setter
    def domain_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyDomainServerArgs']]]]):
        pulumi.set(self, "domain_servers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DNS proxy?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Interfaces on which to enable DNS proxy service
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS proxy name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="staticEntries")
    def static_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]]:
        """
        Static entries
        """
        return pulumi.get(self, "static_entries")

    @static_entries.setter
    def static_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsProxyStaticEntryArgs']]]]):
        pulumi.set(self, "static_entries", value)

    @_builtins.property
    @pulumi.getter(name="tcpQueries")
    def tcp_queries(self) -> Optional[pulumi.Input['DnsProxyTcpQueriesArgs']]:
        """
        Tcp queries
        """
        return pulumi.get(self, "tcp_queries")

    @tcp_queries.setter
    def tcp_queries(self, value: Optional[pulumi.Input['DnsProxyTcpQueriesArgs']]):
        pulumi.set(self, "tcp_queries", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="udpQueries")
    def udp_queries(self) -> Optional[pulumi.Input['DnsProxyUdpQueriesArgs']]:
        """
        Udp queries
        """
        return pulumi.get(self, "udp_queries")

    @udp_queries.setter
    def udp_queries(self, value: Optional[pulumi.Input['DnsProxyUdpQueriesArgs']]):
        pulumi.set(self, "udp_queries", value)


@pulumi.type_token("scm:index/dnsProxy:DnsProxy")
class DnsProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Union['DnsProxyCacheArgs', 'DnsProxyCacheArgsDict']]] = None,
                 default: Optional[pulumi.Input[Union['DnsProxyDefaultArgs', 'DnsProxyDefaultArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyDomainServerArgs', 'DnsProxyDomainServerArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 static_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyStaticEntryArgs', 'DnsProxyStaticEntryArgsDict']]]]] = None,
                 tcp_queries: Optional[pulumi.Input[Union['DnsProxyTcpQueriesArgs', 'DnsProxyTcpQueriesArgsDict']]] = None,
                 udp_queries: Optional[pulumi.Input[Union['DnsProxyUdpQueriesArgs', 'DnsProxyUdpQueriesArgsDict']]] = None,
                 __props__=None):
        """
        DnsProxy resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DnsProxyCacheArgs', 'DnsProxyCacheArgsDict']] cache: Cache
        :param pulumi.Input[Union['DnsProxyDefaultArgs', 'DnsProxyDefaultArgsDict']] default: Default
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyDomainServerArgs', 'DnsProxyDomainServerArgsDict']]]] domain_servers: DNS proxy rules
        :param pulumi.Input[_builtins.bool] enabled: Enable DNS proxy?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interfaces: Interfaces on which to enable DNS proxy service
        :param pulumi.Input[_builtins.str] name: DNS proxy name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyStaticEntryArgs', 'DnsProxyStaticEntryArgsDict']]]] static_entries: Static entries
        :param pulumi.Input[Union['DnsProxyTcpQueriesArgs', 'DnsProxyTcpQueriesArgsDict']] tcp_queries: Tcp queries
        :param pulumi.Input[Union['DnsProxyUdpQueriesArgs', 'DnsProxyUdpQueriesArgsDict']] udp_queries: Udp queries
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DnsProxy resource

        :param str resource_name: The name of the resource.
        :param DnsProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Union['DnsProxyCacheArgs', 'DnsProxyCacheArgsDict']]] = None,
                 default: Optional[pulumi.Input[Union['DnsProxyDefaultArgs', 'DnsProxyDefaultArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyDomainServerArgs', 'DnsProxyDomainServerArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 static_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyStaticEntryArgs', 'DnsProxyStaticEntryArgsDict']]]]] = None,
                 tcp_queries: Optional[pulumi.Input[Union['DnsProxyTcpQueriesArgs', 'DnsProxyTcpQueriesArgsDict']]] = None,
                 udp_queries: Optional[pulumi.Input[Union['DnsProxyUdpQueriesArgs', 'DnsProxyUdpQueriesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsProxyArgs.__new__(DnsProxyArgs)

            __props__.__dict__["cache"] = cache
            if default is None and not opts.urn:
                raise TypeError("Missing required property 'default'")
            __props__.__dict__["default"] = default
            __props__.__dict__["device"] = device
            __props__.__dict__["domain_servers"] = domain_servers
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["folder"] = folder
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["static_entries"] = static_entries
            __props__.__dict__["tcp_queries"] = tcp_queries
            __props__.__dict__["udp_queries"] = udp_queries
            __props__.__dict__["tfid"] = None
        super(DnsProxy, __self__).__init__(
            'scm:index/dnsProxy:DnsProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache: Optional[pulumi.Input[Union['DnsProxyCacheArgs', 'DnsProxyCacheArgsDict']]] = None,
            default: Optional[pulumi.Input[Union['DnsProxyDefaultArgs', 'DnsProxyDefaultArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            domain_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyDomainServerArgs', 'DnsProxyDomainServerArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            static_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyStaticEntryArgs', 'DnsProxyStaticEntryArgsDict']]]]] = None,
            tcp_queries: Optional[pulumi.Input[Union['DnsProxyTcpQueriesArgs', 'DnsProxyTcpQueriesArgsDict']]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            udp_queries: Optional[pulumi.Input[Union['DnsProxyUdpQueriesArgs', 'DnsProxyUdpQueriesArgsDict']]] = None) -> 'DnsProxy':
        """
        Get an existing DnsProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DnsProxyCacheArgs', 'DnsProxyCacheArgsDict']] cache: Cache
        :param pulumi.Input[Union['DnsProxyDefaultArgs', 'DnsProxyDefaultArgsDict']] default: Default
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyDomainServerArgs', 'DnsProxyDomainServerArgsDict']]]] domain_servers: DNS proxy rules
        :param pulumi.Input[_builtins.bool] enabled: Enable DNS proxy?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interfaces: Interfaces on which to enable DNS proxy service
        :param pulumi.Input[_builtins.str] name: DNS proxy name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsProxyStaticEntryArgs', 'DnsProxyStaticEntryArgsDict']]]] static_entries: Static entries
        :param pulumi.Input[Union['DnsProxyTcpQueriesArgs', 'DnsProxyTcpQueriesArgsDict']] tcp_queries: Tcp queries
        :param pulumi.Input[Union['DnsProxyUdpQueriesArgs', 'DnsProxyUdpQueriesArgsDict']] udp_queries: Udp queries
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsProxyState.__new__(_DnsProxyState)

        __props__.__dict__["cache"] = cache
        __props__.__dict__["default"] = default
        __props__.__dict__["device"] = device
        __props__.__dict__["domain_servers"] = domain_servers
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["folder"] = folder
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["static_entries"] = static_entries
        __props__.__dict__["tcp_queries"] = tcp_queries
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["udp_queries"] = udp_queries
        return DnsProxy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> pulumi.Output['outputs.DnsProxyCache']:
        """
        Cache
        """
        return pulumi.get(self, "cache")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output['outputs.DnsProxyDefault']:
        """
        Default
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="domainServers")
    def domain_servers(self) -> pulumi.Output[Optional[Sequence['outputs.DnsProxyDomainServer']]]:
        """
        DNS proxy rules
        """
        return pulumi.get(self, "domain_servers")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable DNS proxy?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Interfaces on which to enable DNS proxy service
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS proxy name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="staticEntries")
    def static_entries(self) -> pulumi.Output[Optional[Sequence['outputs.DnsProxyStaticEntry']]]:
        """
        Static entries
        """
        return pulumi.get(self, "static_entries")

    @_builtins.property
    @pulumi.getter(name="tcpQueries")
    def tcp_queries(self) -> pulumi.Output['outputs.DnsProxyTcpQueries']:
        """
        Tcp queries
        """
        return pulumi.get(self, "tcp_queries")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="udpQueries")
    def udp_queries(self) -> pulumi.Output['outputs.DnsProxyUdpQueries']:
        """
        Udp queries
        """
        return pulumi.get(self, "udp_queries")

